/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.management.SerializableConnectionManagerBean;
import com.hazelcast.management.SerializableEventServiceBean;
import com.hazelcast.management.SerializableMXBeans;
import com.hazelcast.management.SerializableManagedExecutorBean;
import com.hazelcast.management.SerializableOperationServiceBean;
import com.hazelcast.management.SerializablePartitionServiceBean;
import com.hazelcast.management.SerializableProxyServiceBean;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;

final class TimedMemberStateFactoryHelper {
    private static final int PERCENT_MULTIPLIER = 100;

    private TimedMemberStateFactoryHelper() {
    }

    static void registerJMXBeans(HazelcastInstanceImpl instance, MemberStateImpl memberState) {
        EventService es = instance.node.nodeEngine.getEventService();
        OperationService os = instance.node.nodeEngine.getOperationService();
        ConnectionManager cm = instance.node.connectionManager;
        InternalPartitionService ps = instance.node.partitionService;
        ProxyService proxyService = instance.node.nodeEngine.getProxyService();
        ExecutionService executionService = instance.node.nodeEngine.getExecutionService();
        SerializableMXBeans beans = new SerializableMXBeans();
        SerializableEventServiceBean esBean = new SerializableEventServiceBean(es);
        beans.setEventServiceBean(esBean);
        SerializableOperationServiceBean osBean = new SerializableOperationServiceBean(os);
        beans.setOperationServiceBean(osBean);
        SerializableConnectionManagerBean cmBean = new SerializableConnectionManagerBean(cm);
        beans.setConnectionManagerBean(cmBean);
        SerializablePartitionServiceBean psBean = new SerializablePartitionServiceBean(ps, instance);
        beans.setPartitionServiceBean(psBean);
        SerializableProxyServiceBean proxyServiceBean = new SerializableProxyServiceBean(proxyService);
        beans.setProxyServiceBean(proxyServiceBean);
        ManagedExecutorService systemExecutor = executionService.getExecutor("hz:system");
        ManagedExecutorService asyncExecutor = executionService.getExecutor("hz:async");
        ManagedExecutorService scheduledExecutor = executionService.getExecutor("hz:scheduled");
        ManagedExecutorService clientExecutor = executionService.getExecutor("hz:client");
        ManagedExecutorService queryExecutor = executionService.getExecutor("hz:query");
        ManagedExecutorService ioExecutor = executionService.getExecutor("hz:io");
        SerializableManagedExecutorBean systemExecutorBean = new SerializableManagedExecutorBean(systemExecutor);
        SerializableManagedExecutorBean asyncExecutorBean = new SerializableManagedExecutorBean(asyncExecutor);
        SerializableManagedExecutorBean scheduledExecutorBean = new SerializableManagedExecutorBean(scheduledExecutor);
        SerializableManagedExecutorBean clientExecutorBean = new SerializableManagedExecutorBean(clientExecutor);
        SerializableManagedExecutorBean queryExecutorBean = new SerializableManagedExecutorBean(queryExecutor);
        SerializableManagedExecutorBean ioExecutorBean = new SerializableManagedExecutorBean(ioExecutor);
        beans.putManagedExecutor("hz:system", systemExecutorBean);
        beans.putManagedExecutor("hz:async", asyncExecutorBean);
        beans.putManagedExecutor("hz:scheduled", scheduledExecutorBean);
        beans.putManagedExecutor("hz:client", clientExecutorBean);
        beans.putManagedExecutor("hz:query", queryExecutorBean);
        beans.putManagedExecutor("hz:io", ioExecutorBean);
        memberState.setBeans(beans);
    }

    static void createRuntimeProps(MemberStateImpl memberState) {
        Runtime runtime = Runtime.getRuntime();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ClassLoadingMXBean clMxBean = ManagementFactory.getClassLoadingMXBean();
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemory = memoryMxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemory = memoryMxBean.getNonHeapMemoryUsage();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("runtime.availableProcessors", Integer.valueOf(runtime.availableProcessors()).longValue());
        map.put("date.startTime", runtimeMxBean.getStartTime());
        map.put("seconds.upTime", runtimeMxBean.getUptime());
        map.put("memory.maxMemory", runtime.maxMemory());
        map.put("memory.freeMemory", runtime.freeMemory());
        map.put("memory.totalMemory", runtime.totalMemory());
        map.put("memory.heapMemoryMax", heapMemory.getMax());
        map.put("memory.heapMemoryUsed", heapMemory.getUsed());
        map.put("memory.nonHeapMemoryMax", nonHeapMemory.getMax());
        map.put("memory.nonHeapMemoryUsed", nonHeapMemory.getUsed());
        map.put("runtime.totalLoadedClassCount", clMxBean.getTotalLoadedClassCount());
        map.put("runtime.loadedClassCount", Integer.valueOf(clMxBean.getLoadedClassCount()).longValue());
        map.put("runtime.unloadedClassCount", clMxBean.getUnloadedClassCount());
        map.put("runtime.totalStartedThreadCount", threadMxBean.getTotalStartedThreadCount());
        map.put("runtime.threadCount", Integer.valueOf(threadMxBean.getThreadCount()).longValue());
        map.put("runtime.peakThreadCount", Integer.valueOf(threadMxBean.getPeakThreadCount()).longValue());
        map.put("runtime.daemonThreadCount", Integer.valueOf(threadMxBean.getDaemonThreadCount()).longValue());
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        map.put("osMemory.freePhysicalMemory", TimedMemberStateFactoryHelper.get(osMxBean, "getFreePhysicalMemorySize", 0L));
        map.put("osMemory.committedVirtualMemory", TimedMemberStateFactoryHelper.get(osMxBean, "getCommittedVirtualMemorySize", 0L));
        map.put("osMemory.totalPhysicalMemory", TimedMemberStateFactoryHelper.get(osMxBean, "getTotalPhysicalMemorySize", 0L));
        map.put("osSwap.freeSwapSpace", TimedMemberStateFactoryHelper.get(osMxBean, "getFreeSwapSpaceSize", 0L));
        map.put("osSwap.totalSwapSpace", TimedMemberStateFactoryHelper.get(osMxBean, "getTotalSwapSpaceSize", 0L));
        map.put("os.maxFileDescriptorCount", TimedMemberStateFactoryHelper.get(osMxBean, "getMaxFileDescriptorCount", 0L));
        map.put("os.openFileDescriptorCount", TimedMemberStateFactoryHelper.get(osMxBean, "getOpenFileDescriptorCount", 0L));
        map.put("os.processCpuLoad", TimedMemberStateFactoryHelper.get(osMxBean, "getProcessCpuLoad", -1L));
        map.put("os.systemLoadAverage", TimedMemberStateFactoryHelper.get(osMxBean, "getSystemLoadAverage", -1L));
        map.put("os.systemCpuLoad", TimedMemberStateFactoryHelper.get(osMxBean, "getSystemCpuLoad", -1L));
        map.put("os.processCpuTime", TimedMemberStateFactoryHelper.get(osMxBean, "getProcessCpuTime", 0L));
        map.put("os.availableProcessors", TimedMemberStateFactoryHelper.get(osMxBean, "getAvailableProcessors", 0L));
        memberState.setRuntimeProps(map);
    }

    private static Long get(OperatingSystemMXBean mbean, String methodName, Long defaultValue) {
        try {
            Method method = mbean.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)mbean, new Object[0]);
            if (value instanceof Integer) {
                return (long)((Integer)value);
            }
            if (value instanceof Double) {
                double v = (Double)value;
                return Math.round(v * 100.0);
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return defaultValue;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

