/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.impl.MapContextQuerySupport;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.QueryOperation;
import com.hazelcast.map.impl.operation.QueryPartitionOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.SortedQueryResultSet;
import com.hazelcast.util.SortingUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class BasicMapContextQuerySupport
implements MapContextQuerySupport {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public BasicMapContextQuerySupport(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public Collection<QueryableEntry> queryOnPartition(String mapName, Predicate predicate, int partitionId) {
        long now = this.getNow();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(partitionId);
        RecordStore recordStore = container.getRecordStore(mapName);
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        PagingPredicate pagingPredicate = predicate instanceof PagingPredicate ? (PagingPredicate)predicate : null;
        LinkedList<QueryEntry> list = new LinkedList<QueryEntry>();
        Iterator<Record> iterator = recordStore.loadAwareIterator(now, false);
        while (iterator.hasNext()) {
            Map.Entry anchor;
            QueryEntry queryEntry;
            Record record = iterator.next();
            Data key = record.getKey();
            Object value = this.getValueOrCachedValue(record);
            if (value == null || !predicate.apply(queryEntry = new QueryEntry(serializationService, key, key, value)) || pagingPredicate != null && (anchor = pagingPredicate.getAnchor()) != null && SortingUtil.compare(pagingPredicate.getComparator(), pagingPredicate.getIterationType(), anchor, queryEntry) >= 0) continue;
            list.add(queryEntry);
        }
        return this.getPage(list, pagingPredicate);
    }

    private Object getValueOrCachedValue(Record record) {
        Object value = record.getCachedValue();
        if (value == Record.NOT_CACHED) {
            value = record.getValue();
        } else if (value == null && (value = record.getValue()) instanceof Data && !((Data)value).isPortable()) {
            value = this.nodeEngine.getSerializationService().toObject(value);
            record.setCachedValue(value);
        }
        return value;
    }

    @Override
    public Set queryLocalMember(String mapName, Predicate predicate, IterationType iterationType, boolean dataResult) {
        this.checkIfNotPagingPredicate(predicate);
        NodeEngine nodeEngine = this.nodeEngine;
        List<Integer> partitionIds = this.getLocalPartitionIds(nodeEngine);
        SerializationService serializationService = nodeEngine.getSerializationService();
        QueryResultSet result = new QueryResultSet(serializationService, iterationType, dataResult);
        try {
            Future future = this.queryOnLocalMember(mapName, predicate, nodeEngine);
            List<Future> futures = Collections.singletonList(future);
            this.addResultsOfPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                return result;
            }
        }
        catch (Throwable t) {
            nodeEngine.getLogger(this.getClass()).warning("Could not get results", t);
        }
        try {
            List<Future> futures = this.queryOnPartitions(mapName, predicate, partitionIds, nodeEngine);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    @Override
    public Set queryLocalMemberWithPagingPredicate(String mapName, PagingPredicate pagingPredicate, IterationType iterationType) {
        NodeEngine nodeEngine = this.nodeEngine;
        List<Integer> partitionIds = this.getLocalPartitionIds(nodeEngine);
        pagingPredicate.setIterationType(iterationType);
        this.setPreviousPagesAnchorsOnLocalMember(mapName, pagingPredicate, iterationType);
        SortedQueryResultSet result = new SortedQueryResultSet(pagingPredicate.getComparator(), iterationType, pagingPredicate.getPageSize());
        try {
            Future future = this.queryOnLocalMember(mapName, pagingPredicate, nodeEngine);
            List<Future> futures = Collections.singletonList(future);
            this.addResultsOfPagingPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, result.last());
                return result;
            }
        }
        catch (Throwable t) {
            nodeEngine.getLogger(this.getClass()).warning("Could not get results", t);
        }
        try {
            List<Future> futures = this.queryOnPartitions(mapName, pagingPredicate, partitionIds, nodeEngine);
            this.addResultsOfPagingPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    @Override
    public Set queryWithPagingPredicate(String mapName, PagingPredicate pagingPredicate, IterationType iterationType) {
        List<Future> futures;
        NodeEngine nodeEngine = this.nodeEngine;
        Set<Integer> partitionIds = this.getAllPartitionIds(nodeEngine);
        pagingPredicate.setIterationType(iterationType);
        this.setPreviousPagesAnchors(mapName, pagingPredicate, iterationType);
        SortedQueryResultSet result = new SortedQueryResultSet(pagingPredicate.getComparator(), iterationType, pagingPredicate.getPageSize());
        try {
            futures = this.queryOnMembers(mapName, pagingPredicate, nodeEngine);
            this.addResultsOfPagingPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, result.last());
                return result;
            }
        }
        catch (Throwable t) {
            nodeEngine.getLogger(this.getClass()).warning("Could not get results", t);
        }
        try {
            futures = this.queryOnPartitions(mapName, pagingPredicate, partitionIds, nodeEngine);
            this.addResultsOfPagingPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, result.last());
        return result;
    }

    @Override
    public Set query(String mapName, Predicate predicate, IterationType iterationType, boolean dataResult) {
        List<Future> futures;
        this.checkIfNotPagingPredicate(predicate);
        NodeEngine nodeEngine = this.nodeEngine;
        SerializationService serializationService = nodeEngine.getSerializationService();
        Set<Integer> partitionIds = this.getAllPartitionIds(nodeEngine);
        QueryResultSet result = new QueryResultSet(serializationService, iterationType, dataResult);
        try {
            futures = this.queryOnMembers(mapName, predicate, nodeEngine);
            this.addResultsOfPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                return result;
            }
        }
        catch (Throwable t) {
            nodeEngine.getLogger(this.getClass()).warning("Could not get results", t);
        }
        try {
            futures = this.queryOnPartitions(mapName, predicate, partitionIds, nodeEngine);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    private Future queryOnLocalMember(String mapName, Predicate predicate, NodeEngine nodeEngine) {
        OperationService operationService = nodeEngine.getOperationService();
        return operationService.invokeOnTarget("hz:impl:mapService", new QueryOperation(mapName, predicate), nodeEngine.getThisAddress());
    }

    private List<Future> queryOnMembers(String mapName, Predicate predicate, NodeEngine nodeEngine) {
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>(members.size());
        OperationService operationService = nodeEngine.getOperationService();
        for (MemberImpl member : members) {
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:mapService", new QueryOperation(mapName, predicate), member.getAddress());
            futures.add(future);
        }
        return futures;
    }

    private List<Future> queryOnPartitions(String mapName, Predicate predicate, Collection<Integer> partitionIds, NodeEngine nodeEngine) {
        if (partitionIds == null || partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        OperationService operationService = nodeEngine.getOperationService();
        ArrayList<Future> futures = new ArrayList<Future>(partitionIds.size());
        for (Integer partitionId : partitionIds) {
            QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(mapName, predicate);
            queryPartitionOperation.setPartitionId(partitionId);
            try {
                InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, partitionId);
                futures.add(f);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return futures;
    }

    private void addResultsOfPagingPredicate(List<Future> futures, Set result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future future : futures) {
            Collection<Integer> tmpPartitionIds;
            QueryResult queryResult = this.getQueryResult(future);
            if (queryResult == null || (tmpPartitionIds = queryResult.getPartitionIds()) == null) continue;
            partitionIds.removeAll(tmpPartitionIds);
            for (QueryResultEntry queryResultEntry : queryResult.getResult()) {
                Object key = this.toObject(queryResultEntry.getKeyData());
                Object value = this.toObject(queryResultEntry.getValueData());
                result.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
            }
        }
    }

    private void addResultsOfPredicate(List<Future> futures, Set result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future future : futures) {
            Collection<Integer> queriedPartitionIds;
            QueryResult queryResult = this.getQueryResult(future);
            if (queryResult == null || (queriedPartitionIds = queryResult.getPartitionIds()) == null) continue;
            partitionIds.removeAll(queriedPartitionIds);
            result.addAll(queryResult.getResult());
        }
    }

    private QueryResult getQueryResult(Future future) throws ExecutionException, InterruptedException {
        return (QueryResult)future.get();
    }

    private Object toObject(Object obj) {
        return this.nodeEngine.getSerializationService().toObject(obj);
    }

    private List<Integer> getLocalPartitionIds(NodeEngine nodeEngine) {
        return nodeEngine.getPartitionService().getMemberPartitions(nodeEngine.getThisAddress());
    }

    private Set<Integer> getAllPartitionIds(NodeEngine nodeEngine) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        return this.createSetWithPopulatedPartitionIds(partitionCount);
    }

    private Set<Integer> createSetWithPopulatedPartitionIds(int partitionCount) {
        HashSet<Integer> partitionIds = new HashSet<Integer>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            partitionIds.add(i);
        }
        return partitionIds;
    }

    private List getPage(List<QueryEntry> list, PagingPredicate pagingPredicate) {
        if (pagingPredicate == null) {
            return list;
        }
        Comparator<Map.Entry> wrapperComparator = SortingUtil.newComparator(pagingPredicate);
        Collections.sort(list, wrapperComparator);
        if (list.size() > pagingPredicate.getPageSize()) {
            list = list.subList(0, pagingPredicate.getPageSize());
        }
        return list;
    }

    private void checkIfNotPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("Predicate should not be a type of paging predicate");
        }
    }

    private void setPreviousPagesAnchorsOnLocalMember(String mapName, PagingPredicate pagingPredicate, IterationType iterationType) {
        if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
            pagingPredicate.previousPage();
            this.queryLocalMemberWithPagingPredicate(mapName, pagingPredicate, iterationType);
            pagingPredicate.nextPage();
        }
    }

    private void setPreviousPagesAnchors(String mapName, PagingPredicate pagingPredicate, IterationType iterationType) {
        if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
            pagingPredicate.previousPage();
            this.queryWithPagingPredicate(mapName, pagingPredicate, iterationType);
            pagingPredicate.nextPage();
        }
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }
}

