/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.query.PagingPredicate;
import com.hazelcast.util.IterationType;
import java.util.Comparator;
import java.util.Map;

public final class SortingUtil {
    private SortingUtil() {
    }

    public static boolean isSuitableForCompare(Comparator<Map.Entry> comparator, IterationType iterationType, Map.Entry entry) {
        Object comparable;
        if (comparator != null) {
            return true;
        }
        switch (iterationType) {
            case KEY: {
                comparable = entry.getKey();
                break;
            }
            case VALUE: {
                comparable = entry.getValue();
                break;
            }
            default: {
                comparable = entry instanceof Comparable ? entry : entry.getKey();
            }
        }
        return comparable instanceof Comparable;
    }

    public static int compare(Comparator<Map.Entry> comparator, IterationType iterationType, Map.Entry entry1, Map.Entry entry2) {
        Object comparable2;
        Object comparable1;
        if (comparator != null) {
            int result = comparator.compare(entry1, entry2);
            if (result != 0) {
                return result;
            }
            return SortingUtil.compareIntegers(entry1.getKey().hashCode(), entry2.getKey().hashCode());
        }
        switch (iterationType) {
            case KEY: {
                comparable1 = entry1.getKey();
                comparable2 = entry2.getKey();
                break;
            }
            case VALUE: {
                comparable1 = entry1.getValue();
                comparable2 = entry2.getValue();
                break;
            }
            default: {
                if (entry1 instanceof Comparable && entry2 instanceof Comparable) {
                    comparable1 = entry1;
                    comparable2 = entry2;
                    break;
                }
                comparable1 = entry1.getKey();
                comparable2 = entry2.getKey();
            }
        }
        int result = comparable1 instanceof Comparable && comparable2 instanceof Comparable ? ((Comparable)comparable1).compareTo(comparable2) : SortingUtil.compareIntegers(comparable1.hashCode(), comparable2.hashCode());
        if (result != 0) {
            return result;
        }
        return SortingUtil.compareIntegers(entry1.getKey().hashCode(), entry2.getKey().hashCode());
    }

    private static int compareIntegers(int i1, int i2) {
        if (i1 > i2) {
            return 1;
        }
        if (i2 > i1) {
            return -1;
        }
        return 0;
    }

    public static Comparator<Map.Entry> newComparator(final Comparator<Map.Entry> comparator, final IterationType iterationType) {
        return new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry entry1, Map.Entry entry2) {
                return SortingUtil.compare(comparator, iterationType, entry1, entry2);
            }
        };
    }

    public static Comparator<Map.Entry> newComparator(final PagingPredicate pagingPredicate) {
        return new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry entry1, Map.Entry entry2) {
                return SortingUtil.compare(pagingPredicate.getComparator(), pagingPredicate.getIterationType(), entry1, entry2);
            }
        };
    }
}

