/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.executor.CompletableFutureTask;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ClientExecutionServiceImpl
implements ClientExecutionService {
    private static final ILogger LOGGER = Logger.getLogger(ClientExecutionService.class);
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private final ExecutorService executor;
    private final ExecutorService internalExecutor;
    private final ScheduledExecutorService scheduledExecutor;

    public ClientExecutionServiceImpl(String name, ThreadGroup threadGroup, ClassLoader classLoader, int poolSize) {
        int executorPoolSize = poolSize;
        if (executorPoolSize <= 0) {
            executorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.internalExecutor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new PoolExecutorThreadFactory(threadGroup, name + ".internal-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                LOGGER.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.executor = new ThreadPoolExecutor(executorPoolSize, executorPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new PoolExecutorThreadFactory(threadGroup, name + ".cached-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                LOGGER.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new SingleExecutorThreadFactory(threadGroup, classLoader, name + ".scheduled"));
    }

    public <T> ICompletableFuture<T> submitInternal(Callable<T> command) {
        CompletableFutureTask<T> futureTask = new CompletableFutureTask<T>(command, this.internalExecutor);
        this.internalExecutor.submit(futureTask);
        return futureTask;
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public ICompletableFuture<?> submit(Runnable task) {
        CompletableFutureTask<Object> futureTask = new CompletableFutureTask<Object>(task, null, this.getAsyncExecutor());
        this.executor.submit(futureTask);
        return futureTask;
    }

    @Override
    public <T> ICompletableFuture<T> submit(Callable<T> task) {
        CompletableFutureTask<T> futureTask = new CompletableFutureTask<T>(task, this.getAsyncExecutor());
        this.executor.submit(futureTask);
        return futureTask;
    }

    @Override
    public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.execute(command);
            }
        }, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.execute(command);
            }
        }, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.execute(command);
            }
        }, initialDelay, period, unit);
    }

    @Override
    public ExecutorService getAsyncExecutor() {
        return this.executor;
    }

    public void shutdown() {
        boolean success;
        this.internalExecutor.shutdown();
        try {
            success = this.internalExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                LOGGER.warning("InternalExecutor awaitTermination could not completed in 30 seconds");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Internal Executor await termination is interrupted", e);
        }
        this.scheduledExecutor.shutdownNow();
        this.executor.shutdown();
        try {
            success = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                LOGGER.warning("Executor awaitTermination could not completed in 30 seconds");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Executor await termination is interrupted", e);
        }
    }
}

