/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.cache.impl.eviction.EvictionConfig;
import com.hazelcast.cache.impl.eviction.EvictionPolicyType;
import com.hazelcast.cache.impl.eviction.EvictionStrategyType;
import com.hazelcast.config.CacheEvictionConfigReadOnly;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.io.Serializable;

public class CacheEvictionConfig
implements EvictionConfig,
DataSerializable,
Serializable {
    public static final int DEFAULT_MAX_ENTRY_COUNT = 10000;
    private int size = 10000;
    private CacheMaxSizePolicy maxSizePolicy = CacheMaxSizePolicy.ENTRY_COUNT;
    private EvictionPolicy evictionPolicy = CacheSimpleConfig.DEFAULT_EVICTION_POLICY;
    private CacheEvictionConfigReadOnly readOnly;

    public CacheEvictionConfig() {
    }

    public CacheEvictionConfig(int size, CacheMaxSizePolicy maxSizePolicy, EvictionPolicy evictionPolicy) {
        if (size > 0) {
            this.size = size;
        }
        if (maxSizePolicy != null) {
            this.maxSizePolicy = maxSizePolicy;
        }
        if (evictionPolicy != null && evictionPolicy != EvictionPolicy.NONE) {
            this.evictionPolicy = evictionPolicy;
        }
    }

    public CacheEvictionConfig(CacheEvictionConfig config) {
        if (config.size > 0) {
            this.size = config.size;
        }
        if (config.maxSizePolicy != null) {
            this.maxSizePolicy = config.maxSizePolicy;
        }
        if (config.evictionPolicy != null && config.evictionPolicy != EvictionPolicy.NONE) {
            this.evictionPolicy = config.evictionPolicy;
        }
    }

    public CacheEvictionConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new CacheEvictionConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public int getSize() {
        return this.size;
    }

    public CacheEvictionConfig setSize(int size) {
        if (size > 0) {
            this.size = size;
        }
        return this;
    }

    public CacheMaxSizePolicy getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    public CacheEvictionConfig setMaxSizePolicy(CacheMaxSizePolicy maxSizePolicy) {
        if (maxSizePolicy != null) {
            this.maxSizePolicy = maxSizePolicy;
        }
        return this;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public CacheEvictionConfig setEvictionPolicy(EvictionPolicy evictionPolicy) {
        if (evictionPolicy != null && evictionPolicy != EvictionPolicy.NONE) {
            this.evictionPolicy = evictionPolicy;
        }
        return this;
    }

    @Override
    public EvictionStrategyType getEvictionStrategyType() {
        return EvictionStrategyType.DEFAULT_EVICTION_STRATEGY;
    }

    @Override
    public EvictionPolicyType getEvictionPolicyType() {
        if (this.evictionPolicy == EvictionPolicy.LFU) {
            return EvictionPolicyType.LFU;
        }
        if (this.evictionPolicy == EvictionPolicy.LRU) {
            return EvictionPolicyType.LRU;
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeUTF(this.maxSizePolicy.toString());
        out.writeUTF(this.evictionPolicy.toString());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.size = in.readInt();
        this.maxSizePolicy = CacheMaxSizePolicy.valueOf(in.readUTF());
        this.evictionPolicy = EvictionPolicy.valueOf(in.readUTF());
    }

    public static enum CacheMaxSizePolicy {
        ENTRY_COUNT,
        USED_NATIVE_MEMORY_SIZE,
        USED_NATIVE_MEMORY_PERCENTAGE,
        FREE_NATIVE_MEMORY_SIZE,
        FREE_NATIVE_MEMORY_PERCENTAGE;

    }
}

