/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.DynamicByteBuffer;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.ByteArraySerializerAdapter;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ConstantSerializers;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializer;
import com.hazelcast.nio.serialization.DefaultData;
import com.hazelcast.nio.serialization.DefaultSerializers;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.InputOutputFactory;
import com.hazelcast.nio.serialization.ObjectDataInputStream;
import com.hazelcast.nio.serialization.ObjectDataOutputStream;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableContextImpl;
import com.hazelcast.nio.serialization.PortableDataInput;
import com.hazelcast.nio.serialization.PortableDataOutput;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableHookLoader;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableSerializer;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerAdapter;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.StreamSerializerAdapter;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class SerializationServiceImpl
implements SerializationService {
    protected static final PartitioningStrategy EMPTY_PARTITIONING_STRATEGY = new PartitioningStrategy(){

        public Object getPartitionKey(Object key) {
            return null;
        }
    };
    private static final int CONSTANT_SERIALIZERS_SIZE = 18;
    private static final String SERIALIZATION_CUSTOM_OVERRIDE = "hazelcast.serialization.custom.override";
    protected final ManagedContext managedContext;
    protected final PortableContext portableContext;
    protected final InputOutputFactory inputOutputFactory;
    protected final PartitioningStrategy globalPartitioningStrategy;
    private final IdentityHashMap<Class, SerializerAdapter> constantTypesMap = new IdentityHashMap(18);
    private final SerializerAdapter[] constantTypeIds = new SerializerAdapter[18];
    private final ConcurrentMap<Class, SerializerAdapter> typeMap = new ConcurrentHashMap<Class, SerializerAdapter>();
    private final ConcurrentMap<Integer, SerializerAdapter> idMap = new ConcurrentHashMap<Integer, SerializerAdapter>();
    private final AtomicReference<SerializerAdapter> global = new AtomicReference();
    private final ThreadLocalOutputCache dataOutputQueue;
    private final PortableSerializer portableSerializer;
    private final SerializerAdapter dataSerializerAdapter;
    private final SerializerAdapter portableSerializerAdapter;
    private final ClassLoader classLoader;
    private final int outputBufferSize;
    private volatile boolean active = true;
    private boolean overrideCustomSerialization;

    SerializationServiceImpl(InputOutputFactory inputOutputFactory, int version, ClassLoader classLoader, Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, Map<Integer, ? extends PortableFactory> portableFactories, Collection<ClassDefinition> classDefinitions, boolean checkClassDefErrors, ManagedContext managedContext, PartitioningStrategy partitionStrategy, int initialOutputBufferSize, boolean enableCompression, boolean enableSharedObject) {
        this.inputOutputFactory = inputOutputFactory;
        this.classLoader = classLoader;
        this.managedContext = managedContext;
        this.globalPartitioningStrategy = partitionStrategy;
        this.outputBufferSize = initialOutputBufferSize;
        this.overrideCustomSerialization = Boolean.parseBoolean(System.getProperty(SERIALIZATION_CUSTOM_OVERRIDE, "false"));
        this.dataOutputQueue = new ThreadLocalOutputCache(this);
        PortableHookLoader loader = new PortableHookLoader(portableFactories, classLoader);
        this.portableContext = new PortableContextImpl(this, version);
        for (ClassDefinition cd : loader.getDefinitions()) {
            this.portableContext.registerClassDefinition(cd);
        }
        this.dataSerializerAdapter = this.createSerializerAdapter(new DataSerializer(dataSerializableFactories, classLoader));
        this.portableSerializer = new PortableSerializer(this.portableContext, loader.getFactories());
        this.portableSerializerAdapter = this.createSerializerAdapter(this.portableSerializer);
        this.registerConstantSerializers();
        this.registerJvmTypeSerializers(enableCompression, enableSharedObject);
        this.registerClassDefinitions(classDefinitions, checkClassDefErrors);
    }

    private void registerJvmTypeSerializers(boolean enableCompression, boolean enableSharedObject) {
        this.safeRegister(Date.class, new DefaultSerializers.DateSerializer());
        this.safeRegister(BigInteger.class, new DefaultSerializers.BigIntegerSerializer());
        this.safeRegister(BigDecimal.class, new DefaultSerializers.BigDecimalSerializer());
        this.safeRegister(Externalizable.class, new DefaultSerializers.Externalizer(enableCompression));
        this.safeRegister(Serializable.class, new DefaultSerializers.ObjectSerializer(enableSharedObject, enableCompression));
        this.safeRegister(Class.class, new DefaultSerializers.ClassSerializer());
        this.safeRegister(Enum.class, new DefaultSerializers.EnumSerializer());
    }

    private void registerConstantSerializers() {
        this.registerConstant(DataSerializable.class, this.dataSerializerAdapter);
        this.registerConstant(Portable.class, this.portableSerializerAdapter);
        this.registerConstant(Byte.class, new ConstantSerializers.ByteSerializer());
        this.registerConstant(Boolean.class, new ConstantSerializers.BooleanSerializer());
        this.registerConstant(Character.class, new ConstantSerializers.CharSerializer());
        this.registerConstant(Short.class, new ConstantSerializers.ShortSerializer());
        this.registerConstant(Integer.class, new ConstantSerializers.IntegerSerializer());
        this.registerConstant(Long.class, new ConstantSerializers.LongSerializer());
        this.registerConstant(Float.class, new ConstantSerializers.FloatSerializer());
        this.registerConstant(Double.class, new ConstantSerializers.DoubleSerializer());
        this.registerConstant(byte[].class, new ConstantSerializers.TheByteArraySerializer());
        this.registerConstant(char[].class, new ConstantSerializers.CharArraySerializer());
        this.registerConstant(short[].class, new ConstantSerializers.ShortArraySerializer());
        this.registerConstant(int[].class, new ConstantSerializers.IntegerArraySerializer());
        this.registerConstant(long[].class, new ConstantSerializers.LongArraySerializer());
        this.registerConstant(float[].class, new ConstantSerializers.FloatArraySerializer());
        this.registerConstant(double[].class, new ConstantSerializers.DoubleArraySerializer());
        this.registerConstant(String.class, new ConstantSerializers.StringSerializer());
    }

    private void registerClassDefinitions(Collection<ClassDefinition> classDefinitions, boolean checkClassDefErrors) {
        HashMap<Integer, ClassDefinition> classDefMap = new HashMap<Integer, ClassDefinition>(classDefinitions.size());
        for (ClassDefinition cd : classDefinitions) {
            if (classDefMap.containsKey(cd.getClassId())) {
                throw new HazelcastSerializationException("Duplicate registration found for class-id[" + cd.getClassId() + "]!");
            }
            classDefMap.put(cd.getClassId(), cd);
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            this.registerClassDefinition(classDefinition, classDefMap, checkClassDefErrors);
        }
    }

    private void registerClassDefinition(ClassDefinition cd, Map<Integer, ClassDefinition> classDefMap, boolean checkClassDefErrors) {
        for (int i = 0; i < cd.getFieldCount(); ++i) {
            FieldDefinition fd = cd.getField(i);
            if (fd.getType() != FieldType.PORTABLE && fd.getType() != FieldType.PORTABLE_ARRAY) continue;
            int classId = fd.getClassId();
            ClassDefinition nestedCd = classDefMap.get(classId);
            if (nestedCd != null) {
                this.registerClassDefinition(nestedCd, classDefMap, checkClassDefErrors);
                this.portableContext.registerClassDefinition(nestedCd);
                continue;
            }
            if (!checkClassDefErrors) continue;
            throw new HazelcastSerializationException("Could not find registered ClassDefinition for class-id: " + classId);
        }
        this.portableContext.registerClassDefinition(cd);
    }

    public final Data toData(Object obj) {
        return this.toData(obj, this.globalPartitioningStrategy);
    }

    public final Data toData(Object obj, PartitioningStrategy strategy) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        int partitionHash = this.calculatePartitionHash(obj, strategy);
        try {
            SerializerAdapter serializer = this.serializerFor(obj.getClass());
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable serializer for " + obj.getClass());
                }
                throw new HazelcastInstanceNotActiveException();
            }
            return serializer.toData(obj, partitionHash);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    protected final int calculatePartitionHash(Object obj, PartitioningStrategy strategy) {
        Object pk;
        PartitioningStrategy partitioningStrategy;
        int partitionHash = 0;
        PartitioningStrategy partitioningStrategy2 = partitioningStrategy = strategy == null ? this.globalPartitioningStrategy : strategy;
        if (partitioningStrategy != null && (pk = partitioningStrategy.getPartitionKey(obj)) != null && pk != obj) {
            Data partitionKey = this.toData(pk, EMPTY_PARTITIONING_STRATEGY);
            partitionHash = partitionKey == null ? 0 : partitionKey.getPartitionHash();
        }
        return partitionHash;
    }

    @Override
    public final <T> T toObject(Object object) {
        if (!(object instanceof Data)) {
            return (T)object;
        }
        Data data = (Data)object;
        if (data.dataSize() == 0 && data.getType() == 0) {
            return null;
        }
        try {
            int typeId = data.getType();
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable de-serializer for type " + typeId);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            Object obj = serializer.toObject(data);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            return (T)obj;
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public final void writeObject(ObjectDataOutput out, Object obj) {
        if (obj instanceof Data) {
            throw new HazelcastSerializationException("Cannot write a Data instance! Use #writeData(ObjectDataOutput out, Data data) instead.");
        }
        boolean isNull = obj == null;
        try {
            out.writeBoolean(isNull);
            if (isNull) {
                return;
            }
            SerializerAdapter serializer = this.serializerFor(obj.getClass());
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable serializer for " + obj.getClass());
                }
                throw new HazelcastInstanceNotActiveException();
            }
            out.writeInt(serializer.getTypeId());
            serializer.write(out, obj);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public final <T> T readObject(ObjectDataInput in) {
        try {
            boolean isNull = in.readBoolean();
            if (isNull) {
                return null;
            }
            int typeId = in.readInt();
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable de-serializer for type " + typeId);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            Object obj = serializer.read(in);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            return (T)obj;
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    @Override
    public final void writeData(ObjectDataOutput out, Data data) {
        try {
            boolean isNull = data == null;
            out.writeBoolean(isNull);
            if (isNull) {
                return;
            }
            out.writeInt(data.getType());
            out.writeInt(data.hasPartitionHash() ? data.getPartitionHash() : 0);
            this.writePortableHeader(out, data);
            int size = data.dataSize();
            out.writeInt(size);
            if (size > 0) {
                this.writeDataInternal(out, data);
            }
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    protected final void writePortableHeader(ObjectDataOutput out, Data data) throws IOException {
        if (data.headerSize() == 0) {
            out.writeInt(0);
        } else {
            if (!(out instanceof PortableDataOutput)) {
                throw new HazelcastSerializationException("PortableDataOutput is required to be able to write Portable header.");
            }
            byte[] header = data.getHeader();
            PortableDataOutput output = (PortableDataOutput)out;
            DynamicByteBuffer headerBuffer = output.getHeaderBuffer();
            out.writeInt(header.length);
            out.writeInt(headerBuffer.position());
            headerBuffer.put(header);
        }
    }

    protected void writeDataInternal(ObjectDataOutput out, Data data) throws IOException {
        out.write(data.getData());
    }

    public final Data readData(ObjectDataInput in) {
        try {
            boolean isNull = in.readBoolean();
            if (isNull) {
                return null;
            }
            int typeId = in.readInt();
            int partitionHash = in.readInt();
            byte[] header = this.readPortableHeader(in);
            int dataSize = in.readInt();
            byte[] data = null;
            if (dataSize > 0) {
                data = new byte[dataSize];
                in.readFully(data);
            }
            return new DefaultData(typeId, data, partitionHash, header);
        }
        catch (Throwable e) {
            throw this.handleException(e);
        }
    }

    protected final byte[] readPortableHeader(ObjectDataInput in) throws IOException {
        byte[] header = null;
        int len = in.readInt();
        if (len > 0) {
            if (!(in instanceof PortableDataInput)) {
                throw new HazelcastSerializationException("PortableDataInput is required to be able to read Portable header.");
            }
            PortableDataInput input = (PortableDataInput)in;
            ByteBuffer headerBuffer = input.getHeaderBuffer();
            int pos = in.readInt();
            headerBuffer.position(pos);
            header = new byte[len];
            headerBuffer.get(header);
        }
        return header;
    }

    @Override
    public void disposeData(Data data) {
    }

    protected RuntimeException handleException(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
            throw (Error)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof HazelcastSerializationException) {
            throw (HazelcastSerializationException)e;
        }
        throw new HazelcastSerializationException(e);
    }

    @Override
    public final BufferObjectDataOutput pop() {
        return this.dataOutputQueue.pop();
    }

    @Override
    public final void push(BufferObjectDataOutput out) {
        this.dataOutputQueue.push(out);
    }

    @Override
    public final BufferObjectDataInput createObjectDataInput(byte[] data) {
        return this.inputOutputFactory.createInput(data, (SerializationService)this);
    }

    @Override
    public final BufferObjectDataInput createObjectDataInput(Data data) {
        return this.inputOutputFactory.createInput(data, (SerializationService)this);
    }

    @Override
    public final BufferObjectDataOutput createObjectDataOutput(int size) {
        return this.inputOutputFactory.createOutput(size, this);
    }

    @Override
    public final ObjectDataOutputStream createObjectDataOutputStream(OutputStream out) {
        return new ObjectDataOutputStream(out, this);
    }

    @Override
    public final ObjectDataInputStream createObjectDataInputStream(InputStream in) {
        return new ObjectDataInputStream(in, this);
    }

    @Override
    public final void register(Class type, Serializer serializer) {
        if (type == null) {
            throw new IllegalArgumentException("Class type information is required!");
        }
        if (serializer.getTypeId() <= 0) {
            throw new IllegalArgumentException("Type id must be positive! Current: " + serializer.getTypeId() + ", Serializer: " + serializer);
        }
        this.safeRegister(type, this.createSerializerAdapter(serializer));
    }

    @Override
    public final void registerGlobal(Serializer serializer) {
        SerializerAdapter adapter = this.createSerializerAdapter(serializer);
        if (!this.global.compareAndSet(null, adapter)) {
            throw new IllegalStateException("Global serializer is already registered!");
        }
        SerializerAdapter current = this.idMap.putIfAbsent(serializer.getTypeId(), adapter);
        if (current != null && current.getImpl().getClass() != adapter.getImpl().getClass()) {
            this.global.compareAndSet(adapter, null);
            throw new IllegalStateException("Serializer [" + current.getImpl() + "] has been already registered for type-id: " + serializer.getTypeId());
        }
    }

    protected SerializerAdapter createSerializerAdapter(Serializer serializer) {
        SerializerAdapter s;
        if (serializer instanceof StreamSerializer) {
            s = new StreamSerializerAdapter(this, (StreamSerializer)serializer);
        } else if (serializer instanceof ByteArraySerializer) {
            s = new ByteArraySerializerAdapter((ByteArraySerializer)serializer);
        } else {
            throw new IllegalArgumentException("Serializer must be instance of either StreamSerializer or ByteArraySerializer!");
        }
        return s;
    }

    protected final SerializerAdapter serializerFor(Class type) {
        SerializerAdapter serializer;
        if (this.overrideCustomSerialization && (serializer = this.lookupSerializer(type)) != null) {
            return serializer;
        }
        if (DataSerializable.class.isAssignableFrom(type)) {
            return this.dataSerializerAdapter;
        }
        if (Portable.class.isAssignableFrom(type)) {
            return this.portableSerializerAdapter;
        }
        serializer = this.constantTypesMap.get(type);
        if (serializer != null) {
            return serializer;
        }
        serializer = this.lookupSerializer(type);
        if (serializer == null) {
            if (this.active) {
                throw new HazelcastSerializationException("There is no suitable serializer for " + type);
            }
            throw new HazelcastInstanceNotActiveException();
        }
        return serializer;
    }

    protected final SerializerAdapter lookupSerializer(Class type) {
        SerializerAdapter serializer = (SerializerAdapter)this.typeMap.get(type);
        if (serializer == null) {
            LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>(5);
            SerializationServiceImpl.getInterfaces(type, interfaces);
            for (Class typeSuperclass = type.getSuperclass(); typeSuperclass != null && (serializer = this.registerFromSuperType(type, typeSuperclass)) == null; typeSuperclass = typeSuperclass.getSuperclass()) {
                SerializationServiceImpl.getInterfaces(typeSuperclass, interfaces);
            }
            if (serializer == null) {
                Class typeInterface;
                Iterator i$ = interfaces.iterator();
                while (i$.hasNext() && (serializer = this.registerFromSuperType(type, typeInterface = (Class)i$.next())) == null) {
                }
            }
            if (serializer == null && (serializer = this.global.get()) != null) {
                this.safeRegister(type, serializer);
            }
        }
        return serializer;
    }

    private static void getInterfaces(Class clazz, Set<Class> interfaces) {
        Class<?>[] classes = clazz.getInterfaces();
        if (classes.length > 0) {
            Collections.addAll(interfaces, classes);
            for (Class<?> cl : classes) {
                SerializationServiceImpl.getInterfaces(cl, interfaces);
            }
        }
    }

    private SerializerAdapter registerFromSuperType(Class type, Class superType) {
        SerializerAdapter serializer = (SerializerAdapter)this.typeMap.get(superType);
        if (serializer != null) {
            this.safeRegister(type, serializer);
        }
        return serializer;
    }

    private void registerConstant(Class type, Serializer serializer) {
        this.registerConstant(type, this.createSerializerAdapter(serializer));
    }

    private void registerConstant(Class type, SerializerAdapter serializer) {
        this.constantTypesMap.put(type, serializer);
        this.constantTypeIds[this.indexForDefaultType((int)serializer.getTypeId())] = serializer;
    }

    void safeRegister(Class type, Serializer serializer) {
        this.safeRegister(type, this.createSerializerAdapter(serializer));
    }

    private void safeRegister(Class type, SerializerAdapter serializer) {
        if (this.constantTypesMap.containsKey(type)) {
            throw new IllegalArgumentException("[" + type + "] serializer cannot be overridden!");
        }
        SerializerAdapter current = this.typeMap.putIfAbsent(type, serializer);
        if (current != null && current.getImpl().getClass() != serializer.getImpl().getClass()) {
            throw new IllegalStateException("Serializer[" + current.getImpl() + "] has been already registered for type: " + type);
        }
        current = this.idMap.putIfAbsent(serializer.getTypeId(), serializer);
        if (current != null && current.getImpl().getClass() != serializer.getImpl().getClass()) {
            throw new IllegalStateException("Serializer [" + current.getImpl() + "] has been already registered for type-id: " + serializer.getTypeId());
        }
    }

    protected final SerializerAdapter serializerFor(int typeId) {
        int index;
        if (typeId < 0 && (index = this.indexForDefaultType(typeId)) < 18) {
            return this.constantTypeIds[index];
        }
        return (SerializerAdapter)this.idMap.get(typeId);
    }

    private int indexForDefaultType(int typeId) {
        return -typeId - 1;
    }

    @Override
    public PortableContext getPortableContext() {
        return this.portableContext;
    }

    @Override
    public final PortableReader createPortableReader(Data data) throws IOException {
        if (!data.isPortable()) {
            throw new IllegalArgumentException();
        }
        BufferObjectDataInput in = this.createObjectDataInput(data);
        return this.portableSerializer.createReader(in);
    }

    @Override
    public void destroy() {
        this.active = false;
        for (SerializerAdapter serializer : this.typeMap.values()) {
            serializer.destroy();
        }
        this.typeMap.clear();
        this.idMap.clear();
        this.global.set(null);
        this.constantTypesMap.clear();
        this.dataOutputQueue.clear();
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final ManagedContext getManagedContext() {
        return this.managedContext;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.inputOutputFactory.getByteOrder();
    }

    public boolean isActive() {
        return this.active;
    }

    private static final class ThreadLocalOutputCache {
        static final float LOAD_FACTOR = 0.91f;
        final ConcurrentMap<Thread, Queue<BufferObjectDataOutput>> map;
        final SerializationServiceImpl serializationService;
        final int bufferSize;

        private ThreadLocalOutputCache(SerializationServiceImpl serializationService) {
            this.serializationService = serializationService;
            this.bufferSize = serializationService.outputBufferSize;
            int initialCapacity = Runtime.getRuntime().availableProcessors();
            this.map = new ConcurrentReferenceHashMap<Thread, Queue<BufferObjectDataOutput>>(initialCapacity, 0.91f, 1);
        }

        BufferObjectDataOutput pop() {
            BufferObjectDataOutput out;
            Thread t = Thread.currentThread();
            ArrayDeque outputQueue = (ArrayDeque)this.map.get(t);
            if (outputQueue == null) {
                outputQueue = new ArrayDeque(3);
                this.map.put(t, outputQueue);
            }
            if ((out = (BufferObjectDataOutput)outputQueue.poll()) == null) {
                out = this.serializationService.createObjectDataOutput(this.bufferSize);
            }
            return out;
        }

        void push(BufferObjectDataOutput out) {
            if (out != null) {
                out.clear();
                Queue outputQueue = (Queue)this.map.get(Thread.currentThread());
                if (outputQueue == null || !outputQueue.offer(out)) {
                    IOUtil.closeResource(out);
                }
            }
        }

        void clear() {
            this.map.clear();
        }
    }
}

