/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import java.util.Arrays;

final class PartitionReplicaVersions {
    final int partitionId;
    final long[] versions = new long[6];

    PartitionReplicaVersions(int partitionId) {
        this.partitionId = partitionId;
    }

    long[] incrementAndGet(int backupCount) {
        int i = 0;
        while (i < backupCount) {
            int n = i++;
            this.versions[n] = this.versions[n] + 1L;
        }
        return this.versions;
    }

    long[] get() {
        return this.versions;
    }

    boolean update(long[] newVersions, int currentReplica) {
        boolean valid;
        int index = currentReplica - 1;
        long current = this.versions[index];
        long next = newVersions[index];
        boolean bl = valid = current == next - 1L;
        if (valid) {
            this.set(newVersions, currentReplica);
            current = next;
        }
        return current >= next;
    }

    void set(long[] newVersions, int fromReplica) {
        int fromIndex = fromReplica - 1;
        int len = newVersions.length - fromIndex;
        System.arraycopy(newVersions, fromIndex, this.versions, fromIndex, len);
    }

    void clear() {
        for (int i = 0; i < this.versions.length; ++i) {
            this.versions[i] = 0L;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionReplicaVersions");
        sb.append("{partitionId=").append(this.partitionId);
        sb.append(", versions=").append(Arrays.toString(this.versions));
        sb.append('}');
        return sb.toString();
    }
}

