/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CacheEvictionConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.spi.ServiceConfigurationParser;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    private class SpringXmlConfigBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private ManagedMap mapConfigManagedMap;
        private ManagedMap cacheConfigManagedMap;
        private ManagedMap queueManagedMap;
        private ManagedMap listManagedMap;
        private ManagedMap setManagedMap;
        private ManagedMap topicManagedMap;
        private ManagedMap multiMapManagedMap;
        private ManagedMap executorManagedMap;
        private ManagedMap wanReplicationManagedMap;
        private ManagedMap jobTrackerManagedMap;
        private ManagedMap replicatedMapManagedMap;

        public SpringXmlConfigBuilder(ParserContext parserContext) {
            super(HazelcastConfigBeanDefinitionParser.this);
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = this.createManagedMap("mapConfigs");
            this.cacheConfigManagedMap = this.createManagedMap("cacheConfigs");
            this.queueManagedMap = this.createManagedMap("queueConfigs");
            this.listManagedMap = this.createManagedMap("listConfigs");
            this.setManagedMap = this.createManagedMap("setConfigs");
            this.topicManagedMap = this.createManagedMap("topicConfigs");
            this.multiMapManagedMap = this.createManagedMap("multiMapConfigs");
            this.executorManagedMap = this.createManagedMap("executorConfigs");
            this.wanReplicationManagedMap = this.createManagedMap("wanReplicationConfigs");
            this.jobTrackerManagedMap = this.createManagedMap("jobTrackerConfigs");
            this.replicatedMapManagedMap = this.createManagedMap("replicatedMapConfigs");
        }

        private ManagedMap createManagedMap(String configName) {
            ManagedMap managedMap = new ManagedMap();
            this.configBuilder.addPropertyValue(configName, (Object)managedMap);
            return managedMap;
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        public void handleConfig(Element element) {
            if (element != null) {
                this.handleCommonBeanAttributes(element, this.configBuilder, this.parserContext);
                this.handleSpringAware(element);
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(element, 1)) {
                    String nodeName = SpringXmlConfigBuilder.cleanNodeName(node.getNodeName());
                    if ("network".equals(nodeName)) {
                        this.handleNetwork(node);
                        continue;
                    }
                    if ("group".equals(nodeName)) {
                        this.handleGroup(node);
                        continue;
                    }
                    if ("properties".equals(nodeName)) {
                        this.handleProperties(node);
                        continue;
                    }
                    if ("executor-service".equals(nodeName)) {
                        this.handleExecutor(node);
                        continue;
                    }
                    if ("queue".equals(nodeName)) {
                        this.handleQueue(node);
                        continue;
                    }
                    if ("map".equals(nodeName)) {
                        this.handleMap(node);
                        continue;
                    }
                    if ("cache".equals(nodeName)) {
                        this.handleCache(node);
                        continue;
                    }
                    if ("multimap".equals(nodeName)) {
                        this.handleMultiMap(node);
                        continue;
                    }
                    if ("list".equals(nodeName)) {
                        this.handleList(node);
                        continue;
                    }
                    if ("set".equals(nodeName)) {
                        this.handleSet(node);
                        continue;
                    }
                    if ("topic".equals(nodeName)) {
                        this.handleTopic(node);
                        continue;
                    }
                    if ("jobtracker".equals(nodeName)) {
                        this.handleJobTracker(node);
                        continue;
                    }
                    if ("replicatedmap".equals(nodeName)) {
                        this.handleReplicatedMap(node);
                        continue;
                    }
                    if ("wan-replication".equals(nodeName)) {
                        this.handleWanReplication(node);
                        continue;
                    }
                    if ("partition-group".equals(nodeName)) {
                        this.handlePartitionGroup(node);
                        continue;
                    }
                    if ("serialization".equals(nodeName)) {
                        this.handleSerialization(node);
                        continue;
                    }
                    if ("security".equals(nodeName)) {
                        this.handleSecurity(node);
                        continue;
                    }
                    if ("member-attributes".equals(nodeName)) {
                        this.handleMemberAttributes(node);
                        continue;
                    }
                    if ("native-memory".equals(nodeName)) {
                        this.handleNativeMemory(node);
                        continue;
                    }
                    if ("instance-name".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("listeners".equals(nodeName)) {
                        ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                        this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                        continue;
                    }
                    if ("lite-member".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("license-key".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("management-center".equals(nodeName)) {
                        this.handleManagementCenter(node);
                        continue;
                    }
                    if (!"services".equals(nodeName)) continue;
                    this.handleServices(node);
                }
            }
        }

        public void handleServices(Node node) {
            BeanDefinitionBuilder servicesConfigBuilder = this.createBeanBuilder(ServicesConfig.class);
            AbstractBeanDefinition beanDefinition = servicesConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, servicesConfigBuilder, new String[0]);
            ManagedList serviceConfigManagedList = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if (!"service".equals(nodeName)) continue;
                serviceConfigManagedList.add((Object)this.handleService(child));
            }
            servicesConfigBuilder.addPropertyValue("serviceConfigs", (Object)serviceConfigManagedList);
            this.configBuilder.addPropertyValue("servicesConfig", (Object)beanDefinition);
        }

        private AbstractBeanDefinition handleService(Node node) {
            BeanDefinitionBuilder serviceConfigBuilder = this.createBeanBuilder(ServiceConfig.class);
            AbstractBeanDefinition beanDefinition = serviceConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serviceConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if ("class-name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(child, serviceConfigBuilder);
                    continue;
                }
                if (!"configuration".equals(nodeName)) continue;
                Node parser = child.getAttributes().getNamedItem("parser");
                String name = this.getTextContent(parser);
                try {
                    ServiceConfigurationParser serviceConfigurationParser = (ServiceConfigurationParser)ClassLoaderUtil.newInstance(this.getClass().getClassLoader(), name);
                    Object obj = serviceConfigurationParser.parse((Element)child);
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName("config-object"), obj);
                }
                catch (Exception e) {
                    ExceptionUtil.sneakyThrow(e);
                }
            }
            return beanDefinition;
        }

        public void handleReplicatedMap(Node node) {
            BeanDefinitionBuilder replicatedMapConfigBuilder = this.createBeanBuilder(ReplicatedMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, replicatedMapConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"entry-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                replicatedMapConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
            }
            this.replicatedMapManagedMap.put((Object)name, (Object)replicatedMapConfigBuilder.getBeanDefinition());
        }

        public void handleNetwork(Node node) {
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class);
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, networkConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, networkConfigBuilder);
                    continue;
                }
                if (!"reuse-address".equals(nodeName)) continue;
                this.handleReuseAddress(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(InterfacesConfig.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                String value = this.getTextContent(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(JoinConfig.class);
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if (!"aws".equals(name)) continue;
                this.handleAws(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleReuseAddress(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String value = node.getTextContent();
            networkConfigBuilder.addPropertyValue("reuseAddress", (Object)value);
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, "factory-implementation");
            Node implNode = node.getAttributes().getNamedItem("factory-implementation");
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), implementation);
            }
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "name", this.executorManagedMap, new String[0]);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, new String[0]);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName(n.getNodeName()));
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getTextContent(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        public void handleAws(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, AwsConfig.class, "awsConfig", joinConfigBuilder, new String[0]);
        }

        public void handleQueue(Node node) {
            BeanDefinitionBuilder queueConfigBuilder = this.createBeanBuilder(QueueConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, queueConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nodeName = this.cleanNodeName(childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    queueConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if (!"queue-store".equals(nodeName)) continue;
                this.handleQueueStoreConfig(childNode, queueConfigBuilder);
            }
            this.queueManagedMap.put((Object)name, (Object)queueConfigBuilder.getBeanDefinition());
        }

        public void handleQueueStoreConfig(Node node, BeanDefinitionBuilder queueConfigBuilder) {
            BeanDefinitionBuilder queueStoreConfigBuilder = this.createBeanBuilder(QueueStoreConfig.class);
            AbstractBeanDefinition beanDefinition = queueStoreConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                if (!"properties".equals(this.cleanNodeName(child))) continue;
                this.handleProperties(child, queueStoreConfigBuilder);
                break;
            }
            String implAttrName = "store-implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, queueStoreConfigBuilder, "store-implementation", "factory-implementation");
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem("store-implementation");
            Node factoryImplRef = attributes.getNamedItem("factory-implementation");
            if (factoryImplRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("store-implementation"), this.getTextContent(implRef));
            }
            queueConfigBuilder.addPropertyValue("queueStoreConfig", (Object)beanDefinition);
        }

        public void handleList(Node node) {
            BeanDefinitionBuilder listConfigBuilder = this.createBeanBuilder(ListConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, listConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"item-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                listConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
            }
            this.listManagedMap.put((Object)name, (Object)listConfigBuilder.getBeanDefinition());
        }

        public void handleSet(Node node) {
            BeanDefinitionBuilder setConfigBuilder = this.createBeanBuilder(SetConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, setConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"item-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                setConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
            }
            this.setManagedMap.put((Object)name, (Object)setConfigBuilder.getBeanDefinition());
        }

        public void handleMap(Node node) {
            Node maxSizePolicyNode;
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class);
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillAttributeValues(node, mapConfigBuilder, "maxSize", "maxSizePolicy");
            BeanDefinitionBuilder maxSizeConfigBuilder = this.createBeanBuilder(MaxSizeConfig.class);
            AbstractBeanDefinition maxSizeConfigBeanDefinition = maxSizeConfigBuilder.getBeanDefinition();
            mapConfigBuilder.addPropertyValue("maxSizeConfig", (Object)maxSizeConfigBeanDefinition);
            Node maxSizeNode = node.getAttributes().getNamedItem("max-size");
            if (maxSizeNode != null) {
                maxSizeConfigBuilder.addPropertyValue("size", (Object)this.getTextContent(maxSizeNode));
            }
            if ((maxSizePolicyNode = node.getAttributes().getNamedItem("max-size-policy")) != null) {
                maxSizeConfigBuilder.addPropertyValue(this.xmlToJavaName(this.cleanNodeName(maxSizePolicyNode)), (Object)MaxSizeConfig.MaxSizePolicy.valueOf(this.getTextContent(maxSizePolicyNode)));
            }
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode.getNodeName());
                if ("map-store".equals(nodeName)) {
                    this.handleMapStoreConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCacheConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class);
                    AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
                    this.fillValues(childNode, wanReplicationRefBuilder, new String[0]);
                    mapConfigBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes(), 1)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapIndexConfigs", (Object)indexes);
                    continue;
                }
                if (!"entry-listeners".equals(nodeName)) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                mapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
        }

        public void handleCache(Node node) {
            BeanDefinitionBuilder cacheConfigBuilder = this.createBeanBuilder(CacheSimpleConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, cacheConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if ("eviction".equals(this.cleanNodeName(childNode))) {
                    CacheEvictionConfig evictionConfig = new CacheEvictionConfig();
                    Node size = childNode.getAttributes().getNamedItem("size");
                    Node maxSizePolicy = childNode.getAttributes().getNamedItem("max-size-policy");
                    Node evictionPolicy = childNode.getAttributes().getNamedItem("eviction-policy");
                    if (size != null) {
                        evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
                    }
                    if (maxSizePolicy != null) {
                        evictionConfig.setMaxSizePolicy(CacheEvictionConfig.CacheMaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
                    }
                    if (evictionPolicy != null) {
                        evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
                    }
                    cacheConfigBuilder.addPropertyValue("evictionConfig", (Object)evictionConfig);
                }
                if (!"cache-entry-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = new ManagedList();
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes(), 1)) {
                    BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(CacheSimpleEntryListenerConfig.class);
                    this.fillAttributeValues(listenerNode, listenerConfBuilder, new String[0]);
                    listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                }
                cacheConfigBuilder.addPropertyValue("cacheEntryListeners", (Object)listeners);
            }
            this.cacheConfigManagedMap.put((Object)name, (Object)cacheConfigBuilder.getBeanDefinition());
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder wanRepConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class);
            AbstractBeanDefinition beanDefinition = wanRepConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            wanRepConfigBuilder.addPropertyValue("name", (Object)name);
            ManagedList targetClusters = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nName = this.cleanNodeName(n);
                if (!"target-cluster".equals(nName)) continue;
                BeanDefinitionBuilder targetClusterConfigBuilder = this.createBeanBuilder(WanTargetClusterConfig.class);
                AbstractBeanDefinition childBeanDefinition = targetClusterConfigBuilder.getBeanDefinition();
                this.fillAttributeValues(n, targetClusterConfigBuilder, Collections.<String>emptyList());
                for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes(), 1)) {
                    String childNodeName = this.cleanNodeName(childNode);
                    if ("replication-impl".equals(childNodeName)) {
                        targetClusterConfigBuilder.addPropertyValue(this.xmlToJavaName(childNodeName), (Object)this.getTextContent(childNode));
                        continue;
                    }
                    if ("replication-impl-object".equals(childNodeName)) {
                        Node refName = childNode.getAttributes().getNamedItem("ref");
                        targetClusterConfigBuilder.addPropertyReference(this.xmlToJavaName(childNodeName), this.getTextContent(refName));
                        continue;
                    }
                    if (!"end-points".equals(childNodeName)) continue;
                    ManagedList addresses = new ManagedList();
                    for (Node addressNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes(), 1)) {
                        if (!"address".equals(this.cleanNodeName(addressNode))) continue;
                        addresses.add((Object)this.getTextContent(addressNode));
                    }
                    targetClusterConfigBuilder.addPropertyValue("endpoints", (Object)addresses);
                }
                targetClusters.add((Object)childBeanDefinition);
            }
            wanRepConfigBuilder.addPropertyValue("targetClusterConfigs", (Object)targetClusters);
            this.wanReplicationManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private void handlePartitionGroup(Node node) {
            BeanDefinitionBuilder partitionConfigBuilder = this.createBeanBuilder(PartitionGroupConfig.class);
            this.fillAttributeValues(node, partitionConfigBuilder, new String[0]);
            ManagedList memberGroups = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"member-group".equals(name)) continue;
                BeanDefinitionBuilder memberGroupBuilder = this.createBeanBuilder(MemberGroupConfig.class);
                ManagedList interfaces = new ManagedList();
                for (Node n : new AbstractXmlConfigHelper.IterableNodeList(child.getChildNodes(), 1)) {
                    if (!"interface".equals(SpringXmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
                    interfaces.add((Object)this.getTextContent(n));
                }
                memberGroupBuilder.addPropertyValue("interfaces", (Object)interfaces);
                memberGroups.add((Object)memberGroupBuilder.getBeanDefinition());
            }
            partitionConfigBuilder.addPropertyValue("memberGroupConfigs", (Object)memberGroups);
            this.configBuilder.addPropertyValue("partitionGroupConfig", (Object)partitionConfigBuilder.getBeanDefinition());
        }

        private void handleManagementCenter(Node node) {
            this.createAndFillBeanBuilder(node, ManagementCenterConfig.class, "managementCenterConfig", this.configBuilder, new String[0]);
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            this.createAndFillBeanBuilder(node, NearCacheConfig.class, "nearCacheConfig", mapConfigBuilder, new String[0]);
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class);
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                if (!"properties".equals(this.cleanNodeName(child))) continue;
                this.handleProperties(child, mapStoreConfigBuilder);
                break;
            }
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            String initialModeAttrName = "initial-mode";
            this.fillAttributeValues(node, mapStoreConfigBuilder, "implementation", "factory-implementation", "initialMode");
            NamedNodeMap attrs = node.getAttributes();
            Node implRef = attrs.getNamedItem("implementation");
            Node factoryImplRef = attrs.getNamedItem("factory-implementation");
            Node initialMode = attrs.getNamedItem("initial-mode");
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("implementation"), this.getTextContent(implRef));
            }
            if (initialMode != null) {
                MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf(StringUtil.upperCaseInternal(this.getTextContent(initialMode)));
                mapStoreConfigBuilder.addPropertyValue("initialLoadMode", (Object)mode);
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
            mapStoreConfigBuilder = null;
        }

        public void handleMultiMap(Node node) {
            BeanDefinitionBuilder multiMapConfigBuilder = this.createBeanBuilder(MultiMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, multiMapConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"entry-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                multiMapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
            }
            this.multiMapManagedMap.put((Object)name, (Object)multiMapConfigBuilder.getBeanDefinition());
        }

        public void handleTopic(Node node) {
            BeanDefinitionBuilder topicConfigBuilder = this.createBeanBuilder(TopicConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, topicConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if ("message-listeners".equals(this.cleanNodeName(childNode))) {
                    ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                    topicConfigBuilder.addPropertyValue("messageListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("statistics-enabled".equals(this.cleanNodeName(childNode))) {
                    String statisticsEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("statisticsEnabled", (Object)statisticsEnabled);
                    continue;
                }
                if (!"global-ordering-enabled".equals(this.cleanNodeName(childNode))) continue;
                String globalOrderingEnabled = this.getTextContent(childNode);
                topicConfigBuilder.addPropertyValue("globalOrderingEnabled", (Object)globalOrderingEnabled);
            }
            this.topicManagedMap.put((Object)name, (Object)topicConfigBuilder.getBeanDefinition());
        }

        public void handleJobTracker(Node node) {
            BeanDefinitionBuilder jobTrackerConfigBuilder = this.createBeanBuilder(JobTrackerConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, jobTrackerConfigBuilder, new String[0]);
            this.jobTrackerManagedMap.put((Object)name, (Object)jobTrackerConfigBuilder.getBeanDefinition());
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(SecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if ("member-credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("member-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, true);
                    continue;
                }
                if ("client-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, false);
                    continue;
                }
                if ("client-permission-policy".equals(nodeName)) {
                    this.handlePermissionPolicy(child, securityConfigBuilder);
                    continue;
                }
                if ("client-permissions".equals(nodeName)) {
                    this.handleSecurityPermissions(child, securityConfigBuilder);
                    continue;
                }
                if (!"security-interceptors".equals(nodeName)) continue;
                this.handleSecurityInterceptors(child, securityConfigBuilder);
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        private void handleMemberAttributes(Node node) {
            BeanDefinitionBuilder memberAttributeConfigBuilder = this.createBeanBuilder(MemberAttributeConfig.class);
            AbstractBeanDefinition beanDefinition = memberAttributeConfigBuilder.getBeanDefinition();
            ManagedMap attributes = new ManagedMap();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n.getNodeName());
                if (!"attribute".equals(name)) continue;
                String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String attributeType = this.getTextContent(n.getAttributes().getNamedItem("type")).trim();
                String value = this.getTextContent(n);
                Object oValue = "string".equals(attributeType) ? value : ("boolean".equals(attributeType) ? Boolean.valueOf(Boolean.parseBoolean(value)) : ("byte".equals(attributeType) ? Byte.valueOf(Byte.parseByte(value)) : ("double".equals(attributeType) ? Double.valueOf(Double.parseDouble(value)) : ("float".equals(attributeType) ? Float.valueOf(Float.parseFloat(value)) : ("int".equals(attributeType) ? Integer.valueOf(Integer.parseInt(value)) : ("long".equals(attributeType) ? Long.valueOf(Long.parseLong(value)) : ("short".equals(attributeType) ? Short.valueOf(Short.parseShort(value)) : value)))))));
                attributes.put((Object)attributeName, oValue);
            }
            memberAttributeConfigBuilder.addPropertyValue("attributes", (Object)attributes);
            this.configBuilder.addPropertyValue("memberAttributeConfig", (Object)beanDefinition);
        }

        private void handleSecurityInterceptors(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedList lms = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"interceptor".equals(nodeName)) continue;
                BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(SecurityInterceptorConfig.class);
                AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
                this.fillAttributeValues(child, lmConfigBuilder, new String[0]);
                lms.add(beanDefinition);
            }
            securityConfigBuilder.addPropertyValue("securityInterceptorConfigs", (Object)lms);
        }

        private void handleNativeMemory(Node node) {
            BeanDefinitionBuilder nativeMemoryConfigBuilder = this.createBeanBuilder(NativeMemoryConfig.class);
            AbstractBeanDefinition beanDefinition = nativeMemoryConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, nativeMemoryConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if (!"size".equals(nodeName)) continue;
                this.handleMemorySizeConfig(child, nativeMemoryConfigBuilder);
            }
            this.configBuilder.addPropertyValue("nativeMemoryConfig", (Object)beanDefinition);
        }

        private void handleMemorySizeConfig(Node node, BeanDefinitionBuilder nativeMemoryConfigBuilder) {
            BeanDefinitionBuilder memorySizeConfigBuilder = this.createBeanBuilder(MemorySize.class);
            NamedNodeMap attrs = node.getAttributes();
            Node value = attrs.getNamedItem("value");
            Node unit = attrs.getNamedItem("unit");
            memorySizeConfigBuilder.addConstructorArgValue((Object)this.getTextContent(value));
            memorySizeConfigBuilder.addConstructorArgValue((Object)MemoryUnit.valueOf(this.getTextContent(unit)));
            nativeMemoryConfigBuilder.addPropertyValue("size", (Object)memorySizeConfigBuilder.getBeanDefinition());
        }

        private void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attrs = node.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attrs.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("memberCredentialsConfig", (Object)beanDefinition);
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder securityConfigBuilder, boolean member) {
            ManagedList lms = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List)lms);
            }
            if (member) {
                securityConfigBuilder.addPropertyValue("memberLoginModuleConfigs", (Object)lms);
            } else {
                securityConfigBuilder.addPropertyValue("clientLoginModuleConfigs", (Object)lms);
            }
        }

        private void handleLoginModule(Node node, List list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add(beanDefinition);
        }

        private void handlePermissionPolicy(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder permPolicyConfigBuilder = this.createBeanBuilder(PermissionPolicyConfig.class);
            AbstractBeanDefinition beanDefinition = permPolicyConfigBuilder.getBeanDefinition();
            NamedNodeMap attrs = node.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attrs.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            permPolicyConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                permPolicyConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create PermissionPolicy!");
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, permPolicyConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("clientPolicyConfig", (Object)beanDefinition);
        }

        private void handleSecurityPermissions(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedSet permissions = new ManagedSet();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType(nodeName);
                if (type == null) continue;
                this.handleSecurityPermission(child, (Set)permissions, type);
            }
            securityConfigBuilder.addPropertyValue("clientPermissionConfigs", (Object)permissions);
        }

        private void handleSecurityPermission(Node node, Set permissions, PermissionConfig.PermissionType type) {
            BeanDefinitionBuilder permissionConfigBuilder = this.createBeanBuilder(PermissionConfig.class);
            AbstractBeanDefinition beanDefinition = permissionConfigBuilder.getBeanDefinition();
            permissionConfigBuilder.addPropertyValue("type", (Object)type);
            NamedNodeMap attrs = node.getAttributes();
            Node nameNode = attrs.getNamedItem("name");
            String name = nameNode != null ? this.getTextContent(nameNode) : "*";
            permissionConfigBuilder.addPropertyValue("name", (Object)name);
            Node principalNode = attrs.getNamedItem("principal");
            String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
            permissionConfigBuilder.addPropertyValue("principal", (Object)principal);
            ManagedList endpoints = new ManagedList();
            ManagedList actions = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if ("endpoints".equals(nodeName)) {
                    this.handleSecurityPermissionEndpoints(child, (List)endpoints);
                    continue;
                }
                if (!"actions".equals(nodeName)) continue;
                this.handleSecurityPermissionActions(child, (List)actions);
            }
            permissionConfigBuilder.addPropertyValue("endpoints", (Object)endpoints);
            permissionConfigBuilder.addPropertyValue("actions", (Object)actions);
            permissions.add(beanDefinition);
        }

        private void handleSecurityPermissionEndpoints(Node node, List endpoints) {
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"endpoint".equals(nodeName)) continue;
                endpoints.add(this.getTextContent(child));
            }
        }

        private void handleSecurityPermissionActions(Node node, List actions) {
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"action".equals(nodeName)) continue;
                actions.add(this.getTextContent(child));
            }
        }
    }
}

