/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapKeySet;
import com.hazelcast.map.impl.MapValueCollection;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.client.MapAddEntryListenerRequest;
import com.hazelcast.map.impl.client.MapAddIndexRequest;
import com.hazelcast.map.impl.client.MapAddInterceptorRequest;
import com.hazelcast.map.impl.client.MapAddNearCacheEntryListenerRequest;
import com.hazelcast.map.impl.client.MapClearRequest;
import com.hazelcast.map.impl.client.MapContainsKeyRequest;
import com.hazelcast.map.impl.client.MapContainsValueRequest;
import com.hazelcast.map.impl.client.MapDeleteRequest;
import com.hazelcast.map.impl.client.MapEntrySetRequest;
import com.hazelcast.map.impl.client.MapEvictAllRequest;
import com.hazelcast.map.impl.client.MapEvictRequest;
import com.hazelcast.map.impl.client.MapExecuteOnAllKeysRequest;
import com.hazelcast.map.impl.client.MapExecuteOnKeyRequest;
import com.hazelcast.map.impl.client.MapExecuteOnKeysRequest;
import com.hazelcast.map.impl.client.MapExecuteWithPredicateRequest;
import com.hazelcast.map.impl.client.MapFlushRequest;
import com.hazelcast.map.impl.client.MapGetAllRequest;
import com.hazelcast.map.impl.client.MapGetEntryViewRequest;
import com.hazelcast.map.impl.client.MapGetRequest;
import com.hazelcast.map.impl.client.MapIsEmptyRequest;
import com.hazelcast.map.impl.client.MapIsLockedRequest;
import com.hazelcast.map.impl.client.MapKeySetRequest;
import com.hazelcast.map.impl.client.MapLoadAllKeysRequest;
import com.hazelcast.map.impl.client.MapLoadGivenKeysRequest;
import com.hazelcast.map.impl.client.MapLockRequest;
import com.hazelcast.map.impl.client.MapPutAllRequest;
import com.hazelcast.map.impl.client.MapPutIfAbsentRequest;
import com.hazelcast.map.impl.client.MapPutRequest;
import com.hazelcast.map.impl.client.MapPutTransientRequest;
import com.hazelcast.map.impl.client.MapQueryRequest;
import com.hazelcast.map.impl.client.MapRemoveEntryListenerRequest;
import com.hazelcast.map.impl.client.MapRemoveIfSameRequest;
import com.hazelcast.map.impl.client.MapRemoveInterceptorRequest;
import com.hazelcast.map.impl.client.MapRemoveRequest;
import com.hazelcast.map.impl.client.MapReplaceIfSameRequest;
import com.hazelcast.map.impl.client.MapReplaceRequest;
import com.hazelcast.map.impl.client.MapSetRequest;
import com.hazelcast.map.impl.client.MapSizeRequest;
import com.hazelcast.map.impl.client.MapTryPutRequest;
import com.hazelcast.map.impl.client.MapTryRemoveRequest;
import com.hazelcast.map.impl.client.MapUnlockRequest;
import com.hazelcast.map.impl.client.MapValuesRequest;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.SortedQueryResultSet;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.ValidationUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private final String name;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();
    private volatile ClientHeapNearCache<Data> nearCache;

    public ClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    @Override
    public boolean containsKey(Object key) {
        Object cached;
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            return !cached.equals(ClientNearCache.NULL_OBJECT);
        }
        MapContainsKeyRequest request = new MapContainsKeyRequest(this.name, keyData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        MapContainsValueRequest request = new MapContainsValueRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public V get(Object key) {
        Object cached;
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            if (cached.equals(ClientHeapNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        KeyStateMarker keyStateMarker = this.getKeyStateMarker();
        boolean marked = keyStateMarker.tryMark(keyData);
        MapGetRequest request = new MapGetRequest(this.name, keyData, ThreadUtil.getThreadId());
        Object result = this.invoke((ClientRequest)request, keyData);
        if (this.nearCache != null && marked) {
            this.tryToPutNearCache(keyStateMarker, keyData, result);
        }
        return (V)result;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V remove(Object key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        Object invoke = this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return (V)invoke;
    }

    @Override
    public boolean remove(Object key, Object value) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapRemoveIfSameRequest request = new MapRemoveIfSameRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return result;
    }

    @Override
    public void delete(Object key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapDeleteRequest request = new MapDeleteRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
    }

    @Override
    public void flush() {
        MapFlushRequest request = new MapFlushRequest(this.name);
        this.invoke(request);
    }

    @Override
    public Future<V> getAsync(K key) {
        Object cached;
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        final Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null && !ClientNearCache.NULL_OBJECT.equals(cached)) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        final KeyStateMarker keyStateMarker = this.getKeyStateMarker();
        final boolean marked = keyStateMarker.tryMark(keyData);
        MapGetRequest request = new MapGetRequest(this.name, keyData, ThreadUtil.getThreadId());
        request.setAsAsync();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.getContext().getSerializationService());
            delegatingFuture.andThen(new ExecutionCallback<V>(){

                @Override
                public void onResponse(V response) {
                    if (ClientMapProxy.this.nearCache != null && marked) {
                        ClientMapProxy.this.tryToPutNearCache(keyStateMarker, keyData, response);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
            return delegatingFuture;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        request.setAsAsync();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.getContext().getSerializationService());
            this.invalidateNearCache(keyData);
            return delegatingFuture;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future<V> removeAsync(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        request.setAsAsync();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            this.invalidateNearCache(keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapTryRemoveRequest request = new MapTryRemoveRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return result;
    }

    @Override
    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapTryPutRequest request = new MapTryPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return result;
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        Object invoke = this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return (V)invoke;
    }

    @Override
    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutTransientRequest request = new MapPutTransientRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke(request);
        this.invalidateNearCache(keyData);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutIfAbsentRequest request = new MapPutIfAbsentRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        Object invoke = this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return (V)invoke;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(oldValue, NULL_VALUE_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(newValue, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        MapReplaceIfSameRequest request = new MapReplaceIfSameRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return result;
    }

    @Override
    public V replace(K key, V value) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapReplaceRequest request = new MapReplaceRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Object invoke = this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
        return (V)invoke;
    }

    @Override
    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapSetRequest request = new MapSetRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke((ClientRequest)request, keyData);
        this.invalidateNearCache(keyData);
    }

    @Override
    public void lock(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public boolean isLocked(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapIsLockedRequest request = new MapIsLockedRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public void unlock(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), false);
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void forceUnlock(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), true);
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        MapAddInterceptorRequest request = new MapAddInterceptorRequest(this.name, interceptor);
        return (String)this.invoke(request);
    }

    @Override
    public void removeInterceptor(String id) {
        MapRemoveInterceptorRequest request = new MapRemoveInterceptorRequest(this.name, id);
        this.invoke(request);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    @Override
    public boolean removeEntryListener(String id) {
        MapRemoveEntryListenerRequest request = new MapRemoveEntryListenerRequest(this.name, id);
        return this.stopListening(request, id);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, null, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, null, handler);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapGetEntryViewRequest request = new MapGetEntryViewRequest(this.name, keyData, ThreadUtil.getThreadId());
        SimpleEntryView entryView = (SimpleEntryView)this.invoke((ClientRequest)request, keyData);
        if (entryView == null) {
            return null;
        }
        Data value = (Data)entryView.getValue();
        entryView.setKey(key);
        entryView.setValue(this.toObject(value));
        return entryView;
    }

    @Override
    public boolean evict(K key) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapEvictRequest request = new MapEvictRequest(this.name, keyData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void evictAll() {
        this.clearNearCache();
        MapEvictAllRequest request = new MapEvictAllRequest(this.name);
        this.invoke(request);
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.clearNearCache();
        }
        MapLoadAllKeysRequest request = new MapLoadAllKeysRequest(this.name, replaceExistingValues);
        this.invoke(request);
    }

    @Override
    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        ValidationUtil.checkNotNull(keys, "Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        List<Data> dataKeys = this.convertKeysToData(keys);
        MapLoadGivenKeysRequest request = new MapLoadGivenKeysRequest(this.name, dataKeys, replaceExistingValues);
        this.invoke(request);
        if (replaceExistingValues) {
            this.invalidateNearCache(dataKeys);
        }
    }

    private <K> List<Data> convertKeysToData(Set<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
            Data dataKey = this.toData(key);
            dataKeys.add(dataKey);
        }
        return dataKeys;
    }

    @Override
    public Set<K> keySet() {
        MapKeySetRequest request = new MapKeySetRequest(this.name);
        MapKeySet mapKeySet = (MapKeySet)this.invoke(request);
        Set<Data> keySetData = mapKeySet.getKeySet();
        HashSet keySet = new HashSet(keySetData.size());
        for (Data data : keySetData) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        this.initNearCache();
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        HashMap result = new HashMap();
        for (Object key : keys) {
            keySet.add(this.toData(key));
        }
        if (this.nearCache != null) {
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object key;
                key = (Data)iterator.next();
                Object cached = this.nearCache.get((Data)key);
                if (cached == null || ClientHeapNearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        if (keySet.isEmpty()) {
            return result;
        }
        KeyStateMarker keyStateMarker = this.getKeyStateMarker();
        HashMap<Data, Boolean> markers = new HashMap<Data, Boolean>(keys.size());
        for (Data data : keySet) {
            markers.put(data, keyStateMarker.tryMark(data));
        }
        MapGetAllRequest request = new MapGetAllRequest(this.name, keySet);
        MapEntrySet mapEntrySet = (MapEntrySet)this.invoke(request);
        Set<Map.Entry<Data, Data>> entrySet = mapEntrySet.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entrySet) {
            Data dataKey = dataEntry.getKey();
            Object key = this.toObject(dataKey);
            Object value = this.toObject(dataEntry.getValue());
            result.put(key, value);
            if (this.nearCache == null || !((Boolean)markers.get(dataKey)).booleanValue()) continue;
            this.tryToPutNearCache(keyStateMarker, dataKey, value);
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        MapValuesRequest request = new MapValuesRequest(this.name);
        MapValueCollection mapValueCollection = (MapValueCollection)this.invoke(request);
        Collection<Data> collectionData = mapValueCollection.getValues();
        ArrayList collection = new ArrayList(collectionData.size());
        for (Data data : collectionData) {
            Object value = this.toObject(data);
            collection.add(value);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        MapEntrySetRequest request = new MapEntrySetRequest(this.name);
        MapEntrySet result = (MapEntrySet)this.invoke(request);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<Data, Data>> entries = result.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entries) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.KEY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.keySet(pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.KEY);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        if (pagingPredicate == null) {
            HashSet keySet = new HashSet();
            for (Object o : result) {
                Object key = this.toObject(o);
                keySet.add(key);
            }
            return keySet;
        }
        Comparator<Map.Entry> comparator = SortingUtil.newComparator(pagingPredicate.getComparator(), IterationType.KEY);
        SortedQueryResultSet sortedResult = new SortedQueryResultSet(comparator, IterationType.KEY, pagingPredicate.getPageSize());
        Iterator<Map.Entry> iterator = result.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            sortedResult.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, sortedResult.last());
        return sortedResult;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.ENTRY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.entrySet(pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.ENTRY);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        AbstractSet entrySet = pagingPredicate == null ? new HashSet(result.size()) : new SortedQueryResultSet(pagingPredicate.getComparator(), IterationType.ENTRY, pagingPredicate.getPageSize());
        for (Object data : result) {
            AbstractMap.SimpleImmutableEntry dataEntry = (AbstractMap.SimpleImmutableEntry)data;
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        if (pagingPredicate != null) {
            PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, ((SortedQueryResultSet)entrySet).last());
        }
        return entrySet;
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.VALUE);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.values(pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.VALUE);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        if (pagingPredicate == null) {
            ArrayList values = new ArrayList(result.size());
            for (Object data : result) {
                Object value = this.toObject(data);
                values.add(value);
            }
            return values;
        }
        List valueEntryList = new ArrayList(result.size());
        Iterator<Map.Entry> iterator = result.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            valueEntryList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        Collections.sort(valueEntryList, SortingUtil.newComparator(pagingPredicate.getComparator(), IterationType.VALUE));
        if (valueEntryList.size() > pagingPredicate.getPageSize()) {
            valueEntryList = valueEntryList.subList(0, pagingPredicate.getPageSize());
        }
        Map.Entry anchor = null;
        if (valueEntryList.size() != 0) {
            anchor = (Map.Entry)valueEntryList.get(valueEntryList.size() - 1);
        }
        PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, anchor);
        ArrayList values = new ArrayList(valueEntryList.size());
        for (Map.Entry objectVEntry : valueEntryList) {
            values.add(objectVEntry.getValue());
        }
        return values;
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public void addIndex(String attribute, boolean ordered) {
        MapAddIndexRequest request = new MapAddIndexRequest(this.name, attribute, ordered);
        this.invoke(request);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        this.initNearCache();
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        if (this.nearCache != null) {
            localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        }
        return localMapStats;
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        return this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        request.setAsSubmitToKey();
        try {
            ClientCallFuture future = (ClientCallFuture)this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            future.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        ValidationUtil.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        request.setAsSubmitToKey();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        MapExecuteOnAllKeysRequest request = new MapExecuteOnAllKeysRequest(this.name, entryProcessor);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        MapExecuteWithPredicateRequest request = new MapExecuteWithPredicateRequest(this.name, entryProcessor, predicate);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            ValidationUtil.isNotNull(jobTracker, "jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap(this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator<Map.Entry, Result> collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture<Result> future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    @Override
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key));
        }
        MapExecuteOnKeysRequest request = new MapExecuteOnKeysRequest(this.name, entryProcessor, dataKeys);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        MapSizeRequest request = new MapSizeRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean isEmpty() {
        MapIsEmptyRequest request = new MapIsEmptyRequest(this.name);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        MapEntrySet entrySet = new MapEntrySet();
        ArrayList<Data> keysToInvalidate = new ArrayList<Data>(m.entrySet().size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Data keyData = this.toData(entry.getKey());
            keysToInvalidate.add(keyData);
            entrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        MapPutAllRequest request = new MapPutAllRequest(this.name, entrySet);
        this.invoke(request);
        for (Data data : keysToInvalidate) {
            this.invalidateNearCache(data);
        }
    }

    @Override
    public void clear() {
        MapClearRequest request = new MapClearRequest(this.name);
        this.invoke(request);
        this.clearNearCache();
    }

    @Override
    protected void onDestroy() {
        this.destroyNearCache();
    }

    private void destroyNearCache() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.nearCache.destroy();
        }
    }

    @Override
    protected void onShutdown() {
        this.destroyNearCache();
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                MemberImpl member = ClientMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(this.createEntryEvent(event, member));
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(this.createEntryEvent(event, member));
                        break;
                    }
                    case UPDATED: {
                        listener.entryUpdated(this.createEntryEvent(event, member));
                        break;
                    }
                    case EVICTED: {
                        listener.entryEvicted(this.createEntryEvent(event, member));
                        break;
                    }
                    case EVICT_ALL: {
                        listener.mapEvicted(this.createMapEvent(event, member));
                        break;
                    }
                    case CLEAR_ALL: {
                        listener.mapCleared(this.createMapEvent(event, member));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a known event type " + (Object)((Object)event.getEventType()));
                    }
                }
            }

            private MapEvent createMapEvent(PortableEntryEvent event, Member member) {
                return new MapEvent(ClientMapProxy.this.name, member, event.getEventType().getType(), event.getNumberOfAffectedEntries());
            }

            private EntryEvent<K, V> createEntryEvent(PortableEntryEvent event, Member member) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMapProxy.this.toObject(event.getValue());
                    oldValue = ClientMapProxy.this.toObject(event.getOldValue());
                }
                Object key = ClientMapProxy.this.toObject(event.getKey());
                return new EntryEvent<Object, Object>(ClientMapProxy.this.name, member, event.getEventType().getType(), key, oldValue, value);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    private void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate(key);
        }
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (this.nearCache != null) {
            if (keys == null || keys.isEmpty()) {
                return;
            }
            for (Data key : keys) {
                this.nearCache.invalidate(key);
            }
        }
    }

    private void clearNearCache() {
        if (this.nearCache != null) {
            this.nearCache.clear();
        }
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            this.nearCache = new ClientHeapNearCache(this.name, this.getContext(), nearCacheConfig);
            if (this.nearCache.isInvalidateOnChange()) {
                this.addNearCacheInvalidateListener();
            }
        }
    }

    private void addNearCacheInvalidateListener() {
        try {
            MapAddNearCacheEntryListenerRequest request = new MapAddNearCacheEntryListenerRequest(this.name, false);
            EventHandler<PortableEntryEvent> handler = new EventHandler<PortableEntryEvent>(){

                @Override
                public void handle(PortableEntryEvent event) {
                    switch (event.getEventType()) {
                        case ADDED: 
                        case REMOVED: 
                        case UPDATED: 
                        case EVICTED: {
                            Data key = event.getKey();
                            ClientMapProxy.this.nearCache.invalidate(key);
                            break;
                        }
                        case EVICT_ALL: 
                        case CLEAR_ALL: {
                            ClientMapProxy.this.clearNearCache();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Not a known event type " + (Object)((Object)event.getEventType()));
                        }
                    }
                }

                @Override
                public void beforeListenerRegister() {
                    ClientMapProxy.this.nearCache.clear();
                }

                @Override
                public void onListenerRegister() {
                    ClientMapProxy.this.nearCache.clear();
                }
            };
            String registrationId = this.getContext().getListenerService().listen(request, null, handler);
            this.nearCache.setId(registrationId);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", e);
        }
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.nearCache.getId() != null) {
            String registrationId = this.nearCache.getId();
            MapRemoveEntryListenerRequest request = new MapRemoveEntryListenerRequest(this.name, registrationId);
            this.getContext().getListenerService().stopListening(request, registrationId);
        }
    }

    public ClientHeapNearCache<Data> getNearCache() {
        return this.nearCache;
    }

    private KeyStateMarker getKeyStateMarker() {
        return this.nearCache == null ? KeyStateMarker.EMPTY_MARKER : this.nearCache.getKeyStateMarker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToPutNearCache(KeyStateMarker keyStateMarker, Data key, Object value) {
        try {
            this.nearCache.put(key, value);
        }
        finally {
            if (!keyStateMarker.tryUnmark(key)) {
                this.invalidateNearCache(key);
                keyStateMarker.resetState(key);
            }
        }
    }

    public String toString() {
        return "IMap{name='" + this.getName() + '\'' + '}';
    }
}

