/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.operations.AwaitBackupOperation;
import com.hazelcast.concurrent.lock.operations.AwaitOperation;
import com.hazelcast.concurrent.lock.operations.BeforeAwaitBackupOperation;
import com.hazelcast.concurrent.lock.operations.BeforeAwaitOperation;
import com.hazelcast.concurrent.lock.operations.GetLockCountOperation;
import com.hazelcast.concurrent.lock.operations.GetRemainingLeaseTimeOperation;
import com.hazelcast.concurrent.lock.operations.IsLockedOperation;
import com.hazelcast.concurrent.lock.operations.LockBackupOperation;
import com.hazelcast.concurrent.lock.operations.LockOperation;
import com.hazelcast.concurrent.lock.operations.LockReplicationOperation;
import com.hazelcast.concurrent.lock.operations.SignalBackupOperation;
import com.hazelcast.concurrent.lock.operations.SignalOperation;
import com.hazelcast.concurrent.lock.operations.UnlockBackupOperation;
import com.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

public final class LockDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.lock", -15);
    public static final int AWAIT_BACKUP = 0;
    public static final int AWAIT = 1;
    public static final int BEFORE_AWAIT_BACKUP = 2;
    public static final int BEFORE_AWAIT = 3;
    public static final int GET_LOCK_COUNT = 4;
    public static final int GET_REMAINING_LEASETIME = 5;
    public static final int IS_LOCKED = 6;
    public static final int LOCK_BACKUP = 7;
    public static final int LOCK = 8;
    public static final int LOCK_REPLICATION = 9;
    public static final int SIGNAL_BACKUP = 10;
    public static final int SIGNAL = 11;
    public static final int UNLOCK_BACKUP = 12;
    public static final int UNLOCK = 13;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            @Override
            public IdentifiedDataSerializable create(int typeId) {
                switch (typeId) {
                    case 0: {
                        return new AwaitBackupOperation();
                    }
                    case 1: {
                        return new AwaitOperation();
                    }
                    case 2: {
                        return new BeforeAwaitBackupOperation();
                    }
                    case 3: {
                        return new BeforeAwaitOperation();
                    }
                    case 4: {
                        return new GetLockCountOperation();
                    }
                    case 5: {
                        return new GetRemainingLeaseTimeOperation();
                    }
                    case 6: {
                        return new IsLockedOperation();
                    }
                    case 8: {
                        return new LockOperation();
                    }
                    case 7: {
                        return new LockBackupOperation();
                    }
                    case 9: {
                        return new LockReplicationOperation();
                    }
                    case 10: {
                        return new SignalBackupOperation();
                    }
                    case 11: {
                        return new SignalOperation();
                    }
                    case 12: {
                        return new UnlockBackupOperation();
                    }
                    case 13: {
                        return new UnlockOperation();
                    }
                }
                return null;
            }
        };
    }
}

