/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.distributed;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.entry.CacheEntry;

public class IMapRegionCache
implements RegionCache {
    private static final long COMPARISON_VALUE = 500L;
    private static final SoftLock LOCK_SUCCESS = new SoftLock(){};
    private static final SoftLock LOCK_FAILURE = new SoftLock(){};
    private final String name;
    private final HazelcastInstance hazelcastInstance;
    private final IMap<Object, Object> map;
    private final Comparator versionComparator;
    private final int lockTimeout;
    private final long tryLockAndGetTimeout;
    private final boolean explicitVersionCheckEnabled;
    private final ILogger logger;

    public IMapRegionCache(String name, HazelcastInstance hazelcastInstance, Properties props, CacheDataDescription metadata) {
        this.name = name;
        this.hazelcastInstance = hazelcastInstance;
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.map = hazelcastInstance.getMap(this.name);
        this.lockTimeout = CacheEnvironment.getLockTimeoutInMillis(props);
        long maxOperationTimeout = HazelcastTimestamper.getMaxOperationTimeout(hazelcastInstance);
        this.tryLockAndGetTimeout = Math.min(maxOperationTimeout, 500L);
        this.explicitVersionCheckEnabled = CacheEnvironment.isExplicitVersionCheckEnabled(props);
        this.logger = this.createLogger(name, hazelcastInstance);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean put(Object key, Object value, Object currentVersion) {
        return this.update(key, value, currentVersion, null, null);
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        if (lock == LOCK_FAILURE) {
            this.logger.warning("Cache lock could not be acquired!");
            return false;
        }
        if (this.versionComparator != null && currentVersion != null) {
            if (this.explicitVersionCheckEnabled && value instanceof CacheEntry) {
                return this.compareVersion(key, value);
            }
            if (previousVersion == null || this.versionComparator.compare(currentVersion, previousVersion) > 0) {
                this.map.set(key, value);
                return true;
            }
            return false;
        }
        this.map.set(key, value);
        return true;
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        try {
            return this.map.tryLock(key, this.lockTimeout, TimeUnit.MILLISECONDS) ? LOCK_SUCCESS : LOCK_FAILURE;
        }
        catch (InterruptedException e) {
            return LOCK_FAILURE;
        }
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        if (lock == LOCK_SUCCESS) {
            this.map.unlock(key);
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.evictAll();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.map.keySet()) {
            EntryView<Object, Object> entry = this.map.getEntryView(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    @Override
    public Map asMap() {
        return this.map;
    }

    private ILogger createLogger(String name, HazelcastInstance hazelcastInstance) {
        try {
            return hazelcastInstance.getLoggingService().getLogger(name);
        }
        catch (UnsupportedOperationException e) {
            return Logger.getLogger(name);
        }
    }

    private boolean compareVersion(Object key, Object value) {
        CacheEntry currentEntry = (CacheEntry)value;
        long timeout = System.currentTimeMillis() + this.tryLockAndGetTimeout;
        do {
            CacheEntry previousEntry;
            if ((previousEntry = (CacheEntry)this.map.get(key)) == null) {
                if (this.map.putIfAbsent(key, value) != null) continue;
                return true;
            }
            if (this.versionComparator.compare(currentEntry.getVersion(), previousEntry.getVersion()) > 0) {
                if (!this.map.replace(key, previousEntry, value)) continue;
                return true;
            }
            return false;
        } while (System.currentTimeMillis() < timeout);
        return false;
    }
}

