/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.txn;

import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.txn.TransactionalMultiMapProxySupport;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.TransactionSupport;
import java.util.ArrayList;
import java.util.Collection;

public class TransactionalMultiMapProxy<K, V>
extends TransactionalMultiMapProxySupport
implements TransactionalMultiMap<K, V> {
    public TransactionalMultiMapProxy(NodeEngine nodeEngine, MultiMapService service, String name, TransactionSupport tx) {
        super(nodeEngine, service, name, tx);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean put(K key, V value) throws TransactionException {
        this.checkTransactionState();
        Data dataKey = this.getNodeEngine().toData(key);
        Data dataValue = this.getNodeEngine().toData(value);
        return this.putInternal(dataKey, dataValue);
    }

    @Override
    public Collection<V> get(K key) {
        this.checkTransactionState();
        Data dataKey = this.getNodeEngine().toData(key);
        Collection<MultiMapRecord> coll = this.getInternal(dataKey);
        ArrayList collection = new ArrayList(coll.size());
        for (MultiMapRecord record : coll) {
            collection.add(this.getNodeEngine().toObject(record.getObject()));
        }
        return collection;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkTransactionState();
        Data dataKey = this.getNodeEngine().toData(key);
        Data dataValue = this.getNodeEngine().toData(value);
        return this.removeInternal(dataKey, dataValue);
    }

    @Override
    public Collection<V> remove(Object key) {
        this.checkTransactionState();
        Data dataKey = this.getNodeEngine().toData(key);
        Collection<MultiMapRecord> coll = this.removeAllInternal(dataKey);
        ArrayList result = new ArrayList(coll.size());
        for (MultiMapRecord record : coll) {
            result.add(this.getNodeEngine().toObject(record.getObject()));
        }
        return result;
    }

    @Override
    public int valueCount(K key) {
        this.checkTransactionState();
        Data dataKey = this.getNodeEngine().toData(key);
        return this.valueCountInternal(dataKey);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionalMultiMap{");
        sb.append("name=").append(this.getName());
        sb.append('}');
        return sb.toString();
    }
}

