/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.impl;

import com.hazelcast.aws.security.EC2RequestSigner;
import com.hazelcast.aws.utility.CloudyUtility;
import com.hazelcast.config.AwsConfig;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DescribeInstances {
    String timeStamp = this.getFormattedTimestamp();
    private EC2RequestSigner rs;
    private AwsConfig awsConfig;
    private String endpoint;
    private Map<String, String> attributes = new HashMap<String, String>();

    public DescribeInstances(AwsConfig awsConfig, String endpoint) {
        if (awsConfig == null) {
            throw new IllegalArgumentException("AwsConfig is required!");
        }
        if (awsConfig.getAccessKey() == null) {
            throw new IllegalArgumentException("AWS access key is required!");
        }
        this.awsConfig = awsConfig;
        this.endpoint = endpoint;
        this.rs = new EC2RequestSigner(awsConfig, this.timeStamp, endpoint);
        this.attributes.put("Action", this.getClass().getSimpleName());
        this.attributes.put("Version", "2014-06-15");
        this.attributes.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        this.attributes.put("X-Amz-Credential", this.rs.createFormattedCredential());
        this.attributes.put("X-Amz-Date", this.timeStamp);
        this.attributes.put("X-Amz-SignedHeaders", "host");
        this.attributes.put("X-Amz-Expires", "30");
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    public Map<String, String> execute() throws Exception {
        String signature = this.rs.sign("ec2", this.attributes);
        this.attributes.put("X-Amz-Signature", signature);
        InputStream stream = this.callService(this.endpoint, signature);
        return CloudyUtility.unmarshalTheResponse(stream, this.awsConfig);
    }

    private InputStream callService(String endpoint, String signature) throws Exception {
        String query = this.rs.getCanonicalizedQueryString(this.attributes);
        URL url = new URL("https", endpoint, -1, "/?" + query);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(false);
        httpConnection.connect();
        return httpConnection.getInputStream();
    }
}

