/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.operation.CachePutAllBackupOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheException;

public class CacheLoadAllOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable,
BackupAwareOperation {
    private Set<Data> keys;
    private boolean replaceExistingValues;
    private boolean shouldBackup;
    private transient Map<Data, CacheRecord> backupRecords;
    private transient ICacheRecordStore cache;
    private Object response;

    public CacheLoadAllOperation(String name, Set<Data> keys, boolean replaceExistingValues) {
        super(name);
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
    }

    public CacheLoadAllOperation() {
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        HashSet<Data> filteredKeys = new HashSet<Data>();
        if (this.keys != null) {
            for (Data k : this.keys) {
                if (partitionService.getPartitionId(k) != partitionId) continue;
                filteredKeys.add(k);
            }
        }
        if (filteredKeys.isEmpty()) {
            return;
        }
        try {
            CacheService service = (CacheService)this.getService();
            this.cache = service.getOrCreateCache(this.name, partitionId);
            Set<Data> keysLoaded = this.cache.loadAll(filteredKeys, this.replaceExistingValues);
            boolean bl = this.shouldBackup = !keysLoaded.isEmpty();
            if (this.shouldBackup) {
                this.backupRecords = new HashMap<Data, CacheRecord>();
                for (Data key : keysLoaded) {
                    this.backupRecords.put(key, this.cache.getRecord(key));
                }
            }
        }
        catch (CacheException e) {
            this.response = new CacheClearResponse((Object)e);
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.backupRecords);
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.replaceExistingValues);
        out.writeBoolean(this.keys != null);
        if (this.keys != null) {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                out.writeData(key);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.replaceExistingValues = in.readBoolean();
        boolean isKeysNotNull = in.readBoolean();
        if (isKeysNotNull) {
            int size = in.readInt();
            this.keys = new HashSet<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data key = in.readData();
                this.keys.add(key);
            }
        }
    }
}

