/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.operation.CacheManagementConfigOperation;
import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class CacheManagementConfigRequest
extends TargetClientRequest {
    private String name;
    private boolean isStat;
    private boolean enabled;
    private Address target;

    public CacheManagementConfigRequest() {
    }

    public CacheManagementConfigRequest(String name, boolean isStat, boolean enabled, Address target) {
        this.name = name;
        this.isStat = isStat;
        this.enabled = enabled;
        this.target = target;
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheManagementConfigOperation(this.name, this.isStat, this.enabled);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.operationService.createInvocationBuilder(this.getServiceName(), op, this.target);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("s", this.isStat);
        writer.writeBoolean("e", this.enabled);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        this.target.writeData(rawDataOutput);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.isStat = reader.readBoolean("s");
        this.enabled = reader.readBoolean("e");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.target = new Address();
        this.target.readData(rawDataInput);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

