/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="IQueue")
public class QueueMBean
extends HazelcastMBean<IQueue> {
    private final boolean totalEnabled;
    private final AtomicLong totalAddedItemCount = new AtomicLong();
    private final AtomicLong totalRemovedItemCount = new AtomicLong();
    private final String registrationId;

    protected QueueMBean(IQueue managedObject, ManagementService service) {
        super(managedObject, service);
        this.totalEnabled = service.instance.node.groupProperties.ENABLE_JMX_DETAILED.getBoolean();
        this.objectName = service.createObjectName("IQueue", managedObject.getName());
        if (this.totalEnabled) {
            ItemListener itemListener = new ItemListener(){

                public void itemAdded(ItemEvent item) {
                    QueueMBean.this.totalAddedItemCount.incrementAndGet();
                }

                public void itemRemoved(ItemEvent item) {
                    QueueMBean.this.totalRemovedItemCount.incrementAndGet();
                }
            };
            this.registrationId = managedObject.addItemListener(itemListener, false);
        } else {
            this.registrationId = null;
        }
    }

    @ManagedAnnotation(value="localOwnedItemCount")
    @ManagedDescription(value="the number of owned items in this member.")
    public long getLocalOwnedItemCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getOwnedItemCount();
    }

    @ManagedAnnotation(value="localBackupItemCount")
    @ManagedDescription(value="the number of backup items in this member.")
    public long getLocalBackupItemCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getBackupItemCount();
    }

    @ManagedAnnotation(value="localMinAge")
    @ManagedDescription(value="the min age of the items in this member.")
    public long getLocalMinAge() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getMinAge();
    }

    @ManagedAnnotation(value="localMaxAge")
    @ManagedDescription(value="the max age of the items in this member.")
    public long getLocalMaxAge() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getMaxAge();
    }

    @ManagedAnnotation(value="localAvgAge")
    @ManagedDescription(value="the average age of the items in this member.")
    public long getLocalAvgAge() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getAvgAge();
    }

    @ManagedAnnotation(value="localOfferOperationCount")
    @ManagedDescription(value="the number of offer/put/add operations in this member")
    public long getLocalOfferOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getOfferOperationCount();
    }

    @ManagedAnnotation(value="localRejectedOfferOperationCount")
    @ManagedDescription(value="the number of rejected offers in this member")
    public long getLocalRejectedOfferOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getRejectedOfferOperationCount();
    }

    @ManagedAnnotation(value="localPollOperationCount")
    @ManagedDescription(value="the number of poll/take/remove operations in this member")
    public long getLocalPollOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getPollOperationCount();
    }

    @ManagedAnnotation(value="localEmptyPollOperationCount")
    @ManagedDescription(value="number of null returning poll operations in this member")
    public long getLocalEmptyPollOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getEmptyPollOperationCount();
    }

    @ManagedAnnotation(value="localOtherOperationsCount")
    @ManagedDescription(value="number of other operations in this member")
    public long getLocalOtherOperationsCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getOtherOperationsCount();
    }

    @ManagedAnnotation(value="localEventOperationCount")
    @ManagedDescription(value="number of event operations in this member")
    public long getLocalEventOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getEventOperationCount();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((IQueue)this.managedObject).getName();
    }

    @ManagedAnnotation(value="partitionKey")
    @ManagedDescription(value="the partitionKey")
    public String getPartitionKey() {
        return ((IQueue)this.managedObject).getPartitionKey();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="QueueConfig")
    public String getConfig() {
        String managedObjectName = ((IQueue)this.managedObject).getName();
        Config config = this.service.instance.getConfig();
        QueueConfig queueConfig = config.findQueueConfig(managedObjectName);
        return queueConfig.toString();
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Queue")
    public void clear() {
        ((IQueue)this.managedObject).clear();
    }

    @ManagedAnnotation(value="totalAddedItemCount")
    public long getTotalAddedItemCount() {
        return this.totalAddedItemCount.get();
    }

    @ManagedAnnotation(value="totalRemovedItemCount")
    public long getTotalRemovedItemCount() {
        return this.totalRemovedItemCount.get();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.totalEnabled) {
            try {
                ((IQueue)this.managedObject).removeItemListener(this.registrationId);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }
}

