/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.map.impl.NearCacheRecord;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NearCache {
    public static final Object NULL_OBJECT = new Object();
    public static final String NEAR_CACHE_EXECUTOR_NAME = "hz:near-cache";
    private static final double EVICTION_FACTOR = 0.2;
    private static final int CLEANUP_INTERVAL = 5000;
    private final int maxSize;
    private volatile long lastCleanup;
    private final long maxIdleMillis;
    private final long timeToLiveMillis;
    private final EvictionPolicy evictionPolicy;
    private final InMemoryFormat inMemoryFormat;
    private final NodeEngine nodeEngine;
    private final AtomicBoolean canCleanUp;
    private final AtomicBoolean canEvict;
    private final ConcurrentMap<Data, NearCacheRecord> cache;
    private final NearCacheStatsImpl nearCacheStats;
    private final SerializationService serializationService;
    private final Comparator<NearCacheRecord> selectedComparator;
    private SizeEstimator nearCacheSizeEstimator;

    public NearCache(String mapName, NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        Config config = nodeEngine.getConfig();
        NearCacheConfig nearCacheConfig = config.findMapConfig(mapName).getNearCacheConfig();
        this.maxSize = nearCacheConfig.getMaxSize() <= 0 ? Integer.MAX_VALUE : nearCacheConfig.getMaxSize();
        this.maxIdleMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getMaxIdleSeconds());
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getTimeToLiveSeconds());
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.selectedComparator = NearCacheRecord.getComparator(this.evictionPolicy);
        this.cache = new ConcurrentHashMap<Data, NearCacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.nearCacheStats = new NearCacheStatsImpl();
        this.lastCleanup = Clock.currentTimeMillis();
        this.serializationService = nodeEngine.getSerializationService();
    }

    public Object put(Data key, Data data) {
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            if (data == null) {
                return null;
            }
            return this.inMemoryFormat.equals((Object)InMemoryFormat.OBJECT) ? this.serializationService.toObject(data) : data;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        Object value = data == null ? NULL_OBJECT : (this.inMemoryFormat.equals((Object)InMemoryFormat.OBJECT) ? this.serializationService.toObject(data) : data);
        NearCacheRecord record = new NearCacheRecord(key, value);
        NearCacheRecord previous = this.cache.put(key, record);
        this.updateSizeEstimatorWithRecords(previous, record);
        if (NULL_OBJECT.equals(value)) {
            return null;
        }
        return value;
    }

    private void updateSizeEstimatorWithRecords(NearCacheRecord previous, NearCacheRecord record) {
        this.updateSizeEstimator(this.calculateCost(record));
        if (previous != null) {
            this.updateSizeEstimator(-this.calculateCost(previous));
        }
    }

    public NearCacheStatsImpl getNearCacheStats() {
        return this.createNearCacheStats();
    }

    private NearCacheStatsImpl createNearCacheStats() {
        long ownedEntryCount = 0L;
        long ownedEntryMemoryCost = 0L;
        for (NearCacheRecord record : this.cache.values()) {
            ++ownedEntryCount;
            ownedEntryMemoryCost += record.getCost();
        }
        this.nearCacheStats.setOwnedEntryCount(ownedEntryCount);
        this.nearCacheStats.setOwnedEntryMemoryCost(ownedEntryMemoryCost);
        return this.nearCacheStats;
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                final ExecutionService executionService = this.nodeEngine.getExecutionService();
                executionService.execute(NEAR_CACHE_EXECUTOR_NAME, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(NearCache.this.selectedComparator);
                            records.addAll(NearCache.this.cache.values());
                            int evictSize = (int)((double)NearCache.this.cache.size() * 0.2);
                            int i = 0;
                            for (NearCacheRecord record : records) {
                                NearCache.this.cache.remove(record.getKey());
                                NearCache.this.updateSizeEstimator(-NearCache.this.calculateCost(record));
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            NearCache.this.canEvict.set(true);
                        }
                        if (NearCache.this.cache.size() >= NearCache.this.maxSize && NearCache.this.canEvict.compareAndSet(true, false)) {
                            try {
                                executionService.execute(NearCache.NEAR_CACHE_EXECUTOR_NAME, this);
                            }
                            catch (RejectedExecutionException e) {
                                NearCache.this.canEvict.set(true);
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.nodeEngine.getExecutionService().execute(NEAR_CACHE_EXECUTOR_NAME, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            NearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : NearCache.this.cache.entrySet()) {
                                if (!((NearCacheRecord)entry.getValue()).isExpired(NearCache.this.maxIdleMillis, NearCache.this.timeToLiveMillis)) continue;
                                Data key = (Data)entry.getKey();
                                NearCacheRecord record = (NearCacheRecord)NearCache.this.cache.remove(key);
                                if (record == null) continue;
                                NearCache.this.updateSizeEstimator(-NearCache.this.calculateCost(record));
                            }
                        }
                        finally {
                            NearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    public Object get(Data key) {
        this.fireTtlCleanup();
        NearCacheRecord record = (NearCacheRecord)this.cache.get(key);
        if (record != null) {
            if (record.isExpired(this.maxIdleMillis, this.timeToLiveMillis)) {
                this.cache.remove(key);
                this.updateSizeEstimator(-this.calculateCost(record));
                this.nearCacheStats.incrementMisses();
                return null;
            }
            this.nearCacheStats.incrementHits();
            record.access();
            return record.getValue();
        }
        this.nearCacheStats.incrementMisses();
        return null;
    }

    public void invalidate(Data key) {
        NearCacheRecord record = (NearCacheRecord)this.cache.remove(key);
        if (record != null) {
            this.updateSizeEstimator(-this.calculateCost(record));
        }
    }

    public void invalidate(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Data key : keys) {
            this.invalidate(key);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
        this.resetSizeEstimator();
    }

    public Map<Data, NearCacheRecord> getReadonlyMap() {
        return Collections.unmodifiableMap(this.cache);
    }

    private void resetSizeEstimator() {
        this.getNearCacheSizeEstimator().reset();
    }

    private void updateSizeEstimator(long size) {
        this.getNearCacheSizeEstimator().add(size);
    }

    private long calculateCost(NearCacheRecord record) {
        return this.getNearCacheSizeEstimator().getCost(record);
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public void setNearCacheSizeEstimator(SizeEstimator nearCacheSizeEstimator) {
        this.nearCacheSizeEstimator = nearCacheSizeEstimator;
    }
}

