/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.concurrent.lock.LockProxySupport;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.Member;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapContextQuerySupport;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapEventPublisher;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.NearCache;
import com.hazelcast.map.impl.NearCacheProvider;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.QueryEventFilter;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AddIndexOperation;
import com.hazelcast.map.impl.operation.AddInterceptorOperation;
import com.hazelcast.map.impl.operation.BasePutOperation;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.operation.ClearOperation;
import com.hazelcast.map.impl.operation.ContainsKeyOperation;
import com.hazelcast.map.impl.operation.ContainsValueOperationFactory;
import com.hazelcast.map.impl.operation.DeleteOperation;
import com.hazelcast.map.impl.operation.EntryOperation;
import com.hazelcast.map.impl.operation.EvictAllOperation;
import com.hazelcast.map.impl.operation.EvictOperation;
import com.hazelcast.map.impl.operation.GetEntryViewOperation;
import com.hazelcast.map.impl.operation.GetOperation;
import com.hazelcast.map.impl.operation.IsEmptyOperationFactory;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.map.impl.operation.LoadAllOperation;
import com.hazelcast.map.impl.operation.LoadMapOperation;
import com.hazelcast.map.impl.operation.MapFlushOperation;
import com.hazelcast.map.impl.operation.MapGetAllOperationFactory;
import com.hazelcast.map.impl.operation.MultipleEntryOperationFactory;
import com.hazelcast.map.impl.operation.PartitionCheckIfLoadedOperation;
import com.hazelcast.map.impl.operation.PartitionCheckIfLoadedOperationFactory;
import com.hazelcast.map.impl.operation.PartitionWideEntryWithPredicateOperationFactory;
import com.hazelcast.map.impl.operation.PutAllOperation;
import com.hazelcast.map.impl.operation.PutIfAbsentOperation;
import com.hazelcast.map.impl.operation.PutOperation;
import com.hazelcast.map.impl.operation.PutTransientOperation;
import com.hazelcast.map.impl.operation.RemoveIfSameOperation;
import com.hazelcast.map.impl.operation.RemoveInterceptorOperation;
import com.hazelcast.map.impl.operation.RemoveOperation;
import com.hazelcast.map.impl.operation.ReplaceIfSameOperation;
import com.hazelcast.map.impl.operation.ReplaceOperation;
import com.hazelcast.map.impl.operation.SetOperation;
import com.hazelcast.map.impl.operation.SizeOperationFactory;
import com.hazelcast.map.impl.operation.TryPutOperation;
import com.hazelcast.map.impl.operation.TryRemoveOperation;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.IterableUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

abstract class MapProxySupport
extends AbstractDistributedObject<MapService>
implements InitializingObject {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Predicate should not be null!";
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    private static final int CHECK_IF_LOADED_TIMEOUT_SECONDS = 60;
    protected final String name;
    protected final LocalMapStatsImpl localMapStats;
    protected final LockProxySupport lockSupport;
    protected final PartitioningStrategy partitionStrategy;
    private MapServiceContext mapServiceContext;
    private InternalPartitionService partitionService;

    protected MapProxySupport(String name, MapService service, NodeEngine nodeEngine) {
        super(nodeEngine, service);
        this.name = name;
        this.mapServiceContext = service.getMapServiceContext();
        this.partitionStrategy = this.mapServiceContext.getMapContainer(name).getPartitioningStrategy();
        this.localMapStats = this.mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(name);
        this.partitionService = this.getNodeEngine().getPartitionService();
        this.lockSupport = new LockProxySupport(new DefaultObjectNamespace("hz:impl:mapService", name));
    }

    @Override
    public void initialize() {
        this.initializeListeners();
        this.initializeIndexes();
        this.initializeMapStoreLoad();
    }

    private void initializeMapStoreLoad() {
        MapStoreConfig.InitialLoadMode initialLoadMode;
        MapStoreConfig mapStoreConfig = this.getMapConfig().getMapStoreConfig();
        if (mapStoreConfig != null && mapStoreConfig.isEnabled() && MapStoreConfig.InitialLoadMode.EAGER.equals((Object)(initialLoadMode = mapStoreConfig.getInitialLoadMode()))) {
            this.waitUntilLoaded();
        }
    }

    private void initializeIndexes() {
        for (MapIndexConfig index : this.getMapConfig().getMapIndexConfigs()) {
            if (index.getAttribute() == null) continue;
            this.addIndex(index.getAttribute(), index.isOrdered());
        }
    }

    private void initializeListeners() {
        MapListener listener;
        MapConfig mapConfig = this.getMapConfig();
        for (EntryListenerConfig entryListenerConfig : mapConfig.getEntryListenerConfigs()) {
            listener = (MapListener)this.initializeListener(entryListenerConfig);
            if (listener == null) continue;
            if (entryListenerConfig.isLocal()) {
                this.addLocalEntryListenerInternal(listener);
                continue;
            }
            this.addEntryListenerInternal(listener, null, entryListenerConfig.isIncludeValue());
        }
        for (MapPartitionLostListenerConfig mapPartitionLostListenerConfig : mapConfig.getPartitionLostListenerConfigs()) {
            listener = (MapPartitionLostListener)this.initializeListener(mapPartitionLostListenerConfig);
            if (listener == null) continue;
            this.addPartitionLostListenerInternal((MapPartitionLostListener)listener);
        }
    }

    private <T extends EventListener> T initializeListener(ListenerConfig listenerConfig) {
        T listener = this.getListenerImplOrNull(listenerConfig);
        if (listener instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)listener).setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        }
        return listener;
    }

    private <T extends EventListener> T getListenerImplOrNull(ListenerConfig listenerConfig) {
        EventListener implementation = listenerConfig.getImplementation();
        if (implementation != null) {
            if (implementation instanceof EntryListenerConfig.MapListenerToEntryListenerAdapter) {
                return (T)((EntryListenerConfig.MapListenerToEntryListenerAdapter)implementation).getMapListener();
            }
            return (T)implementation;
        }
        String className = listenerConfig.getClassName();
        if (className != null) {
            try {
                ClassLoader configClassLoader = this.getNodeEngine().getConfigClassLoader();
                return (T)((EventListener)ClassLoaderUtil.newInstance(configClassLoader, className));
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return null;
    }

    protected Object getInternal(Data key) {
        Data fromBackup;
        Object fromNearCache;
        MapConfig mapConfig = this.getMapConfig();
        boolean nearCacheEnabled = mapConfig.isNearCacheEnabled();
        if (nearCacheEnabled && (fromNearCache = this.getFromNearCache(key)) != null) {
            if (this.isCachedAsNullInNearCache(fromNearCache)) {
                return null;
            }
            return fromNearCache;
        }
        if (mapConfig.isReadBackupData() && (fromBackup = this.readBackupDataOrNull(key)) != null) {
            return fromBackup;
        }
        GetOperation operation = new GetOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        Data value = (Data)this.invokeOperation(key, operation);
        if (nearCacheEnabled && (this.notOwnerPartitionForKey(key) || this.cacheKeyAnyway())) {
            return this.putNearCache(key, value);
        }
        return value;
    }

    private boolean notOwnerPartitionForKey(Data key) {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        return !nodeEngine.getPartitionService().getPartitionOwner(partitionId).equals(nodeEngine.getClusterService().getThisAddress());
    }

    private boolean cacheKeyAnyway() {
        return this.getMapConfig().getNearCacheConfig().isCacheLocalEntries();
    }

    private Object putNearCache(Data key, Data value) {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
        return nearCacheProvider.putNearCache(this.name, key, value);
    }

    private Object getFromNearCache(Data key) {
        if (!this.getMapConfig().isNearCacheEnabled()) {
            return null;
        }
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
        Object cached = nearCacheProvider.getFromNearCache(this.name, key);
        if (cached == null) {
            return null;
        }
        mapServiceContext.interceptAfterGet(this.name, cached);
        return cached;
    }

    private void getFromNearCache(Map<Object, Object> resultMap, Collection<Data> keys) {
        if (!this.getMapConfig().isNearCacheEnabled()) {
            return;
        }
        MapService mapService = (MapService)this.getService();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Object fromNearCache = this.getFromNearCache(key);
            if (fromNearCache == null) continue;
            if (!this.isCachedAsNullInNearCache(fromNearCache)) {
                resultMap.put(mapService.getMapServiceContext().toObject(key), mapService.getMapServiceContext().toObject(fromNearCache));
            }
            iterator.remove();
        }
    }

    private boolean isCachedAsNullInNearCache(Object cached) {
        if (cached == null) {
            return false;
        }
        return NearCache.NULL_OBJECT.equals(cached);
    }

    private Data readBackupDataOrNull(Data key) {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = nodeEngine.getThisAddress();
        int partitionId = partitionService.getPartitionId(key);
        InternalPartition partition = partitionService.getPartition(partitionId, false);
        if (!partition.isOwnerOrBackup(thisAddress)) {
            return null;
        }
        PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partitionId);
        RecordStore recordStore = partitionContainer.getExistingRecordStore(this.name);
        if (recordStore == null) {
            return null;
        }
        return recordStore.readBackupData(key);
    }

    protected ICompletableFuture<Data> getAsyncInternal(final Data key) {
        Object cached;
        final NodeEngine nodeEngine = this.getNodeEngine();
        final MapService mapService = (MapService)this.getService();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        final boolean nearCacheEnabled = this.getMapConfig().isNearCacheEnabled();
        if (nearCacheEnabled && (cached = mapService.getMapServiceContext().getNearCacheProvider().getFromNearCache(this.name, key)) != null) {
            if (NearCache.NULL_OBJECT.equals(cached)) {
                cached = null;
            }
            return new CompletedFuture<Data>(nodeEngine.getSerializationService(), cached, nodeEngine.getExecutionService().getExecutor("hz:async"));
        }
        GetOperation operation = new GetOperation(this.name, key);
        try {
            OperationService operationService = nodeEngine.getOperationService();
            InvocationBuilder invocationBuilder = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false);
            long startTime = System.currentTimeMillis();
            InternalCompletableFuture<Data> future = invocationBuilder.invoke();
            future.andThen(new ExecutionCallback<Data>(){

                @Override
                public void onResponse(Data response) {
                    if (nearCacheEnabled) {
                        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
                        if (!nodeEngine.getPartitionService().getPartitionOwner(partitionId).equals(nodeEngine.getClusterService().getThisAddress()) || MapProxySupport.this.getMapConfig().getNearCacheConfig().isCacheLocalEntries()) {
                            mapService.getMapServiceContext().getNearCacheProvider().putNearCache(MapProxySupport.this.name, key, response);
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
            if (this.getMapConfig().isStatisticsEnabled()) {
                future.andThen(new IncrementStatsExecutionCallback(operation, startTime));
            }
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Data putInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutOperation operation = new PutOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        Data previousValue = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return previousValue;
    }

    protected boolean tryPutInternal(Data key, Data value, long timeout, TimeUnit timeunit) {
        TryPutOperation operation = new TryPutOperation(this.name, key, value, this.getTimeInMillis(timeout, timeunit));
        boolean putSuccessful = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return putSuccessful;
    }

    protected Data putIfAbsentInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutIfAbsentOperation operation = new PutIfAbsentOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        Data previousValue = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return previousValue;
    }

    protected void putTransientInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutTransientOperation operation = new PutTransientOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
    }

    private Object invokeOperation(Data key, KeyBasedMapOperation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            Object o;
            OperationService operationService = nodeEngine.getOperationService();
            if (this.getMapConfig().isStatisticsEnabled()) {
                long time = System.currentTimeMillis();
                InternalCompletableFuture f = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false).invoke();
                o = f.get();
                this.incrementStats(operation, System.currentTimeMillis() - time);
            } else {
                InternalCompletableFuture f = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false).invoke();
                o = f.get();
            }
            return o;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void incrementStats(KeyBasedMapOperation operation, long duration) {
        if (operation instanceof BasePutOperation) {
            this.localMapStats.incrementPuts(duration);
        } else if (operation instanceof BaseRemoveOperation) {
            this.localMapStats.incrementRemoves(duration);
        } else if (operation instanceof GetOperation) {
            this.localMapStats.incrementGets(duration);
        }
    }

    protected ICompletableFuture<Data> putAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        PutOperation operation = new PutOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            long startTime = System.currentTimeMillis();
            InternalCompletableFuture<Data> future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            if (this.getMapConfig().isStatisticsEnabled()) {
                future.andThen(new IncrementStatsExecutionCallback(operation, startTime));
            }
            this.invalidateNearCache(key);
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean replaceInternal(Data key, Data expect, Data update) {
        ReplaceIfSameOperation operation = new ReplaceIfSameOperation(this.name, key, expect, update);
        boolean replaceSuccessful = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return replaceSuccessful;
    }

    protected Data replaceInternal(Data key, Data value) {
        ReplaceOperation operation = new ReplaceOperation(this.name, key, value);
        Data result = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return result;
    }

    protected void setInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        SetOperation operation = new SetOperation(this.name, key, value, timeunit.toMillis(ttl));
        this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
    }

    protected boolean evictInternal(Data key) {
        EvictOperation operation = new EvictOperation(this.name, key, false);
        boolean evictSuccess = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return evictSuccess;
    }

    protected void evictAllInternal() {
        try {
            this.clearNearCache();
            EvictAllOperation operation = new EvictAllOperation(this.name);
            NodeEngine nodeEngine = this.getNodeEngine();
            Map<Integer, Object> resultMap = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(operation, nodeEngine));
            int numberOfAffectedEntries = 0;
            for (Object o : resultMap.values()) {
                numberOfAffectedEntries += ((Integer)o).intValue();
            }
            if (numberOfAffectedEntries > 0) {
                this.publishMapEvent(numberOfAffectedEntries, EntryEventType.EVICT_ALL);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected void loadAllInternal(boolean replaceExistingValues) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        int mapNamePartition = partitionService.getPartitionId(this.name);
        LoadMapOperation operation = new LoadMapOperation(this.name, replaceExistingValues);
        InternalCompletableFuture loadMapFuture = operationService.invokeOnPartition("hz:impl:mapService", operation, mapNamePartition);
        try {
            loadMapFuture.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        this.waitUntilLoaded();
    }

    protected void loadInternal(Iterable keys, boolean replaceExistingValues) {
        Iterable<Data> dataKeys = this.convertToData(keys);
        NodeEngine nodeEngine = this.getNodeEngine();
        Map<Integer, List<Data>> partitionIdToKeys = this.getPartitionIdToKeysMap(dataKeys);
        Set<Map.Entry<Integer, List<Data>>> entries = partitionIdToKeys.entrySet();
        for (Map.Entry entry : entries) {
            Integer partitionId = (Integer)entry.getKey();
            List correspondingKeys = (List)entry.getValue();
            Operation operation = this.createLoadAllOperation(correspondingKeys, replaceExistingValues);
            nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        }
        this.waitUntilLoaded();
    }

    private <K> Iterable<Data> convertToData(Iterable<K> keys) {
        return IterableUtil.map(IterableUtil.nullToEmpty(keys), new IFunction<K, Data>(){

            @Override
            public Data apply(K key) {
                return MapProxySupport.this.toData(key);
            }
        });
    }

    private Operation createLoadAllOperation(List<Data> keys, boolean replaceExistingValues) {
        return new LoadAllOperation(this.name, keys, replaceExistingValues);
    }

    protected Data removeInternal(Data key) {
        RemoveOperation operation = new RemoveOperation(this.name, key);
        Data previousValue = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return previousValue;
    }

    protected void deleteInternal(Data key) {
        DeleteOperation operation = new DeleteOperation(this.name, key);
        this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
    }

    protected boolean removeInternal(Data key, Data value) {
        RemoveIfSameOperation operation = new RemoveIfSameOperation(this.name, key, value);
        boolean removed = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return removed;
    }

    protected boolean tryRemoveInternal(Data key, long timeout, TimeUnit timeunit) {
        TryRemoveOperation operation = new TryRemoveOperation(this.name, key, this.getTimeInMillis(timeout, timeunit));
        boolean removed = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return removed;
    }

    protected ICompletableFuture<Data> removeAsyncInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        RemoveOperation operation = new RemoveOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            long startTime = System.currentTimeMillis();
            InternalCompletableFuture<Data> future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            if (this.getMapConfig().isStatisticsEnabled()) {
                future.andThen(new IncrementStatsExecutionCallback(operation, startTime));
            }
            this.invalidateNearCache(key);
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean containsKeyInternal(Data key) {
        if (this.isKeyInNearCache(key)) {
            return true;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        ContainsKeyOperation containsKeyOperation = new ContainsKeyOperation(this.name, key);
        containsKeyOperation.setThreadId(ThreadUtil.getThreadId());
        containsKeyOperation.setServiceName("hz:impl:mapService");
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", containsKeyOperation, partitionId);
            return (Boolean)((MapService)this.getService()).getMapServiceContext().toObject(f.get());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void waitUntilLoaded() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            OperationService operationService = nodeEngine.getOperationService();
            int mapNamePartition = this.partitionService.getPartitionId(this.name);
            PartitionCheckIfLoadedOperation op = new PartitionCheckIfLoadedOperation(this.name, false, true);
            InternalCompletableFuture loadingFuture = operationService.invokeOnPartition("hz:impl:mapService", op, mapNamePartition);
            FutureUtil.waitWithDeadline(Collections.singleton(loadingFuture), 60L, TimeUnit.SECONDS, FutureUtil.logAllExceptions(Level.WARNING));
            PartitionCheckIfLoadedOperationFactory opFactory = new PartitionCheckIfLoadedOperationFactory(this.name);
            Map<Integer, Object> results = operationService.invokeOnAllPartitions("hz:impl:mapService", opFactory);
            this.waitAllTrue(results);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void waitAllTrue(Map<Integer, Object> results) throws InterruptedException {
        Iterator<Map.Entry<Integer, Object>> iterator = results.entrySet().iterator();
        boolean isFinished = false;
        HashSet<Integer> retrySet = new HashSet<Integer>();
        while (!isFinished) {
            while (iterator.hasNext()) {
                Map.Entry<Integer, Object> entry = iterator.next();
                if (Boolean.TRUE.equals(entry.getValue())) {
                    iterator.remove();
                    continue;
                }
                retrySet.add(entry.getKey());
            }
            if (retrySet.size() > 0) {
                results = this.retryPartitions(retrySet);
                iterator = results.entrySet().iterator();
                int oneSecond = 1000;
                Thread.sleep(1000L);
                retrySet.clear();
                continue;
            }
            isFinished = true;
        }
    }

    private Map<Integer, Object> retryPartitions(Collection partitions) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnPartitions("hz:impl:mapService", new PartitionCheckIfLoadedOperationFactory(this.name), partitions);
            return results;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public int size() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new SizeOperationFactory(this.name));
            int total = 0;
            for (Object result : results.values()) {
                Integer size = (Integer)((MapService)this.getService()).getMapServiceContext().toObject(result);
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean containsValueInternal(Data dataValue) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new ContainsValueOperationFactory(this.name, dataValue));
            for (Object result : results.values()) {
                Boolean contains = (Boolean)((MapService)this.getService()).getMapServiceContext().toObject(result);
                if (!contains.booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean isEmpty() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new IsEmptyOperationFactory(this.name));
            for (Object result : results.values()) {
                if (((Boolean)((MapService)this.getService()).getMapServiceContext().toObject(result)).booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Map<Object, Object> getAllObjectInternal(Set<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        boolean nearCacheEnabled = this.getMapConfig().isNearCacheEnabled();
        if (nearCacheEnabled) {
            this.getFromNearCache(result, keys);
        }
        if (keys.isEmpty()) {
            return result;
        }
        Collection<Integer> partitions = this.getPartitionsForKeys(keys);
        try {
            Map<Integer, Object> responses = nodeEngine.getOperationService().invokeOnPartitions("hz:impl:mapService", new MapGetAllOperationFactory(this.name, keys), partitions);
            for (Object response : responses.values()) {
                Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)mapService.getMapServiceContext().toObject(response)).getEntrySet();
                for (Map.Entry<Data, Data> entry : entries) {
                    result.put(mapService.getMapServiceContext().toObject(entry.getKey()), mapService.getMapServiceContext().toObject(entry.getValue()));
                    if (!nearCacheEnabled || !this.notOwnerPartitionForKey(entry.getKey()) && !this.cacheKeyAnyway()) continue;
                    this.putNearCache(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return result;
    }

    private Collection<Integer> getPartitionsForKeys(Set<Data> keys) {
        int partitions = this.partitionService.getPartitionCount();
        int capacity = Math.min(partitions, keys.size());
        HashSet<Integer> partitionIds = new HashSet<Integer>(capacity);
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext() && partitionIds.size() < partitions) {
            Data key = iterator.next();
            partitionIds.add(this.partitionService.getPartitionId(key));
        }
        return partitionIds;
    }

    private Map<Integer, List<Data>> getPartitionIdToKeysMap(Iterable<Data> keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        HashMap<Integer, List<Data>> idToKeys = new HashMap<Integer, List<Data>>();
        for (Data key : keys) {
            int partitionId = partitionService.getPartitionId(key);
            ArrayList<Data> keyList = (ArrayList<Data>)idToKeys.get(partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                idToKeys.put(partitionId, keyList);
            }
            keyList.add(key);
        }
        return idToKeys;
    }

    protected void putAllInternal(Map<? extends Object, ? extends Object> entries) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        int factor = 3;
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        OperationService operationService = nodeEngine.getOperationService();
        int partitionCount = partitionService.getPartitionCount();
        boolean tooManyEntries = entries.size() > partitionCount * factor;
        try {
            if (tooManyEntries) {
                LinkedList futures = new LinkedList();
                HashMap<Integer, MapEntrySet> entryMap = new HashMap<Integer, MapEntrySet>(nodeEngine.getPartitionService().getPartitionCount());
                for (Map.Entry<? extends Object, ? extends Object> entry : entries.entrySet()) {
                    Preconditions.checkNotNull(entry.getKey(), NULL_KEY_IS_NOT_ALLOWED);
                    Preconditions.checkNotNull(entry.getValue(), NULL_VALUE_IS_NOT_ALLOWED);
                    int partitionId = partitionService.getPartitionId(entry.getKey());
                    if (!entryMap.containsKey(partitionId)) {
                        entryMap.put(partitionId, new MapEntrySet());
                    }
                    ((MapEntrySet)entryMap.get(partitionId)).add(new AbstractMap.SimpleImmutableEntry<Data, Data>(mapService.getMapServiceContext().toData(entry.getKey(), this.partitionStrategy), mapService.getMapServiceContext().toData(entry.getValue())));
                }
                for (Map.Entry<Object, Object> entry : entryMap.entrySet()) {
                    Integer partitionId = (Integer)entry.getKey();
                    PutAllOperation op = new PutAllOperation(this.name, (MapEntrySet)entry.getValue());
                    op.setPartitionId(partitionId);
                    futures.add(operationService.invokeOnPartition("hz:impl:mapService", op, partitionId));
                }
                for (Future future : futures) {
                    future.get();
                }
            } else {
                for (Map.Entry<? extends Object, ? extends Object> entry : entries.entrySet()) {
                    Preconditions.checkNotNull(entry.getKey(), NULL_KEY_IS_NOT_ALLOWED);
                    Preconditions.checkNotNull(entry.getValue(), NULL_VALUE_IS_NOT_ALLOWED);
                    this.putInternal(mapService.getMapServiceContext().toData(entry.getKey(), this.partitionStrategy), mapService.getMapServiceContext().toData(entry.getValue()), -1L, TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void flush() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapFlushOperation(this.name), nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void clearInternal() {
        String mapName = this.name;
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            ClearOperation clearOperation = new ClearOperation(mapName);
            clearOperation.setServiceName("hz:impl:mapService");
            Map<Integer, Object> resultMap = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(clearOperation, nodeEngine));
            int numberOfAffectedEntries = 0;
            for (Object o : resultMap.values()) {
                numberOfAffectedEntries += ((Integer)o).intValue();
            }
            if (numberOfAffectedEntries > 0) {
                this.publishMapEvent(numberOfAffectedEntries, EntryEventType.CLEAR_ALL);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public String addMapInterceptorInternal(MapInterceptor interceptor) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        if (interceptor instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)interceptor)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
        }
        String id = mapServiceContext.generateInterceptorId(this.name, interceptor);
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnTarget("hz:impl:mapService", new AddInterceptorOperation(id, interceptor, this.name), member.getAddress());
                f.get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return id;
    }

    public void removeMapInterceptorInternal(String id) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        mapService.getMapServiceContext().removeInterceptor(this.name, id);
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        for (Member member : members) {
            try {
                if (member.localMember()) continue;
                MemberImpl memberImpl = (MemberImpl)member;
                InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnTarget("hz:impl:mapService", new RemoveInterceptorOperation(this.name, id), memberImpl.getAddress());
                f.get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    public String addLocalEntryListenerInternal(Object listener) {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext().addLocalEventListener(listener, this.name);
    }

    public String addLocalEntryListenerInternal(Object listener, Predicate predicate, Data key, boolean includeValue) {
        MapService mapService = (MapService)this.getService();
        QueryEventFilter eventFilter = new QueryEventFilter(includeValue, key, predicate);
        return mapService.getMapServiceContext().addLocalEventListener(listener, eventFilter, this.name);
    }

    protected String addEntryListenerInternal(Object listener, Data key, boolean includeValue) {
        EntryEventFilter eventFilter = new EntryEventFilter(includeValue, key);
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext().addEventListener(listener, eventFilter, this.name);
    }

    protected String addEntryListenerInternal(Object listener, Predicate predicate, Data key, boolean includeValue) {
        QueryEventFilter eventFilter = new QueryEventFilter(includeValue, key, predicate);
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext().addEventListener(listener, eventFilter, this.name);
    }

    protected boolean removeEntryListenerInternal(String id) {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext().removeEventListener(this.name, id);
    }

    protected String addPartitionLostListenerInternal(MapPartitionLostListener listener) {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext().addPartitionLostListener(listener, this.name);
    }

    protected boolean removePartitionLostListenerInternal(String id) {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext().removePartitionLostListener(this.name, id);
    }

    protected EntryView getEntryViewInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        GetEntryViewOperation operation = new GetEntryViewOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        operation.setServiceName("hz:impl:mapService");
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            Object o = ((MapService)this.getService()).getMapServiceContext().toObject(f.get());
            return (EntryView)o;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Data executeOnKeyInternal(Data key, EntryProcessor entryProcessor) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        EntryOperation operation = new EntryOperation(this.name, key, entryProcessor);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            InternalCompletableFuture future = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false).invoke();
            Data data = (Data)future.get();
            this.invalidateNearCache(key);
            return data;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Map executeOnKeysInternal(Set<Data> keys, EntryProcessor entryProcessor) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        NodeEngine nodeEngine = this.getNodeEngine();
        Collection<Integer> partitionsForKeys = this.getPartitionsForKeys(keys);
        try {
            MultipleEntryOperationFactory operationFactory = new MultipleEntryOperationFactory(this.name, keys, entryProcessor);
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnPartitions("hz:impl:mapService", operationFactory, partitionsForKeys);
            for (Object o : results.values()) {
                if (o == null) continue;
                MapService service = (MapService)this.getService();
                MapEntrySet mapEntrySet = (MapEntrySet)o;
                for (Map.Entry<Data, Data> entry : mapEntrySet.getEntrySet()) {
                    result.put(service.getMapServiceContext().toObject(entry.getKey()), service.getMapServiceContext().toObject(entry.getValue()));
                }
            }
            this.invalidateNearCache(keys);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    public ICompletableFuture executeOnKeyInternal(Data key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        EntryOperation operation = new EntryOperation(this.name, key, entryProcessor);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            if (callback == null) {
                return nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            }
            InternalCompletableFuture future = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setCallback(new MapExecutionCallbackAdapter(callback)).invoke();
            this.invalidateNearCache(key);
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Map executeOnEntries(EntryProcessor entryProcessor) {
        return this.executeOnEntries(entryProcessor, TruePredicate.INSTANCE);
    }

    public Map executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new PartitionWideEntryWithPredicateOperationFactory(this.name, entryProcessor, predicate));
            for (Object o : results.values()) {
                if (o == null) continue;
                MapService service = (MapService)this.getService();
                MapEntrySet mapEntrySet = (MapEntrySet)o;
                for (Map.Entry<Data, Data> entry : mapEntrySet.getEntrySet()) {
                    Data key = entry.getKey();
                    result.put(service.getMapServiceContext().toObject(key), service.getMapServiceContext().toObject(entry.getValue()));
                    this.invalidateNearCache(key);
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected Object toObject(Object obj) {
        return ((MapService)this.getService()).getMapServiceContext().toObject(obj);
    }

    protected Data toData(Object obj) {
        return ((MapService)this.getService()).getMapServiceContext().toData(obj);
    }

    protected Data toData(Object o, PartitioningStrategy partitioningStrategy) {
        return ((MapService)this.getService()).getMapServiceContext().toData(o, partitioningStrategy);
    }

    protected Set queryLocal(Predicate predicate, IterationType iterationType, boolean dataResult) {
        if (predicate instanceof PagingPredicate) {
            return this.getMapQuerySupport().queryLocalMemberWithPagingPredicate(this.name, (PagingPredicate)predicate, iterationType);
        }
        return this.getMapQuerySupport().queryLocalMember(this.name, predicate, iterationType, dataResult);
    }

    protected Set query(Predicate predicate, IterationType iterationType, boolean dataResult) {
        if (predicate instanceof PagingPredicate) {
            return this.getMapQuerySupport().queryWithPagingPredicate(this.name, (PagingPredicate)predicate, iterationType);
        }
        return this.getMapQuerySupport().query(this.name, predicate, iterationType, dataResult);
    }

    public void addIndex(String attribute, boolean ordered) {
        NodeEngine nodeEngine = this.getNodeEngine();
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        try {
            AddIndexOperation addIndexOperation = new AddIndexOperation(this.name, attribute, ordered);
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(addIndexOperation, nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public LocalMapStats getLocalMapStats() {
        return ((MapService)this.getService()).getMapServiceContext().getLocalMapStatsProvider().createLocalMapStats(this.name);
    }

    private boolean isKeyInNearCache(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = this.getMapConfig().isNearCacheEnabled();
        return nearCacheEnabled && (cached = mapService.getMapServiceContext().getNearCacheProvider().getFromNearCache(this.name, key)) != null && !cached.equals(NearCache.NULL_OBJECT);
    }

    private void invalidateNearCache(Data key) {
        if (key == null) {
            return;
        }
        ((MapService)this.getService()).getMapServiceContext().getNearCacheProvider().invalidateNearCache(this.name, key);
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        ((MapService)this.getService()).getMapServiceContext().getNearCacheProvider().invalidateNearCache(this.name, keys);
    }

    private void clearNearCache() {
        ((MapService)this.getService()).getMapServiceContext().getNearCacheProvider().clearNearCache(this.name);
    }

    private void publishMapEvent(int numberOfAffectedEntries, EntryEventType eventType) {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishMapEvent(this.getNodeEngine().getThisAddress(), this.name, eventType, numberOfAffectedEntries);
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        long timeInMillis = timeunit.toMillis(time);
        if (time > 0L && timeInMillis == 0L) {
            timeInMillis = 1L;
        }
        return timeInMillis;
    }

    private MapContextQuerySupport getMapQuerySupport() {
        return ((MapService)this.getService()).getMapServiceContext().getMapContextQuerySupport();
    }

    protected MapStore getMapStore() {
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        MapContainer mapContainer = mapServiceContext.getMapContainer(this.name);
        return mapContainer.getMapStoreContext().getMapStoreWrapper();
    }

    private MapConfig getMapConfig() {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapContainer mapContainer = mapServiceContext.getMapContainer(this.name);
        return mapContainer.getMapConfig();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    public PartitioningStrategy getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public class IncrementStatsExecutionCallback<T>
    implements ExecutionCallback<T> {
        private final KeyBasedMapOperation operation;
        private final long startTime;

        public IncrementStatsExecutionCallback(KeyBasedMapOperation operation, long startTime) {
            this.operation = operation;
            this.startTime = startTime;
        }

        @Override
        public void onResponse(T response) {
            long duration = System.currentTimeMillis() - this.startTime;
            MapProxySupport.this.incrementStats(this.operation, duration);
        }

        @Override
        public void onFailure(Throwable t) {
        }
    }

    private class MapExecutionCallbackAdapter
    implements Callback {
        private final ExecutionCallback executionCallback;

        public MapExecutionCallbackAdapter(ExecutionCallback executionCallback) {
            this.executionCallback = executionCallback;
        }

        public void notify(Object response) {
            if (response instanceof Throwable) {
                this.executionCallback.onFailure((Throwable)response);
            } else {
                this.executionCallback.onResponse(((MapService)MapProxySupport.this.getService()).getMapServiceContext().toObject(response));
            }
        }
    }
}

