/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableEntryEvent;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.io.IOException;
import java.security.Permission;

public class ClientReplicatedMapAddEntryListenerRequest
extends AbstractReplicatedMapClientRequest {
    private Predicate predicate;
    private Object key;

    ClientReplicatedMapAddEntryListenerRequest() {
        super(null);
    }

    public ClientReplicatedMapAddEntryListenerRequest(String mapName, Predicate predicate, Object key) {
        super(mapName);
        this.predicate = predicate;
        this.key = key;
    }

    public Object call() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        ReplicatedRecordStore replicatedRecordStore = this.getReplicatedRecordStore();
        ClientReplicatedMapEntryListener listener = new ClientReplicatedMapEntryListener();
        String registrationId = this.predicate == null ? replicatedRecordStore.addEntryListener(listener, this.key) : replicatedRecordStore.addEntryListener(listener, this.predicate, this.key);
        endpoint.addListenerDestroyAction("hz:impl:replicatedMapService", this.getMapName(), registrationId);
        return registrationId;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.key);
        out.writeObject(this.predicate);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readObject();
        this.predicate = (Predicate)in.readObject();
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "listen");
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    @Override
    public Object[] getParameters() {
        if (this.key == null && this.predicate == null) {
            return new Object[]{null};
        }
        if (this.key == null && this.predicate != null) {
            return new Object[]{null, this.predicate};
        }
        if (this.key != null && this.predicate == null) {
            return new Object[]{null, this.key};
        }
        return new Object[]{null, this.predicate, this.key};
    }

    private class ClientReplicatedMapEntryListener
    implements EntryListener<Object, Object> {
        private ClientReplicatedMapEntryListener() {
        }

        private void handleEvent(EntryEvent<Object, Object> event) {
            if (ClientReplicatedMapAddEntryListenerRequest.this.endpoint.isAlive()) {
                Object key = event.getKey();
                Object value = event.getValue();
                Object oldValue = event.getOldValue();
                EntryEventType eventType = event.getEventType();
                String uuid = event.getMember().getUuid();
                ReplicatedMapPortableEntryEvent portableEntryEvent = new ReplicatedMapPortableEntryEvent(key, value, oldValue, eventType, uuid);
                Object partitionKey = ClientReplicatedMapAddEntryListenerRequest.this.serializationService.toData(key);
                ClientReplicatedMapAddEntryListenerRequest.this.endpoint.sendEvent(partitionKey, portableEntryEvent, ClientReplicatedMapAddEntryListenerRequest.this.getCallId());
            }
        }

        @Override
        public void entryAdded(EntryEvent<Object, Object> event) {
            this.handleEvent(event);
        }

        @Override
        public void entryRemoved(EntryEvent<Object, Object> event) {
            this.handleEvent(event);
        }

        @Override
        public void entryUpdated(EntryEvent<Object, Object> event) {
            this.handleEvent(event);
        }

        @Override
        public void entryEvicted(EntryEvent<Object, Object> event) {
            this.handleEvent(event);
        }

        @Override
        public void mapEvicted(MapEvent event) {
        }

        @Override
        public void mapCleared(MapEvent event) {
        }
    }
}

