/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.client.CacheGetAllRequest;
import com.hazelcast.cache.impl.client.CacheGetRequest;
import com.hazelcast.cache.impl.client.CacheSizeRequest;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.cache.impl.AbstractClientInternalCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientCacheProxy<K, V>
extends AbstractClientInternalCacheProxy<K, V>
implements ICacheInternal<K, V> {
    protected AbstractClientCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext, cacheManager);
    }

    protected Object getInternal(K key, ExpiryPolicy expiryPolicy, boolean async) {
        ClientInvocationFuture future;
        Object cached;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        final Data keyData = this.toData(key);
        Object v0 = cached = this.nearCache != null ? this.nearCache.get(keyData) : null;
        if (cached != null && !NearCache.NULL_OBJECT.equals(cached)) {
            return this.createCompletedFuture(cached);
        }
        CacheGetRequest request = new CacheGetRequest(this.nameWithPrefix, keyData, expiryPolicy, this.cacheConfig.getInMemoryFormat());
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(key);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, (ClientRequest)request, partitionId);
            future = clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        if (async) {
            if (this.nearCache != null) {
                future.andThenInternal(new ExecutionCallback<Data>(){

                    @Override
                    public void onResponse(Data valueData) {
                        AbstractClientCacheProxy.this.storeInNearCache(keyData, valueData, null);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                    }
                });
            }
            return new DelegatingFuture(future, this.clientContext.getSerializationService());
        }
        try {
            Object value = future.get();
            if (this.nearCache != null) {
                this.storeInNearCache(keyData, this.toData(value), null);
            }
            return this.toObject(value);
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public ICompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, null);
    }

    @Override
    public ICompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.getInternal(key, expiryPolicy, true);
    }

    @Override
    public ICompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync(key, value, null);
    }

    @Override
    public ICompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, false, true);
    }

    @Override
    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsyncInternal(key, value, null, false);
    }

    @Override
    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putIfAbsentAsyncInternal(key, value, expiryPolicy, false);
    }

    @Override
    public ICompletableFuture<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync(key, value, null);
    }

    @Override
    public ICompletableFuture<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, true, false);
    }

    @Override
    public ICompletableFuture<Boolean> removeAsync(K key) {
        return this.removeAsyncInternal(key, null, false, false, false);
    }

    @Override
    public ICompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return this.removeAsyncInternal(key, oldValue, true, false, false);
    }

    @Override
    public ICompletableFuture<V> getAndRemoveAsync(K key) {
        return this.removeAsyncInternal(key, null, false, true, false);
    }

    @Override
    public ICompletableFuture<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, false, false);
    }

    @Override
    public ICompletableFuture<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, false);
    }

    @Override
    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsyncInternal(key, oldValue, newValue, null, true, false, false);
    }

    @Override
    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, false);
    }

    @Override
    public ICompletableFuture<V> getAndReplaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, true, false);
    }

    @Override
    public ICompletableFuture<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, false);
    }

    @Override
    public V get(K key, ExpiryPolicy expiryPolicy) {
        return (V)this.getInternal(key, expiryPolicy, false);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (keys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        for (K key : keys) {
            Data k = this.toData(key);
            keySet.add(k);
        }
        Map result = this.getAllFromNearCache(keySet);
        if (keySet.isEmpty()) {
            return result;
        }
        CacheGetAllRequest request = new CacheGetAllRequest(this.nameWithPrefix, keySet, expiryPolicy);
        MapEntrySet mapEntrySet = (MapEntrySet)this.toObject(this.invoke(request));
        Set<Map.Entry<Data, Data>> entrySet = mapEntrySet.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entrySet) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            result.put(key, value);
            this.storeInNearCache(keyData, valueData, value);
        }
        return result;
    }

    private Map<K, V> getAllFromNearCache(Set<Data> keySet) {
        HashMap result = new HashMap();
        if (this.nearCache != null) {
            Iterator<Data> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cached = this.nearCache.get(key);
                if (cached == null || NearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        ICompletableFuture f = this.putAsyncInternal(key, value, expiryPolicy, false, true);
        try {
            f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        ICompletableFuture f = this.putAsyncInternal(key, value, expiryPolicy, true, true);
        try {
            return (V)this.toObject(f.get());
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), expiryPolicy);
        }
    }

    @Override
    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        ICompletableFuture<Boolean> f = this.putIfAbsentAsyncInternal(key, value, expiryPolicy, true);
        try {
            return (Boolean)this.toObject(f.get());
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        ICompletableFuture f = this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, true);
        try {
            return (Boolean)this.toObject(f.get());
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        ICompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, true);
        try {
            return (Boolean)this.toObject(f.get());
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        ICompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, true);
        try {
            return (V)this.toObject(f.get());
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public int size() {
        this.ensureOpen();
        try {
            CacheSizeRequest request = new CacheSizeRequest(this.nameWithPrefix);
            Integer result = (Integer)this.invoke(request);
            if (result == null) {
                return 0;
            }
            return result;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    @Override
    public CacheStatistics getLocalCacheStatistics() {
        throw new UnsupportedOperationException("local cache Statistics are not implemented yet");
    }
}

