/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapAddEntryListenerRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapClearRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapContainsKeyRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapContainsValueRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapEntrySetRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapGetRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapIsEmptyRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapKeySetRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapPutAllRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapPutTtlRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapRemoveEntryListenerRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapRemoveRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapSizeRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapValuesRequest;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapEntrySet;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapGetResponse;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapKeySet;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableEntryEvent;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapValueCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    private volatile ClientHeapNearCache<Object> nearCache;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();

    public ClientReplicatedMapProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.nearCache.destroy();
        }
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        return (V)this.invoke(new ClientReplicatedMapPutTtlRequest(this.getName(), key, value, timeUnit.toMillis(ttl)));
    }

    @Override
    public int size() {
        return (Integer)this.invoke(new ClientReplicatedMapSizeRequest(this.getName()));
    }

    @Override
    public boolean isEmpty() {
        return (Boolean)this.invoke(new ClientReplicatedMapIsEmptyRequest(this.getName()));
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)this.invoke(new ClientReplicatedMapContainsKeyRequest(this.getName(), key));
    }

    @Override
    public boolean containsValue(Object value) {
        return (Boolean)this.invoke(new ClientReplicatedMapContainsValueRequest(this.getName(), value));
    }

    @Override
    public V get(Object key) {
        Object cached;
        this.initNearCache();
        if (this.nearCache != null && (cached = this.nearCache.get(key)) != null) {
            if (cached.equals(ClientNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        ReplicatedMapGetResponse response = (ReplicatedMapGetResponse)this.invoke(new ClientReplicatedMapGetRequest(this.getName(), key));
        Object value = response.getValue();
        if (this.nearCache != null) {
            this.nearCache.put(key, value);
        }
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V remove(Object key) {
        return (V)this.invoke(new ClientReplicatedMapRemoveRequest(this.getName(), key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.invoke(new ClientReplicatedMapPutAllRequest(this.getName(), new ReplicatedMapEntrySet(m.entrySet())));
    }

    @Override
    public void clear() {
        ClientReplicatedMapClearRequest request = new ClientReplicatedMapClearRequest(this.getName());
        this.invoke(request);
    }

    @Override
    public boolean removeEntryListener(String id) {
        ClientReplicatedMapRemoveEntryListenerRequest request = new ClientReplicatedMapRemoveEntryListenerRequest(this.getName(), id);
        return this.stopListening(request, id);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener) {
        ClientReplicatedMapAddEntryListenerRequest request = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), null, null);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        return this.listen(request, null, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key) {
        ClientReplicatedMapAddEntryListenerRequest request = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), null, key);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        return this.listen(request, null, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        ClientReplicatedMapAddEntryListenerRequest request = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), predicate, null);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        return this.listen(request, null, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        ClientReplicatedMapAddEntryListenerRequest request = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), predicate, key);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        return this.listen(request, null, handler);
    }

    @Override
    public Set<K> keySet() {
        return ((ReplicatedMapKeySet)this.invoke(new ClientReplicatedMapKeySetRequest(this.getName()))).getKeySet();
    }

    @Override
    public Collection<V> values() {
        return ((ReplicatedMapValueCollection)this.invoke(new ClientReplicatedMapValuesRequest(this.getName()))).getValues();
    }

    @Override
    public Collection<V> values(Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((ReplicatedMapEntrySet)this.invoke(new ClientReplicatedMapEntrySetRequest(this.getName()))).getEntrySet();
    }

    private EventHandler<ReplicatedMapPortableEntryEvent> createHandler(EntryListener<K, V> listener) {
        return new ReplicatedMapEventHandler(listener);
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.getName());
            if (nearCacheConfig == null) {
                return;
            }
            ClientHeapNearCache nearCache = new ClientHeapNearCache(this.getName(), this.getContext(), nearCacheConfig);
            this.nearCache = nearCache;
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.getName() + '\'' + '}';
    }

    private class ReplicatedMapEventHandler
    implements EventHandler<ReplicatedMapPortableEntryEvent> {
        private final EntryListener<K, V> listener;

        public ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        @Override
        public void handle(ReplicatedMapPortableEntryEvent event) {
            Object value = event.getValue();
            Object oldValue = event.getOldValue();
            Object key = event.getKey();
            Member member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
            EntryEvent<Object, Object> entryEvent = new EntryEvent<Object, Object>(ClientReplicatedMapProxy.this.getName(), member, event.getEventType().getType(), key, oldValue, value);
            switch (event.getEventType()) {
                case ADDED: {
                    this.listener.entryAdded(entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved(entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated(entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted(entryEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)event.getEventType()));
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

