/*
 * Copyright (c) 2008-2015, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.topic.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Clock;

import java.io.IOException;

public class TopicEvent implements IdentifiedDataSerializable {

    public String name;
    public long publishTime;
    public Address publisherAddress;
    public Data data;

    public TopicEvent() {
    }

    public TopicEvent(String name, Data data, Address publisherAddress) {
        this.name = name;
        this.publishTime = Clock.currentTimeMillis();
        this.publisherAddress = publisherAddress;
        this.data = data;
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return TopicDataSerializerHook.TOPIC_EVENT;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(name);
        out.writeLong(publishTime);
        out.writeObject(publisherAddress);
        out.writeData(data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        name = in.readUTF();
        publishTime = in.readLong();
        publisherAddress = in.readObject();
        data = in.readData();
    }

    @Override
    public String toString() {
        return "TopicEvent{"
                + "name='" + name + '\''
                + ", publishTime=" + publishTime
                + ", publisherAddress=" + publisherAddress
                + '}';
    }
}
