/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.MessageTaskFactoryImpl;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceConstructor;
import com.hazelcast.memory.DefaultMemoryStats;
import com.hazelcast.memory.MemoryStats;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.tcp.DefaultSocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.MemberReadHandler;
import com.hazelcast.nio.tcp.MemberWriteHandler;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.wan.WanReplicationService;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import java.util.Collections;
import java.util.Map;

public class DefaultNodeExtension
implements NodeExtension {
    protected final Node node;
    protected final ILogger logger;
    protected final ILogger systemLogger;
    private final MemoryStats memoryStats = new DefaultMemoryStats();

    public DefaultNodeExtension(Node node) {
        this.node = node;
        this.logger = node.getLogger(NodeExtension.class);
        this.systemLogger = node.getLogger("com.hazelcast.system");
    }

    @Override
    public void beforeStart() {
    }

    @Override
    public void printNodeInfo() {
        BuildInfo buildInfo = this.node.getBuildInfo();
        String build = buildInfo.getBuild();
        String revision = buildInfo.getRevision();
        if (!revision.isEmpty()) {
            build = build + " - " + revision;
        }
        this.systemLogger.info("Hazelcast " + buildInfo.getVersion() + " (" + build + ") starting at " + this.node.getThisAddress());
        this.systemLogger.info("Copyright (c) 2008-2015, Hazelcast, Inc. All Rights Reserved.");
        this.systemLogger.info("Configured Hazelcast Serialization version:" + buildInfo.getSerializationVersion());
    }

    @Override
    public void beforeJoin() {
    }

    @Override
    public void afterStart() {
    }

    @Override
    public boolean isStartCompleted() {
        return this.node.joined();
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SerializationService createSerializationService() {
        SerializationService ss;
        try {
            Config config = this.node.getConfig();
            ClassLoader configClassLoader = this.node.getConfigClassLoader();
            HazelcastInstanceImpl hazelcastInstance = this.node.hazelcastInstance;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            byte version = (byte)this.node.groupProperties.getInteger(GroupProperty.SERIALIZATION_VERSION);
            ss = builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(hazelcastInstance.managedContext).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).setVersion(version).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = this.node.groupProperties.getString(GroupProperty.PARTITIONING_STRATEGY_CLASS);
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public <T> T createService(Class<T> clazz) {
        if (WanReplicationService.class.isAssignableFrom(clazz)) {
            return (T)new WanReplicationServiceImpl(this.node);
        }
        if (ICacheService.class.isAssignableFrom(clazz)) {
            return (T)new CacheService();
        }
        if (MapService.class.isAssignableFrom(clazz)) {
            return this.createMapService();
        }
        throw new IllegalArgumentException("Unknown service class: " + clazz);
    }

    private <T> T createMapService() {
        ConstructorFunction<NodeEngine, MapService> constructor = MapServiceConstructor.getDefaultMapServiceConstructor();
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        return (T)constructor.createNew(nodeEngine);
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        return Collections.emptyMap();
    }

    @Override
    public MemberSocketInterceptor getMemberSocketInterceptor() {
        this.logger.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SocketChannelWrapperFactory getSocketChannelWrapperFactory() {
        return new DefaultSocketChannelWrapperFactory();
    }

    @Override
    public ReadHandler createReadHandler(TcpIpConnection connection, IOService ioService) {
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        return new MemberReadHandler(connection, nodeEngine.getPacketDispatcher());
    }

    @Override
    public WriteHandler createWriteHandler(TcpIpConnection connection, IOService ioService) {
        return new MemberWriteHandler();
    }

    @Override
    public MessageTaskFactory createMessageTaskFactory() {
        return new MessageTaskFactoryImpl(this.node);
    }

    @Override
    public void onThreadStart(Thread thread) {
    }

    @Override
    public void onThreadStop(Thread thread) {
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    @Override
    public void beforeShutdown() {
    }

    @Override
    public void shutdown() {
        this.logger.info("Destroying node NodeExtension.");
    }

    @Override
    public void validateJoinRequest() {
    }

    @Override
    public void onClusterStateChange(ClusterState newState) {
    }

    @Override
    public boolean registerListener(Object listener) {
        return false;
    }
}

