/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.HazelcastProperty;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.monitors.HealthMonitorLevel;
import com.hazelcast.query.impl.predicates.QueryOptimizerFactory;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;

@PrivateApi
public enum GroupProperty implements HazelcastProperty
{
    APPLICATION_VALIDATION_TOKEN("hazelcast.application.validation.token"),
    PARTITION_COUNT("hazelcast.partition.count", 271),
    PARTITION_OPERATION_THREAD_COUNT("hazelcast.operation.thread.count", -1),
    GENERIC_OPERATION_THREAD_COUNT("hazelcast.operation.generic.thread.count", -1),
    CLIENT_ENGINE_THREAD_COUNT("hazelcast.clientengine.thread.count", -1),
    EVENT_THREAD_COUNT("hazelcast.event.thread.count", 5),
    EVENT_QUEUE_CAPACITY("hazelcast.event.queue.capacity", 1000000),
    EVENT_QUEUE_TIMEOUT_MILLIS("hazelcast.event.queue.timeout.millis", 250, TimeUnit.MILLISECONDS),
    HEALTH_MONITORING_LEVEL("hazelcast.health.monitoring.level", HealthMonitorLevel.SILENT.toString()),
    HEALTH_MONITORING_DELAY_SECONDS("hazelcast.health.monitoring.delay.seconds", 20, TimeUnit.SECONDS),
    PERFORMANCE_MONITOR_ENABLED("hazelcast.performance.monitoring.enabled", false),
    PERFORMANCE_METRICS_LEVEL("hazelcast.performance.metric.level", ProbeLevel.MANDATORY.name()),
    PERFORMANCE_MONITOR_DELAY_SECONDS("hazelcast.performance.monitor.delay.seconds", 30, TimeUnit.SECONDS),
    PERFORMANCE_MONITOR_MAX_ROLLED_FILE_SIZE_MB("hazelcast.performance.monitor.max.rolled.file.size.mb", 10),
    PERFORMANCE_MONITOR_MAX_ROLLED_FILE_COUNT("hazelcast.performance.monitor.max.rolled.file.count", 10),
    PERFORMANCE_MONITOR_HUMAN_FRIENDLY_FORMAT("hazelcast.performance.monitor.human.friendly.format", true),
    IO_THREAD_COUNT("hazelcast.io.thread.count", 3),
    IO_INPUT_THREAD_COUNT("hazelcast.io.input.thread.count", IO_THREAD_COUNT),
    IO_OUTPUT_THREAD_COUNT("hazelcast.io.output.thread.count", IO_THREAD_COUNT),
    IO_BALANCER_INTERVAL_SECONDS("hazelcast.io.balancer.interval.seconds", 20, TimeUnit.SECONDS),
    PREFER_IPv4_STACK("hazelcast.prefer.ipv4.stack", true),
    VERSION_CHECK_ENABLED("hazelcast.version.check.enabled", true),
    PHONE_HOME_ENABLED("hazelcast.phone.home.enabled", true),
    CONNECT_ALL_WAIT_SECONDS("hazelcast.connect.all.wait.seconds", 120, TimeUnit.SECONDS),
    MEMCACHE_ENABLED("hazelcast.memcache.enabled", false),
    REST_ENABLED("hazelcast.rest.enabled", false),
    MAP_LOAD_CHUNK_SIZE("hazelcast.map.load.chunk.size", 1000),
    MERGE_FIRST_RUN_DELAY_SECONDS("hazelcast.merge.first.run.delay.seconds", 300, TimeUnit.SECONDS),
    MERGE_NEXT_RUN_DELAY_SECONDS("hazelcast.merge.next.run.delay.seconds", 120, TimeUnit.SECONDS),
    OPERATION_CALL_TIMEOUT_MILLIS("hazelcast.operation.call.timeout.millis", 60000, TimeUnit.MILLISECONDS),
    OPERATION_BACKUP_TIMEOUT_MILLIS("hazelcast.operation.backup.timeout.millis", 5000, TimeUnit.MILLISECONDS),
    SOCKET_BIND_ANY("hazelcast.socket.bind.any", true),
    SOCKET_SERVER_BIND_ANY("hazelcast.socket.server.bind.any", SOCKET_BIND_ANY),
    SOCKET_CLIENT_BIND_ANY("hazelcast.socket.client.bind.any", SOCKET_BIND_ANY),
    SOCKET_CLIENT_BIND("hazelcast.socket.client.bind", true),
    SOCKET_RECEIVE_BUFFER_SIZE("hazelcast.socket.receive.buffer.size", 32),
    SOCKET_SEND_BUFFER_SIZE("hazelcast.socket.send.buffer.size", 32),
    SOCKET_CLIENT_RECEIVE_BUFFER_SIZE("hazelcast.socket.client.receive.buffer.size", -1),
    SOCKET_CLIENT_SEND_BUFFER_SIZE("hazelcast.socket.client.send.buffer.size", -1),
    SOCKET_LINGER_SECONDS("hazelcast.socket.linger.seconds", 0, TimeUnit.SECONDS),
    SOCKET_CONNECT_TIMEOUT_SECONDS("hazelcast.socket.connect.timeout.seconds", 0, TimeUnit.SECONDS),
    SOCKET_KEEP_ALIVE("hazelcast.socket.keep.alive", true),
    SOCKET_NO_DELAY("hazelcast.socket.no.delay", true),
    SHUTDOWNHOOK_ENABLED("hazelcast.shutdownhook.enabled", true),
    WAIT_SECONDS_BEFORE_JOIN("hazelcast.wait.seconds.before.join", 5, TimeUnit.SECONDS),
    MAX_WAIT_SECONDS_BEFORE_JOIN("hazelcast.max.wait.seconds.before.join", 20, TimeUnit.SECONDS),
    MAX_JOIN_SECONDS("hazelcast.max.join.seconds", 300, TimeUnit.SECONDS),
    MAX_JOIN_MERGE_TARGET_SECONDS("hazelcast.max.join.merge.target.seconds", 20, TimeUnit.SECONDS),
    HEARTBEAT_INTERVAL_SECONDS("hazelcast.heartbeat.interval.seconds", 5, TimeUnit.SECONDS),
    MAX_NO_HEARTBEAT_SECONDS("hazelcast.max.no.heartbeat.seconds", 300, TimeUnit.SECONDS),
    MASTER_CONFIRMATION_INTERVAL_SECONDS("hazelcast.master.confirmation.interval.seconds", 30, TimeUnit.SECONDS),
    MAX_NO_MASTER_CONFIRMATION_SECONDS("hazelcast.max.no.master.confirmation.seconds", 350, TimeUnit.SECONDS),
    MEMBER_LIST_PUBLISH_INTERVAL_SECONDS("hazelcast.member.list.publish.interval.seconds", 300, TimeUnit.SECONDS),
    CLIENT_HEARTBEAT_TIMEOUT_SECONDS("hazelcast.client.max.no.heartbeat.seconds", 300, TimeUnit.SECONDS),
    MIGRATION_MIN_DELAY_ON_MEMBER_REMOVED_SECONDS("hazelcast.migration.min.delay.on.member.removed.seconds", 5, TimeUnit.SECONDS),
    CLUSTER_SHUTDOWN_TIMEOUT_SECONDS("hazelcast.cluster.shutdown.timeout.seconds", 900, TimeUnit.SECONDS),
    ICMP_ENABLED("hazelcast.icmp.enabled", false),
    ICMP_TIMEOUT("hazelcast.icmp.timeout", 1000, TimeUnit.MILLISECONDS),
    ICMP_TTL("hazelcast.icmp.ttl", 0),
    INITIAL_MIN_CLUSTER_SIZE("hazelcast.initial.min.cluster.size", 0),
    INITIAL_WAIT_SECONDS("hazelcast.initial.wait.seconds", 0, TimeUnit.SECONDS),
    TCP_JOIN_PORT_TRY_COUNT("hazelcast.tcp.join.port.try.count", 3),
    MAP_REPLICA_SCHEDULED_TASK_DELAY_SECONDS("hazelcast.map.replica.scheduled.task.delay.seconds", 10, TimeUnit.SECONDS),
    MAP_EXPIRY_DELAY_SECONDS("hazelcast.map.expiry.delay.seconds", 10, TimeUnit.SECONDS),
    LOGGING_TYPE("hazelcast.logging.type", "jdk"),
    ENABLE_JMX("hazelcast.jmx", false),
    ENABLE_JMX_DETAILED("hazelcast.jmx.detailed", false),
    MC_MAX_VISIBLE_INSTANCE_COUNT("hazelcast.mc.max.visible.instance.count", 100),
    MC_MAX_VISIBLE_SLOW_OPERATION_COUNT("hazelcast.mc.max.visible.slow.operations.count", 10),
    MC_URL_CHANGE_ENABLED("hazelcast.mc.url.change.enabled", true),
    CONNECTION_MONITOR_INTERVAL("hazelcast.connection.monitor.interval", 100, TimeUnit.MILLISECONDS),
    CONNECTION_MONITOR_MAX_FAULTS("hazelcast.connection.monitor.max.faults", 3),
    PARTITION_MIGRATION_INTERVAL("hazelcast.partition.migration.interval", 0, TimeUnit.SECONDS),
    PARTITION_MIGRATION_TIMEOUT("hazelcast.partition.migration.timeout", 300, TimeUnit.SECONDS),
    PARTITION_MIGRATION_ZIP_ENABLED("hazelcast.partition.migration.zip.enabled", true),
    PARTITION_TABLE_SEND_INTERVAL("hazelcast.partition.table.send.interval", 15, TimeUnit.SECONDS),
    PARTITION_BACKUP_SYNC_INTERVAL("hazelcast.partition.backup.sync.interval", 30, TimeUnit.SECONDS),
    PARTITION_MAX_PARALLEL_REPLICATIONS("hazelcast.partition.max.parallel.replications", 5),
    PARTITIONING_STRATEGY_CLASS("hazelcast.partitioning.strategy.class", ""),
    GRACEFUL_SHUTDOWN_MAX_WAIT("hazelcast.graceful.shutdown.max.wait", 600, TimeUnit.SECONDS),
    SYSTEM_LOG_ENABLED("hazelcast.system.log.enabled", true),
    SLOW_OPERATION_DETECTOR_ENABLED("hazelcast.slow.operation.detector.enabled", true),
    SLOW_OPERATION_DETECTOR_THRESHOLD_MILLIS("hazelcast.slow.operation.detector.threshold.millis", 10000, TimeUnit.MILLISECONDS),
    SLOW_OPERATION_DETECTOR_LOG_RETENTION_SECONDS("hazelcast.slow.operation.detector.log.retention.seconds", 3600, TimeUnit.SECONDS),
    SLOW_OPERATION_DETECTOR_LOG_PURGE_INTERVAL_SECONDS("hazelcast.slow.operation.detector.log.purge.interval.seconds", 300, TimeUnit.SECONDS),
    SLOW_OPERATION_DETECTOR_STACK_TRACE_LOGGING_ENABLED("hazelcast.slow.operation.detector.stacktrace.logging.enabled", false),
    SLOW_INVOCATION_DETECTOR_THRESHOLD_MILLIS("hazelcast.slow.invocation.detector.threshold.millis", -1, TimeUnit.MILLISECONDS),
    LOCK_MAX_LEASE_TIME_SECONDS("hazelcast.lock.max.lease.time.seconds", Long.MAX_VALUE, TimeUnit.SECONDS),
    ENTERPRISE_LICENSE_KEY("hazelcast.enterprise.license.key"),
    MAP_WRITE_BEHIND_QUEUE_CAPACITY("hazelcast.map.write.behind.queue.capacity", 50000),
    ENTERPRISE_WAN_REP_QUEUE_CAPACITY("hazelcast.enterprise.wanrep.queue.capacity", 100000),
    ENTERPRISE_WAN_REP_BATCH_SIZE("hazelcast.enterprise.wanrep.batch.size", 50),
    ENTERPRISE_WAN_REP_BATCH_FREQUENCY_SECONDS("hazelcast.enterprise.wanrep.batchfrequency.seconds", 5, TimeUnit.SECONDS),
    ENTERPRISE_WAN_REP_OP_TIMEOUT_MILLIS("hazelcast.enterprise.wanrep.optimeout.millis", 60000, TimeUnit.MILLISECONDS),
    CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED("hazelcast.cache.invalidation.batch.enabled", true),
    CACHE_INVALIDATION_MESSAGE_BATCH_SIZE("hazelcast.cache.invalidation.batch.size", 100),
    CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS("hazelcast.cache.invalidation.batchfrequency.seconds", 10, TimeUnit.SECONDS),
    MAP_INVALIDATION_MESSAGE_BATCH_ENABLED("hazelcast.map.invalidation.batch.enabled", true),
    MAP_INVALIDATION_MESSAGE_BATCH_SIZE("hazelcast.map.invalidation.batch.size", 100),
    MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS("hazelcast.map.invalidation.batchfrequency.seconds", 10, TimeUnit.SECONDS),
    BACKPRESSURE_ENABLED("hazelcast.backpressure.enabled", false),
    BACKPRESSURE_SYNCWINDOW("hazelcast.backpressure.syncwindow", 100),
    BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS("hazelcast.backpressure.backoff.timeout.millis", 60000, TimeUnit.MILLISECONDS),
    BACKPRESSURE_MAX_CONCURRENT_INVOCATIONS_PER_PARTITION("hazelcast.backpressure.max.concurrent.invocations.per.partition", 100),
    QUERY_PREDICATE_PARALLEL_EVALUATION("hazelcast.query.predicate.parallel.evaluation", false),
    QUERY_RESULT_SIZE_LIMIT("hazelcast.query.result.size.limit", -1),
    QUERY_MAX_LOCAL_PARTITION_LIMIT_FOR_PRE_CHECK("hazelcast.query.max.local.partition.limit.for.precheck", 3),
    QUERY_OPTIMIZER_TYPE("hazelcast.query.optimizer.type", QueryOptimizerFactory.Type.RULES.toString()),
    JCACHE_PROVIDER_TYPE("hazelcast.jcache.provider.type"),
    DISCOVERY_SPI_ENABLED("hazelcast.discovery.enabled", false),
    DISCOVERY_SPI_PUBLIC_IP_ENABLED("hazelcast.discovery.public.ip.enabled", false),
    SERIALIZATION_VERSION("hazelcast.serialization.version", BuildInfoProvider.getBuildInfo().getSerializationVersion());

    private final String name;
    private final String defaultValue;
    private final TimeUnit timeUnit;
    private final GroupProperty parent;

    private GroupProperty(String name) {
        this(name, (String)null);
    }

    private GroupProperty(String name, boolean defaultValue) {
        this(name, defaultValue ? "true" : "false");
    }

    private GroupProperty(String name, Integer defaultValue) {
        this(name, String.valueOf(defaultValue));
    }

    private GroupProperty(String name, Byte defaultValue) {
        this(name, String.valueOf(defaultValue));
    }

    private GroupProperty(String name, String defaultValue) {
        this(name, defaultValue, null);
    }

    private GroupProperty(String name, Integer defaultValue, TimeUnit timeUnit) {
        this(name, String.valueOf(defaultValue), timeUnit);
    }

    private GroupProperty(String name, Long defaultValue, TimeUnit timeUnit) {
        this(name, Long.toString(defaultValue), timeUnit);
    }

    private GroupProperty(String name, String defaultValue, TimeUnit timeUnit) {
        this(name, defaultValue, timeUnit, null);
    }

    private GroupProperty(String name, GroupProperty groupProperty) {
        this(name, groupProperty.getDefaultValue(), groupProperty.timeUnit, groupProperty);
    }

    private GroupProperty(String name, String defaultValue, TimeUnit timeUnit, GroupProperty parent) {
        Preconditions.checkHasText(name, "The property name cannot be null or empty!");
        this.name = name;
        this.defaultValue = defaultValue;
        this.timeUnit = timeUnit;
        this.parent = parent;
    }

    @Override
    public int getIndex() {
        return this.ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public TimeUnit getTimeUnit() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException(String.format("groupProperty %s has no TimeUnit defined!", this));
        }
        return this.timeUnit;
    }

    @Override
    public GroupProperty getParent() {
        return this.parent;
    }

    @Override
    public void setSystemProperty(String value) {
        System.setProperty(this.name, value);
    }

    @Override
    public String getSystemProperty() {
        return System.getProperty(this.name);
    }

    @Override
    public String clearSystemProperty() {
        return System.clearProperty(this.name);
    }

    public String toString() {
        return this.name;
    }
}

