/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.client.MapAddEntryListenerRequest;
import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.map.impl.nearcache.InvalidationListener;
import com.hazelcast.map.impl.nearcache.NearCacheInvalidatorImpl;

public class MapAddNearCacheEntryListenerRequest
extends MapAddEntryListenerRequest {
    public MapAddNearCacheEntryListenerRequest() {
    }

    public MapAddNearCacheEntryListenerRequest(String name, boolean includeValue) {
        super(name, includeValue, EntryEventType.INVALIDATION.getType());
    }

    @Override
    public int getClassId() {
        return 50;
    }

    @Override
    protected Object newMapListener(ClientEndpoint endpoint) {
        return new ClientNearCacheInvalidationListenerImpl(this.name, endpoint, this.getCallId());
    }

    private static class ClientNearCacheInvalidationListenerImpl
    implements InvalidationListener {
        private final long callId;
        private final String mapName;
        private final ClientEndpoint endpoint;

        ClientNearCacheInvalidationListenerImpl(String mapName, ClientEndpoint endpoint, long callId) {
            this.mapName = mapName;
            this.endpoint = endpoint;
            this.callId = callId;
        }

        @Override
        public void onInvalidate(Invalidation event) {
            if (!this.endpoint.isAlive() || this.endpoint.getUuid().equals(event.getSourceUuid())) {
                return;
            }
            Object partitionKey = NearCacheInvalidatorImpl.getOrderKey(this.mapName, event);
            this.endpoint.sendEvent(partitionKey, event, this.callId);
        }
    }
}

