/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BatchNearCacheInvalidation
extends Invalidation {
    private List<Data> dataList;

    public BatchNearCacheInvalidation() {
    }

    public BatchNearCacheInvalidation(String mapName, int size) {
        this(mapName, size, null);
    }

    public BatchNearCacheInvalidation(String mapName, int size, String sourceUuid) {
        this(mapName, new ArrayList<Data>(size), sourceUuid);
    }

    public BatchNearCacheInvalidation(String mapName, List<Data> dataList, String sourceUuid) {
        super(mapName, sourceUuid);
        this.dataList = dataList;
    }

    public void add(Data key) {
        this.dataList.add(key);
    }

    public List<Data> getDataList() {
        return this.dataList;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.dataList.size());
        for (Data key : this.dataList) {
            out.writeData(key);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        int size = in.readInt();
        if (size != 0) {
            ArrayList<Data> keysToBeInvalidated = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                keysToBeInvalidated.add(in.readData());
            }
            this.dataList = keysToBeInvalidated;
        }
    }
}

