/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.Member;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.CleaningNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.map.impl.nearcache.NearCacheInvalidator;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.hazelcast.map.impl.operation.InvalidateNearCacheOperation;
import com.hazelcast.map.impl.operation.NearCacheKeySetInvalidationOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NearCacheInvalidatorImpl
implements NearCacheInvalidator {
    private static final String INVALIDATION_EXECUTOR_NAME = NearCacheInvalidator.class.getName();
    private final ConstructorFunction<String, InvalidationQueue> invalidationQueueConstructor = new ConstructorFunction<String, InvalidationQueue>(){

        @Override
        public InvalidationQueue createNew(String mapName) {
            return new InvalidationQueue();
        }
    };
    private final ConcurrentMap<String, InvalidationQueue> invalidationQueues = new ConcurrentHashMap<String, InvalidationQueue>();
    private final EventService eventService;
    private final NodeEngine nodeEngine;
    private final MapServiceContext mapServiceContext;
    private final NearCacheProvider nearCacheProvider;
    private final boolean batchingEnabled;
    private final int batchSize;
    private String listenerRegistrationId;

    NearCacheInvalidatorImpl(MapServiceContext mapServiceContext, NearCacheProvider nearCacheProvider) {
        this.mapServiceContext = mapServiceContext;
        this.nearCacheProvider = nearCacheProvider;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.eventService = this.nodeEngine.getEventService();
        this.batchSize = this.getBatchSize();
        this.batchingEnabled = this.isBatchingEnabled(this.batchSize);
        if (this.batchingEnabled) {
            this.startBackgroundBatchProcessor();
            this.handleBatchesOnNodeShutdown();
        }
    }

    private void handleBatchesOnNodeShutdown() {
        HazelcastInstance node = this.nodeEngine.getHazelcastInstance();
        LifecycleService lifecycleService = node.getLifecycleService();
        this.listenerRegistrationId = lifecycleService.addLifecycleListener(new LifecycleListener(){

            @Override
            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTTING_DOWN) {
                    Set entries = NearCacheInvalidatorImpl.this.invalidationQueues.entrySet();
                    for (Map.Entry entry : entries) {
                        NearCacheInvalidatorImpl.this.sendBatchInvalidation((String)entry.getKey(), (InvalidationQueue)entry.getValue());
                    }
                }
            }
        });
    }

    private void startBackgroundBatchProcessor() {
        int periodSeconds = this.getBackgroundProcessorRunPeriodSeconds();
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.scheduleAtFixedRate(INVALIDATION_EXECUTOR_NAME, new MapBatchInvalidationEventSender(), periodSeconds, periodSeconds, TimeUnit.SECONDS);
    }

    private int getBatchSize() {
        GroupProperties groupProperties = this.nodeEngine.getGroupProperties();
        return groupProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE);
    }

    private boolean isBatchingEnabled(int batchSize) {
        GroupProperties groupProperties = this.nodeEngine.getGroupProperties();
        return groupProperties.getBoolean(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED) && batchSize > 1;
    }

    private int getBackgroundProcessorRunPeriodSeconds() {
        GroupProperties groupProperties = this.nodeEngine.getGroupProperties();
        return groupProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS);
    }

    @Override
    public void invalidateLocalNearCache(String mapName, Data key) {
        if (!this.isServerNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.nearCacheProvider.getOrNullNearCache(mapName);
        if (nearCache != null) {
            nearCache.remove(key);
        }
    }

    @Override
    public void invalidateLocalNearCache(String mapName, Collection<Data> keys) {
        if (!this.isServerNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.nearCacheProvider.getOrNullNearCache(mapName);
        if (nearCache != null) {
            for (Data key : keys) {
                nearCache.remove(key);
            }
        }
    }

    @Override
    public void clearLocalNearCache(String mapName, String sourceUuid) {
        if (!this.isServerNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.nearCacheProvider.getOrNullNearCache(mapName);
        if (nearCache != null) {
            nearCache.clear();
        }
    }

    @Override
    public void clearNearCaches(String mapName, boolean owner, String sourceUuid) {
        if (owner) {
            this.sendRemoteCleaningInvalidation(mapName, sourceUuid);
        }
        this.clearLocalNearCache(mapName, sourceUuid);
    }

    @Override
    public void invalidateNearCaches(String mapName, Data key, String sourceUuid) {
        this.sendRemoteInvalidation(mapName, key, sourceUuid);
        this.invalidateLocalNearCache(mapName, key);
    }

    @Override
    public void invalidateNearCaches(String mapName, List<Data> keys, String sourceUuid) {
        if (CollectionUtil.isEmpty(keys)) {
            return;
        }
        this.sendRemoteInvalidation(mapName, keys, sourceUuid);
        this.invalidateLocalNearCache(mapName, keys);
    }

    @Override
    public void flushAndRemoveInvalidationQueue(String mapName) {
        InvalidationQueue invalidationQueue = (InvalidationQueue)this.invalidationQueues.remove(mapName);
        if (invalidationQueue != null) {
            this.sendRemoteCleaningInvalidation(mapName, null);
        }
    }

    @Override
    public void shutdown() {
        if (this.batchingEnabled) {
            assert (this.listenerRegistrationId != null);
            ExecutionService executionService = this.nodeEngine.getExecutionService();
            executionService.shutdownExecutor(INVALIDATION_EXECUTOR_NAME);
            HazelcastInstance node = this.nodeEngine.getHazelcastInstance();
            LifecycleService lifecycleService = node.getLifecycleService();
            lifecycleService.removeLifecycleListener(this.listenerRegistrationId);
            this.invalidationQueues.clear();
        }
    }

    @Override
    public void reset() {
        if (this.batchingEnabled) {
            this.invalidationQueues.clear();
        }
    }

    public void accumulateOrSendBatchInvalidation(String mapName, Data key) {
        if (!this.isServerNearCacheInvalidationEnabled(mapName) && !this.hasInvalidationListener(mapName)) {
            return;
        }
        InvalidationQueue invalidationQueue = ConcurrencyUtil.getOrPutIfAbsent(this.invalidationQueues, mapName, this.invalidationQueueConstructor);
        invalidationQueue.offer(this.mapServiceContext.toData(key));
        if (invalidationQueue.size() >= this.batchSize) {
            this.sendBatchInvalidation(mapName, invalidationQueue);
        }
    }

    private boolean isServerNearCacheInvalidationEnabled(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getOrNullMapContainer(mapName);
        if (mapContainer == null) {
            return false;
        }
        return mapContainer.isServerNearCacheInvalidationEnabled();
    }

    protected boolean hasInvalidationListener(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getOrNullMapContainer(mapName);
        if (mapContainer == null) {
            return false;
        }
        return mapContainer.hasInvalidationListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatchInvalidation(String mapName, InvalidationQueue invalidationQueue) {
        Data key;
        if (invalidationQueue == null) {
            return;
        }
        if (!invalidationQueue.tryAcquire()) {
            return;
        }
        int size = invalidationQueue.size();
        ArrayList<Data> keysToBeInvalidated = new ArrayList<Data>(size);
        for (int i = 0; i < size && (key = invalidationQueue.poll()) != null; ++i) {
            keysToBeInvalidated.add(key);
        }
        try {
            this.sendInvalidationToServerNearCaches(mapName, keysToBeInvalidated);
            this.sendInvalidationToClientNearCaches(mapName, keysToBeInvalidated, null);
        }
        finally {
            invalidationQueue.release();
        }
    }

    private void sendRemoteInvalidation(String mapName, Data key, String sourceUuid) {
        if (this.batchingEnabled) {
            this.accumulateOrSendBatchInvalidation(mapName, key);
        } else {
            this.sendInvalidationToServerNearCaches(mapName, key);
            this.sendInvalidationToClientNearCaches(mapName, key, sourceUuid);
        }
    }

    private void sendRemoteInvalidation(String mapName, List<Data> keys, String sourceUuid) {
        if (this.batchingEnabled) {
            for (Data key : keys) {
                this.accumulateOrSendBatchInvalidation(mapName, key);
            }
        } else {
            this.sendInvalidationToServerNearCaches(mapName, keys);
            this.sendInvalidationToClientNearCaches(mapName, keys, sourceUuid);
        }
    }

    private void sendRemoteCleaningInvalidation(String mapName, String sourceUuid) {
        this.sendInvalidationToClientNearCaches(mapName, null, sourceUuid);
    }

    private void sendInvalidationToClientNearCaches(String mapName, Object invalidationData, String sourceUuid) {
        if (!this.hasInvalidationListener(mapName)) {
            return;
        }
        Invalidation invalidation = null;
        Collection<EventRegistration> registrations = this.eventService.getRegistrations("hz:impl:mapService", mapName);
        for (EventRegistration registration : registrations) {
            EventFilter filter = registration.getFilter();
            if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) continue;
            if (invalidation == null) {
                invalidation = this.newInvalidation(mapName, invalidationData, sourceUuid);
            }
            Object orderKey = NearCacheInvalidatorImpl.getOrderKey(mapName, invalidation);
            this.eventService.publishEvent("hz:impl:mapService", registration, (Object)invalidation, orderKey.hashCode());
        }
    }

    private Invalidation newInvalidation(String mapName, Object invalidationData, String sourceUuid) {
        if (invalidationData instanceof Data) {
            return new SingleNearCacheInvalidation(mapName, (Data)invalidationData, sourceUuid);
        }
        if (invalidationData instanceof List) {
            return new BatchNearCacheInvalidation(mapName, (List)invalidationData, sourceUuid);
        }
        if (invalidationData == null) {
            return new CleaningNearCacheInvalidation(mapName, sourceUuid);
        }
        throw new IllegalArgumentException("Unexpected near cache invalidation data type found = [" + invalidationData + ']');
    }

    public static Object getOrderKey(String mapName, Invalidation invalidation) {
        if (invalidation instanceof SingleNearCacheInvalidation) {
            return ((SingleNearCacheInvalidation)invalidation).getKey();
        }
        return mapName;
    }

    private void sendInvalidationToServerNearCaches(String mapName, Data key) {
        if (!this.isServerNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        for (Member member : members) {
            if (member.localMember()) continue;
            Operation operation = new InvalidateNearCacheOperation(mapName, key).setServiceName("hz:impl:mapService");
            this.nodeEngine.getOperationService().send(operation, member.getAddress());
        }
    }

    private void sendInvalidationToServerNearCaches(String mapName, List<Data> keys) {
        if (!this.isServerNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        for (Member member : members) {
            if (member.localMember()) continue;
            Operation operation = new NearCacheKeySetInvalidationOperation(mapName, keys).setServiceName("hz:impl:mapService");
            this.nodeEngine.getOperationService().send(operation, member.getAddress());
        }
    }

    private class MapBatchInvalidationEventSender
    implements Runnable {
        private MapBatchInvalidationEventSender() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : NearCacheInvalidatorImpl.this.invalidationQueues.entrySet()) {
                if (Thread.currentThread().isInterrupted()) break;
                String mapName = (String)entry.getKey();
                InvalidationQueue invalidationQueue = (InvalidationQueue)entry.getValue();
                if (invalidationQueue.size() <= 0) continue;
                NearCacheInvalidatorImpl.this.sendBatchInvalidation(mapName, invalidationQueue);
            }
        }
    }

    private static class InvalidationQueue
    extends ConcurrentLinkedQueue<Data> {
        private final AtomicInteger elementCount = new AtomicInteger(0);
        private final AtomicBoolean flushingInProgress = new AtomicBoolean(false);

        private InvalidationQueue() {
        }

        @Override
        public int size() {
            return this.elementCount.get();
        }

        @Override
        public boolean offer(Data key) {
            boolean offered = super.offer(key);
            if (offered) {
                this.elementCount.incrementAndGet();
            }
            return offered;
        }

        @Override
        public Data poll() {
            Data polledItem = (Data)super.poll();
            if (polledItem != null) {
                this.elementCount.decrementAndGet();
            }
            return polledItem;
        }

        public boolean tryAcquire() {
            return this.flushingInProgress.compareAndSet(false, true);
        }

        public void release() {
            this.flushingInProgress.set(false);
        }

        @Override
        public boolean add(Data key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Data remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Data> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

