/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NearCacheKeySetInvalidationOperation
extends AbstractOperation
implements MutatingOperation {
    private MapService mapService;
    private List<Data> keys;
    private String mapName;

    public NearCacheKeySetInvalidationOperation() {
    }

    public NearCacheKeySetInvalidationOperation(String mapName, List<Data> keys) {
        this.keys = Preconditions.checkNotNull(keys);
        this.mapName = mapName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() {
        this.mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        if (mapServiceContext.getMapContainer(this.mapName).isNearCacheEnabled()) {
            NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
            nearCacheProvider.getNearCacheInvalidator().invalidateLocalNearCache(this.mapName, this.keys);
        } else {
            this.getLogger().warning("Cache clear operation has been accepted while near cache is not enabled for " + this.mapName + " map. Possible configuration conflict among nodes.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            out.writeData(key);
        }
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        int size = in.readInt();
        ArrayList<Data> keys = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            keys.add(key);
        }
        this.keys = keys;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.mapName);
    }
}

