/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutAllBackupOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutAllOperation
extends MapOperation
implements PartitionAwareOperation,
BackupAwareOperation,
MutatingOperation {
    private MapEntries mapEntries;
    private boolean initialLoad;
    private List<Map.Entry<Data, Data>> backupEntries;
    private List<RecordInfo> backupRecordInfos;
    private transient RecordStore recordStore;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, MapEntries mapEntries) {
        super(name);
        this.mapEntries = mapEntries;
    }

    public PutAllOperation(String name, MapEntries mapEntries, boolean initialLoad) {
        super(name);
        this.mapEntries = mapEntries;
        this.initialLoad = initialLoad;
    }

    @Override
    public void run() {
        this.backupRecordInfos = new ArrayList<RecordInfo>(this.mapEntries.size());
        this.backupEntries = new ArrayList<Map.Entry<Data, Data>>(this.mapEntries.size());
        int partitionId = this.getPartitionId();
        this.recordStore = this.mapServiceContext.getRecordStore(partitionId, this.name);
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (Map.Entry<Data, Data> entry : this.mapEntries) {
            this.put(partitionId, partitionService, entry);
        }
        this.invalidateNearCaches(this.mapEntries);
    }

    private boolean put(int partitionId, InternalPartitionService partitionService, Map.Entry<Data, Data> entry) {
        Data dataKey = entry.getKey();
        if (partitionId != partitionService.getPartitionId(dataKey)) {
            return false;
        }
        Data dataValue = entry.getValue();
        Object oldValue = null;
        if (this.initialLoad) {
            this.recordStore.putFromLoad(dataKey, dataValue, -1L);
        } else {
            oldValue = this.recordStore.put(dataKey, dataValue, -1L);
        }
        this.mapServiceContext.interceptAfterPut(this.name, dataValue);
        EntryEventType eventType = oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        MapEventPublisher mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        dataValue = this.getValueOrPostProcessedValue(dataKey, dataValue);
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, oldValue, dataValue);
        Object record = this.recordStore.getRecord(dataKey);
        if (this.shouldWanReplicate()) {
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(dataKey, dataValue, record);
            mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
        }
        this.backupEntries.add(entry);
        RecordInfo replicationInfo = Records.buildRecordInfo(record);
        this.backupRecordInfos.add(replicationInfo);
        this.evict();
        return true;
    }

    private Data getValueOrPostProcessedValue(Data dataKey, Data dataValue) {
        if (!this.recordStore.getMapDataStore().isPostProcessingMapStore()) {
            return dataValue;
        }
        Object record = this.recordStore.getRecord(dataKey);
        return this.mapServiceContext.toData(record.getValue());
    }

    private boolean shouldWanReplicate() {
        return this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null;
    }

    protected final void invalidateNearCaches(MapEntries mapEntries) {
        ArrayList<Data> keys = new ArrayList<Data>(mapEntries.size());
        for (Map.Entry<Data, Data> mapEntry : mapEntries) {
            keys.add(mapEntry.getKey());
        }
        this.invalidateNearCache(keys);
    }

    protected void evict() {
        long now = Clock.currentTimeMillis();
        this.recordStore.evictEntries(now);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return !this.backupEntries.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.name, this.backupEntries, this.backupRecordInfos);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mapEntries);
        out.writeBoolean(this.initialLoad);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapEntries = (MapEntries)in.readObject();
        this.initialLoad = in.readBoolean();
    }
}

