/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.map.impl.record.DataRecord;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class CachedDataRecord
extends DataRecord {
    private static final AtomicReferenceFieldUpdater<CachedDataRecord, Object> CACHED_VALUE = AtomicReferenceFieldUpdater.newUpdater(CachedDataRecord.class, Object.class, "cachedValue");
    private volatile transient Object cachedValue;

    CachedDataRecord() {
    }

    CachedDataRecord(Data value) {
        super(value);
    }

    @Override
    public void setValue(Data o) {
        super.setValue(o);
        this.cachedValue = null;
    }

    @Override
    public Object getCachedValueUnsafe() {
        return this.cachedValue;
    }

    @Override
    public boolean casCachedValue(Object expectedValue, Object newValue) {
        return CACHED_VALUE.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedValue = null;
    }
}

