/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class SocketAcceptorThread
extends Thread {
    private static final int SHUTDOWN_TIMEOUT_MILLIS = 10000;
    private final ServerSocketChannel serverSocketChannel;
    private final TcpIpConnectionManager connectionManager;
    private final ILogger logger;
    private final IOService ioService;

    public SocketAcceptorThread(ThreadGroup threadGroup, String name, ServerSocketChannel serverSocketChannel, TcpIpConnectionManager connectionManager) {
        super(threadGroup, name);
        this.serverSocketChannel = serverSocketChannel;
        this.connectionManager = connectionManager;
        this.ioService = connectionManager.getIoService();
        this.logger = this.ioService.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Starting SocketAcceptor on " + this.serverSocketChannel);
        }
        Selector selector = null;
        try {
            selector = Selector.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.register(selector, 16);
            this.acceptLoop(selector);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryErrorDispatcher.onOutOfMemory(e);
        }
        catch (IOException e) {
            this.logger.severe(e.getClass().getName() + ": " + e.getMessage(), e);
        }
        finally {
            this.closeSelector(selector);
        }
    }

    private void acceptLoop(Selector selector) throws IOException {
        while (this.connectionManager.isLive()) {
            int keyCount = selector.select();
            if (this.isInterrupted()) break;
            if (keyCount == 0) continue;
            Iterator<SelectionKey> it = selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey sk = it.next();
                it.remove();
                if (!sk.isValid() || !sk.isAcceptable()) continue;
                this.acceptSocket();
            }
        }
    }

    private void closeSelector(Selector selector) {
        if (selector == null) {
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Closing selector " + Thread.currentThread().getName());
        }
        try {
            selector.close();
        }
        catch (Exception e) {
            this.logger.finest("Exception while closing selector", e);
        }
    }

    private void acceptSocket() {
        SocketChannel socketChannel;
        if (!this.connectionManager.isLive()) {
            return;
        }
        SocketChannelWrapper socketChannelWrapper = null;
        try {
            socketChannel = this.serverSocketChannel.accept();
            if (socketChannel != null) {
                socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, false);
            }
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException && !this.connectionManager.isLive()) {
                this.logger.finest("Terminating socket acceptor thread...", e);
            }
            this.logger.warning("Unexpected error while accepting connection! " + e.getClass().getName() + ": " + e.getMessage());
            try {
                this.serverSocketChannel.close();
            }
            catch (Exception ex) {
                this.logger.finest("Closing server socket failed", ex);
            }
            this.ioService.onFatalError(e);
        }
        if (socketChannelWrapper != null) {
            socketChannel = socketChannelWrapper;
            this.logger.info("Accepting socket connection from " + socketChannel.socket().getRemoteSocketAddress());
            if (this.connectionManager.isSocketInterceptorEnabled()) {
                this.configureAndAssignSocket((SocketChannelWrapper)((Object)socketChannel));
            } else {
                this.ioService.executeAsync(new Runnable((SocketChannelWrapper)((Object)socketChannel)){
                    final /* synthetic */ SocketChannelWrapper val$socketChannel;
                    {
                        this.val$socketChannel = socketChannelWrapper;
                    }

                    @Override
                    public void run() {
                        SocketAcceptorThread.this.configureAndAssignSocket(this.val$socketChannel);
                    }
                });
            }
        }
    }

    private void configureAndAssignSocket(SocketChannelWrapper socketChannel) {
        try {
            this.connectionManager.initSocket(socketChannel.socket());
            this.connectionManager.interceptSocket(socketChannel.socket(), true);
            socketChannel.configureBlocking(this.connectionManager.getIoThreadingModel().isBlocking());
            this.connectionManager.newConnection(socketChannel, null);
        }
        catch (Exception e) {
            this.logger.warning(e.getClass().getName() + ": " + e.getMessage(), e);
            IOUtil.closeResource(socketChannel);
        }
    }

    public void shutdown() {
        this.logger.finest("Shutting down SocketAcceptor thread.");
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException e) {
            this.logger.finest(e);
        }
    }
}

