/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.MultiResult;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractPredicate
implements Predicate,
IdentifiedDataSerializable {
    String attributeName;
    private volatile transient AttributeType attributeType;

    protected AbstractPredicate() {
    }

    protected AbstractPredicate(String attributeName) {
        this.attributeName = attributeName;
    }

    public boolean apply(Map.Entry mapEntry) {
        Object attributeValue = this.readAttributeValue(mapEntry);
        if (attributeValue instanceof MultiResult) {
            return this.applyForMultiResult(mapEntry, (MultiResult)attributeValue);
        }
        if (attributeValue instanceof Collection || attributeValue instanceof Object[]) {
            throw new IllegalArgumentException(String.format("Cannot use %s predicate with an array or a collection attribute", this.getClass().getSimpleName()));
        }
        return this.applyForSingleAttributeValue(mapEntry, (Comparable)attributeValue);
    }

    private boolean applyForMultiResult(Map.Entry mapEntry, MultiResult result) {
        List results = result.getResults();
        for (Object o : results) {
            Comparable entryValue = (Comparable)this.convertEnumValue(o);
            boolean satisfied = this.applyForSingleAttributeValue(mapEntry, entryValue);
            if (!satisfied) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean applyForSingleAttributeValue(Map.Entry var1, Comparable var2);

    protected Comparable convert(Map.Entry entry, Comparable entryAttributeValue, Comparable givenAttributeValue) {
        if (givenAttributeValue == null) {
            return null;
        }
        if (givenAttributeValue instanceof IndexImpl.NullObject) {
            return IndexImpl.NULL;
        }
        AttributeType type = this.attributeType;
        if (type == null) {
            if (entryAttributeValue == null) {
                return givenAttributeValue;
            }
            this.attributeType = type = ((QueryableEntry)entry).getAttributeType(this.attributeName);
        }
        Class<?> entryAttributeClass = entryAttributeValue != null ? entryAttributeValue.getClass() : null;
        return this.convert(type, entryAttributeClass, givenAttributeValue);
    }

    private Comparable convert(AttributeType entryAttributeType, Class<?> entryAttributeClass, Comparable givenAttributeValue) {
        if (entryAttributeType == AttributeType.ENUM) {
            return entryAttributeType.getConverter().convert(givenAttributeValue);
        }
        if (entryAttributeClass != null && entryAttributeClass.isAssignableFrom(givenAttributeValue.getClass())) {
            return givenAttributeValue;
        }
        if (entryAttributeType != null) {
            return entryAttributeType.getConverter().convert(givenAttributeValue);
        }
        throw new QueryException("Unknown attribute type: " + givenAttributeValue.getClass().getName() + " for attribute: " + this.attributeName);
    }

    protected Object readAttributeValue(Map.Entry entry) {
        QueryableEntry queryableEntry = (QueryableEntry)entry;
        Object attributeValue = queryableEntry.getAttributeValue(this.attributeName);
        return this.convertEnumValue(attributeValue);
    }

    protected Object convertEnumValue(Object attributeValue) {
        if (attributeValue != null && attributeValue.getClass().isEnum()) {
            attributeValue = attributeValue.toString();
        }
        return attributeValue;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attributeName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return -32;
    }
}

