/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.EmptyStatement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;

public abstract class Operation
implements DataSerializable {
    public static final int GENERIC_PARTITION_ID = -1;
    public static final long CALL_ID_LOCAL_SKIPPED = Long.MAX_VALUE;
    static final int BITMASK_VALIDATE_TARGET = 1;
    static final int BITMASK_CALLER_UUID_SET = 2;
    static final int BITMASK_REPLICA_INDEX_SET = 4;
    static final int BITMASK_WAIT_TIMEOUT_SET = 8;
    static final int BITMASK_PARTITION_ID_32_BIT = 16;
    static final int BITMASK_CALL_TIMEOUT_64_BIT = 32;
    static final int BITMASK_SERVICE_NAME_SET = 64;
    private String serviceName;
    private int partitionId = -1;
    private int replicaIndex;
    private long callId;
    private short flags;
    private long invocationTime = -1L;
    private long callTimeout = Long.MAX_VALUE;
    private long waitTimeout = -1L;
    private String callerUuid;
    private transient NodeEngine nodeEngine;
    private transient Object service;
    private transient Address callerAddress;
    private transient Connection connection;
    private transient OperationResponseHandler responseHandler;

    public Operation() {
        this.setFlag(true, 1);
        this.setFlag(true, 32);
    }

    public boolean isUrgent() {
        return this instanceof UrgentSystemOperation;
    }

    public abstract void beforeRun() throws Exception;

    public abstract void run() throws Exception;

    public abstract void afterRun() throws Exception;

    public abstract boolean returnsResponse();

    public abstract Object getResponse();

    String getRawServiceName() {
        return this.serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public final Operation setServiceName(String serviceName) {
        if (serviceName == this.getServiceName()) {
            return this;
        }
        this.serviceName = serviceName;
        this.setFlag(serviceName != null, 64);
        return this;
    }

    public final int getPartitionId() {
        return this.partitionId;
    }

    public final Operation setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        this.setFlag(partitionId > Short.MAX_VALUE, 16);
        return this;
    }

    public final int getReplicaIndex() {
        return this.replicaIndex;
    }

    public final Operation setReplicaIndex(int replicaIndex) {
        if (replicaIndex < 0 || replicaIndex >= 7) {
            throw new IllegalArgumentException("Replica index is out of range [0-6]");
        }
        this.setFlag(replicaIndex != 0, 4);
        this.replicaIndex = replicaIndex;
        return this;
    }

    public final long getCallId() {
        return this.callId;
    }

    final Operation setCallId(long callId) {
        this.callId = callId;
        this.onSetCallId();
        return this;
    }

    protected void onSetCallId() {
    }

    public boolean validatesTarget() {
        return this.isFlagSet(1);
    }

    public final Operation setValidateTarget(boolean validateTarget) {
        this.setFlag(validateTarget, 1);
        return this;
    }

    public final NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public final Operation setNodeEngine(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        return this;
    }

    public final <T> T getService() {
        if (this.service == null) {
            String name = this.serviceName != null ? this.serviceName : this.getServiceName();
            this.service = ((NodeEngineImpl)this.nodeEngine).getService(name);
        }
        return (T)this.service;
    }

    public final Operation setService(Object service) {
        this.service = service;
        return this;
    }

    public final Address getCallerAddress() {
        return this.callerAddress;
    }

    final Operation setCallerAddress(Address callerAddress) {
        this.callerAddress = callerAddress;
        return this;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    final Operation setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public final OperationResponseHandler getOperationResponseHandler() {
        return this.responseHandler;
    }

    public final Operation setOperationResponseHandler(OperationResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public final void sendResponse(Object value) {
        OperationResponseHandler operationResponseHandler = this.getOperationResponseHandler();
        operationResponseHandler.sendResponse(this, value);
    }

    @Deprecated
    public final ResponseHandler getResponseHandler() {
        if (this.responseHandler == null) {
            return null;
        }
        if (this.responseHandler instanceof ResponseHandlerAdapter) {
            ResponseHandlerAdapter adapter = (ResponseHandlerAdapter)this.responseHandler;
            return adapter.responseHandler;
        }
        return new ResponseHandler(){

            @Override
            public void sendResponse(Object obj) {
                Operation.this.responseHandler.sendResponse(Operation.this, obj);
            }

            @Override
            public boolean isLocal() {
                return Operation.this.responseHandler.isLocal();
            }
        };
    }

    @Deprecated
    public final Operation setResponseHandler(ResponseHandler responseHandler) {
        if (responseHandler == null) {
            this.responseHandler = null;
            return this;
        }
        this.responseHandler = new ResponseHandlerAdapter(responseHandler);
        return this;
    }

    public final long getInvocationTime() {
        return this.invocationTime;
    }

    final Operation setInvocationTime(long invocationTime) {
        this.invocationTime = invocationTime;
        return this;
    }

    public final long getCallTimeout() {
        return this.callTimeout;
    }

    final Operation setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        this.setFlag(callTimeout > Integer.MAX_VALUE, 32);
        return this;
    }

    public final long getWaitTimeout() {
        return this.waitTimeout;
    }

    public final void setWaitTimeout(long timeout) {
        this.waitTimeout = timeout;
        this.setFlag(timeout != -1L, 8);
    }

    @Deprecated
    public ExceptionAction onException(Throwable throwable) {
        return throwable instanceof RetryableException ? ExceptionAction.RETRY_INVOCATION : ExceptionAction.THROW_EXCEPTION;
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return this.onException(throwable);
    }

    public String getCallerUuid() {
        return this.callerUuid;
    }

    public Operation setCallerUuid(String callerUuid) {
        this.callerUuid = callerUuid;
        this.setFlag(callerUuid != null, 2);
        return this;
    }

    protected final ILogger getLogger() {
        NodeEngine ne = this.nodeEngine;
        return ne != null ? ne.getLogger(this.getClass()) : Logger.getLogger(this.getClass());
    }

    void setFlag(boolean value, int bitmask) {
        this.flags = value ? (short)(this.flags | bitmask) : (short)(this.flags & ~bitmask);
    }

    boolean isFlagSet(int bitmask) {
        return (this.flags & bitmask) != 0;
    }

    short getFlags() {
        return this.flags;
    }

    public void onExecutionFailure(Throwable e) {
    }

    public void logError(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof RetryableException) {
            Level level;
            Level level2 = level = this.returnsResponse() ? Level.FINEST : Level.WARNING;
            if (logger.isLoggable(level)) {
                logger.log(level, e.getClass().getName() + ": " + e.getMessage());
            }
        } else if (e instanceof OutOfMemoryError) {
            try {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
        } else if (e instanceof QuorumException) {
            logger.log(Level.WARNING, e.getMessage());
        } else {
            Level level;
            Level level3 = level = this.nodeEngine != null && this.nodeEngine.isRunning() ? Level.SEVERE : Level.FINEST;
            if (logger.isLoggable(level)) {
                logger.log(level, e.getMessage(), e);
            }
        }
    }

    @Override
    public final void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.callId);
        out.writeShort(this.flags);
        if (this.isFlagSet(64)) {
            out.writeUTF(this.serviceName);
        }
        if (this.isFlagSet(16)) {
            out.writeInt(this.partitionId);
        } else {
            out.writeShort(this.partitionId);
        }
        if (this.isFlagSet(4)) {
            out.writeByte(this.replicaIndex);
        }
        out.writeLong(this.invocationTime);
        if (this.isFlagSet(32)) {
            out.writeLong(this.callTimeout);
        } else {
            out.writeInt((int)this.callTimeout);
        }
        if (this.isFlagSet(8)) {
            out.writeLong(this.waitTimeout);
        }
        if (this.isFlagSet(2)) {
            out.writeUTF(this.callerUuid);
        }
        this.writeInternal(out);
    }

    @Override
    public final void readData(ObjectDataInput in) throws IOException {
        this.callId = in.readLong();
        this.flags = in.readShort();
        if (this.isFlagSet(64)) {
            this.serviceName = in.readUTF();
        }
        this.partitionId = this.isFlagSet(16) ? in.readInt() : (int)in.readShort();
        if (this.isFlagSet(4)) {
            this.replicaIndex = in.readByte();
        }
        this.invocationTime = in.readLong();
        this.callTimeout = this.isFlagSet(32) ? in.readLong() : (long)in.readInt();
        if (this.isFlagSet(8)) {
            this.waitTimeout = in.readLong();
        }
        if (this.isFlagSet(2)) {
            this.callerUuid = in.readUTF();
        }
        this.readInternal(in);
    }

    protected abstract void writeInternal(ObjectDataOutput var1) throws IOException;

    protected abstract void readInternal(ObjectDataInput var1) throws IOException;

    protected void toString(StringBuilder sb) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName()).append('{');
        sb.append("serviceName='").append(this.getServiceName()).append('\'');
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append(", callId=").append(this.callId);
        Date date = new Date(this.invocationTime);
        sb.append(", invocationTime=").append(this.invocationTime).append(" (").append(date).append(")");
        sb.append(", waitTimeout=").append(this.waitTimeout);
        sb.append(", callTimeout=").append(this.callTimeout);
        this.toString(sb);
        sb.append('}');
        return sb.toString();
    }

    private static class ResponseHandlerAdapter
    implements OperationResponseHandler {
        private final ResponseHandler responseHandler;

        public ResponseHandlerAdapter(ResponseHandler responseHandler) {
            this.responseHandler = responseHandler;
        }

        public void sendResponse(Operation op, Object obj) {
            this.responseHandler.sendResponse(obj);
        }

        @Override
        public boolean isLocal() {
            return this.responseHandler.isLocal();
        }
    }
}

