/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.counters.SwCounter;
import java.util.concurrent.TimeUnit;

public class InvocationMonitor {
    private static final long ON_MEMBER_LEFT_DELAY_MS = 1111L;
    private static final int SCAN_DELAY_MILLIS = 1000;
    private final long backupTimeoutMillis;
    private final long slowInvocationThresholdMs;
    private final InvocationRegistry invocationRegistry;
    private final ExecutionService executionService;
    private final MonitorThread monitorThread;
    private final ILogger logger;
    @Probe(name="invocations.backupTimeouts", level=ProbeLevel.MANDATORY)
    private final SwCounter backupTimeoutsCount = SwCounter.newSwCounter();
    @Probe(name="invocations.normalTimeouts", level=ProbeLevel.MANDATORY)
    private final SwCounter normalTimeoutsCount = SwCounter.newSwCounter();

    public InvocationMonitor(InvocationRegistry invocationRegistry, ILogger logger, GroupProperties props, HazelcastThreadGroup hzThreadGroup, ExecutionService executionService, MetricsRegistry metricsRegistry) {
        this.invocationRegistry = invocationRegistry;
        this.logger = logger;
        this.executionService = executionService;
        this.backupTimeoutMillis = props.getMillis(GroupProperty.OPERATION_BACKUP_TIMEOUT_MILLIS);
        this.slowInvocationThresholdMs = this.initSlowInvocationThresholdMs(props);
        this.monitorThread = new MonitorThread(hzThreadGroup);
        metricsRegistry.scanAndRegister(this, "operation");
        this.monitorThread.start();
    }

    private long initSlowInvocationThresholdMs(GroupProperties props) {
        long thresholdMs = props.getMillis(GroupProperty.SLOW_INVOCATION_DETECTOR_THRESHOLD_MILLIS);
        if (thresholdMs > -1L) {
            this.logger.info("Slow invocation detector enabled, using threshold: " + thresholdMs + " ms");
        }
        return thresholdMs;
    }

    public void shutdown() {
        this.monitorThread.shutdown();
    }

    public void awaitTermination(long timeoutMillis) throws InterruptedException {
        this.monitorThread.join(timeoutMillis);
    }

    public void onMemberLeft(MemberImpl member) {
        OnMemberLeftTask task = new OnMemberLeftTask(member);
        this.executionService.schedule(task, 1111L, TimeUnit.MILLISECONDS);
    }

    private final class OnMemberLeftTask
    implements Runnable {
        private final MemberImpl leftMember;

        public OnMemberLeftTask(MemberImpl leftMember) {
            this.leftMember = leftMember;
        }

        @Override
        public void run() {
            for (Invocation invocation : InvocationMonitor.this.invocationRegistry.invocations()) {
                if (!this.hasMemberLeft(invocation)) continue;
                invocation.notifyError(new MemberLeftException(this.leftMember));
            }
        }

        private boolean hasMemberLeft(Invocation invocation) {
            MemberImpl targetMember = invocation.targetMember;
            if (targetMember == null) {
                Address invTarget = invocation.invTarget;
                return this.leftMember.getAddress().equals(invTarget);
            }
            return this.leftMember.getUuid().equals(targetMember.getUuid());
        }
    }

    private final class MonitorThread
    extends Thread
    implements OperationHostileThread {
        private volatile boolean shutdown;

        private MonitorThread(HazelcastThreadGroup hzThreadGroup) {
            super(hzThreadGroup.getInternalThreadGroup(), hzThreadGroup.getThreadNamePrefix("InvocationMonitorThread"));
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    this.scan();
                    if (this.shutdown) continue;
                    this.sleep();
                }
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                InvocationMonitor.this.logger.severe("Failed to run", t);
            }
        }

        private void sleep() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                EmptyStatement.ignore(ignore);
            }
        }

        private void scan() {
            if (InvocationMonitor.this.invocationRegistry.size() == 0) {
                return;
            }
            long now = Clock.currentTimeMillis();
            int backupTimeouts = 0;
            int invocationTimeouts = 0;
            for (Invocation invocation : InvocationMonitor.this.invocationRegistry.invocations()) {
                if (this.shutdown) {
                    return;
                }
                this.detectSlowInvocation(now, invocation);
                if (this.checkInvocationTimeout(invocation)) {
                    ++invocationTimeouts;
                }
                if (!this.checkBackupTimeout(invocation)) continue;
                ++backupTimeouts;
            }
            InvocationMonitor.this.backupTimeoutsCount.inc(backupTimeouts);
            InvocationMonitor.this.normalTimeoutsCount.inc(invocationTimeouts);
            this.log(backupTimeouts, invocationTimeouts);
        }

        private void detectSlowInvocation(long now, Invocation invocation) {
            long durationMs;
            if (InvocationMonitor.this.slowInvocationThresholdMs > 0L && (durationMs = now - invocation.op.getInvocationTime()) > InvocationMonitor.this.slowInvocationThresholdMs) {
                InvocationMonitor.this.logger.info("Slow invocation: duration=" + durationMs + " ms, operation=" + invocation.op.getClass().getName() + " inv:" + invocation);
            }
        }

        private boolean checkInvocationTimeout(Invocation invocation) {
            try {
                return invocation.checkInvocationTimeout();
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                InvocationMonitor.this.logger.severe("Failed to handle operation timeout of invocation:" + invocation, t);
                return false;
            }
        }

        private boolean checkBackupTimeout(Invocation invocation) {
            try {
                return invocation.checkBackupTimeout(InvocationMonitor.this.backupTimeoutMillis);
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                InvocationMonitor.this.logger.severe("Failed to handle backup timeout of invocation:" + invocation, t);
                return false;
            }
        }

        private void log(int backupTimeouts, int invocationTimeouts) {
            if (backupTimeouts > 0 || invocationTimeouts > 0) {
                InvocationMonitor.this.logger.info("Handled " + invocationTimeouts + " invocation timeouts and " + backupTimeouts + " backupTimeouts");
            }
        }
    }
}

