/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntrySimple;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.web.HazelcastInstanceLoader;
import com.hazelcast.web.JvmIdAware;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.entryprocessor.DeleteSessionEntryProcessor;
import com.hazelcast.web.entryprocessor.GetAttributeEntryProcessor;
import com.hazelcast.web.entryprocessor.GetAttributeNamesEntryProcessor;
import com.hazelcast.web.entryprocessor.GetSessionStateEntryProcessor;
import com.hazelcast.web.entryprocessor.SessionUpdateEntryProcessor;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

public class ClusteredSessionService {
    protected static final ILogger LOGGER = Logger.getLogger(ClusteredSessionService.class);
    private static final long CLUSTER_CHECK_INTERVAL = 5L;
    private static final long RETRY_MILLIS = 7000L;
    private final String jvmId = UuidUtil.newSecureUuidString();
    private volatile IMap clusterMap;
    private volatile SerializationServiceSupport sss;
    private volatile HazelcastInstance hazelcastInstance;
    private final FilterConfig filterConfig;
    private final Properties properties;
    private final String clusterMapName;
    private final Queue<AbstractMap.SimpleEntry<String, Boolean>> orphanSessions = new LinkedBlockingQueue<AbstractMap.SimpleEntry<String, Boolean>>();
    private volatile boolean failedConnection = true;
    private volatile long lastConnectionTry;
    private final ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor(new EnsureInstanceThreadFactory());

    public ClusteredSessionService(FilterConfig filterConfig, Properties properties, String clusterMapName) {
        this.filterConfig = filterConfig;
        this.properties = properties;
        this.clusterMapName = clusterMapName;
        try {
            this.init();
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
    }

    public void setFailedConnection(boolean failedConnection) {
        this.failedConnection = failedConnection;
    }

    public void init() throws Exception {
        this.ensureInstance();
        this.es.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ClusteredSessionService.this.ensureInstance();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isFinestEnabled()) break block2;
                        LOGGER.finest("Cannot connect hazelcast server", e);
                    }
                }
            }
        }, 10L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInstance() throws Exception {
        if (this.failedConnection && System.currentTimeMillis() > this.lastConnectionTry + 7000L) {
            ClusteredSessionService clusteredSessionService = this;
            synchronized (clusteredSessionService) {
                block7: {
                    try {
                        if (this.failedConnection && System.currentTimeMillis() > this.lastConnectionTry + 7000L) {
                            this.reconnectHZInstance();
                            this.clearOrphanSessionQueue();
                        }
                    }
                    catch (Exception e) {
                        this.setFailedConnection(true);
                        if (!LOGGER.isFinestEnabled()) break block7;
                        LOGGER.finest("Cannot connect hazelcast server", e);
                    }
                }
            }
        }
    }

    private void reconnectHZInstance() throws ServletException {
        LOGGER.info("Retrying the connection!!");
        this.lastConnectionTry = System.currentTimeMillis();
        this.hazelcastInstance = HazelcastInstanceLoader.createInstance(this, this.filterConfig, this.properties);
        this.clusterMap = this.hazelcastInstance.getMap(this.clusterMapName);
        this.sss = (SerializationServiceSupport)((Object)this.hazelcastInstance);
        this.setFailedConnection(false);
        LOGGER.info("Successfully Connected!");
    }

    private void clearOrphanSessionQueue() {
        AbstractMap.SimpleEntry<String, Boolean> sessionIdEntry = this.orphanSessions.poll();
        while (sessionIdEntry != null) {
            if (!this.deleteSession(sessionIdEntry.getKey(), sessionIdEntry.getValue())) {
                sessionIdEntry = null;
                continue;
            }
            sessionIdEntry = this.orphanSessions.poll();
        }
    }

    Object executeOnKey(String sessionId, EntryProcessor processor) throws Exception {
        try {
            if (processor instanceof JvmIdAware) {
                ((JvmIdAware)((Object)processor)).setJvmId(this.jvmId);
            }
            return this.clusterMap.executeOnKey(sessionId, processor);
        }
        catch (Exception e) {
            LOGGER.finest("Cannot connect hazelcast server", e);
            throw e;
        }
    }

    Set<Map.Entry<String, Object>> getAttributes(String sessionId) throws Exception {
        GetSessionStateEntryProcessor entryProcessor = new GetSessionStateEntryProcessor();
        entryProcessor.setJvmId(this.jvmId);
        SessionState sessionState = (SessionState)this.executeOnKey(sessionId, entryProcessor);
        if (sessionState == null) {
            return null;
        }
        Map<String, Data> dataAttributes = sessionState.getAttributes();
        HashSet<Map.Entry<String, Object>> attributes = new HashSet<Map.Entry<String, Object>>(dataAttributes.size());
        for (Map.Entry<String, Data> entry : dataAttributes.entrySet()) {
            String key = entry.getKey();
            Object value = this.sss.getSerializationService().toObject(entry.getValue());
            attributes.add(new MapEntrySimple(key, value));
        }
        return attributes;
    }

    Object getAttribute(String sessionId, String attributeName) throws Exception {
        GetAttributeEntryProcessor entryProcessor = new GetAttributeEntryProcessor(attributeName);
        entryProcessor.setJvmId(this.jvmId);
        return this.executeOnKey(sessionId, entryProcessor);
    }

    void deleteAttribute(String sessionId, String attributeName) throws Exception {
        this.setAttribute(sessionId, attributeName, null);
    }

    void setAttribute(String sessionId, String attributeName, Object value) throws Exception {
        Data dataValue = value == null ? null : (Data)this.sss.getSerializationService().toData(value);
        SessionUpdateEntryProcessor sessionUpdateProcessor = new SessionUpdateEntryProcessor(attributeName, dataValue);
        sessionUpdateProcessor.setJvmId(this.jvmId);
        this.executeOnKey(sessionId, sessionUpdateProcessor);
    }

    public boolean deleteSession(String sessionId, boolean invalidate) {
        try {
            this.doDeleteSession(sessionId, invalidate);
            return true;
        }
        catch (Exception e) {
            this.orphanSessions.add(new AbstractMap.SimpleEntry<String, Boolean>(sessionId, invalidate));
            return false;
        }
    }

    private void doDeleteSession(String sessionId, boolean invalidate) throws Exception {
        DeleteSessionEntryProcessor entryProcessor = new DeleteSessionEntryProcessor(sessionId, invalidate);
        entryProcessor.setJvmId(this.jvmId);
        this.executeOnKey(sessionId, entryProcessor);
    }

    public Set<String> getAttributeNames(String id) throws Exception {
        return (Set)this.executeOnKey(id, new GetAttributeNamesEntryProcessor());
    }

    public void updateAttributes(String id, Map<String, Object> updates) throws Exception {
        SerializationService ss = this.sss.getSerializationService();
        SessionUpdateEntryProcessor sessionUpdate = new SessionUpdateEntryProcessor(updates.size());
        sessionUpdate.setJvmId(this.jvmId);
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            sessionUpdate.getAttributes().put(name, (Data)ss.toData(value));
        }
        this.executeOnKey(id, sessionUpdate);
    }

    public void destroy() {
        if (this.hazelcastInstance != null) {
            try {
                this.hazelcastInstance.getLifecycleService().shutdown();
                this.es.shutdown();
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }

    private static final class EnsureInstanceThread
    extends Thread {
        private EnsureInstanceThread(Runnable target, String name) {
            super(target, name);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
        }
    }

    private static final class EnsureInstanceThreadFactory
    implements ThreadFactory {
        private EnsureInstanceThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            EnsureInstanceThread thread = new EnsureInstanceThread(r, ".hazelcast-wm.ensureInstance");
            thread.setDaemon(true);
            return thread;
        }
    }
}

