/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.cache.CacheException;

class HazelcastInstanceLoader
implements IHazelcastInstanceLoader {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastInstanceFactory.class);
    private HazelcastInstance instance;
    private Config config;
    private boolean shutDown;

    HazelcastInstanceLoader() {
    }

    @Override
    public void configure(Properties props) {
        String instanceName;
        String configResourcePath = CacheEnvironment.getConfigFilePath(props);
        if (!StringUtil.isNullOrEmptyAfterTrim(configResourcePath)) {
            try {
                this.config = ConfigLoader.load(configResourcePath);
            }
            catch (IOException e) {
                LOGGER.warning("IOException: " + e.getMessage());
            }
            if (this.config == null) {
                throw new CacheException("Could not find configuration file: " + configResourcePath);
            }
        } else {
            this.config = new XmlConfigBuilder().build();
        }
        if ((instanceName = CacheEnvironment.getInstanceName(props)) != null) {
            this.config.setInstanceName(instanceName);
        }
        this.shutDown = CacheEnvironment.shutdownOnStop(props, instanceName == null);
    }

    @Override
    public HazelcastInstance loadInstance() throws CacheException {
        this.instance = this.config.getInstanceName() == null ? Hazelcast.newHazelcastInstance(this.config) : Hazelcast.getOrCreateHazelcastInstance(this.config);
        return this.instance;
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.instance == null) {
            return;
        }
        if (!this.shutDown) {
            LOGGER.warning("hibernate.cache.hazelcast.shutdown_on_session_factory_close property is set to 'false'. Leaving current HazelcastInstance active! (Warning: Do not disable Hazelcast " + GroupProperty.SHUTDOWNHOOK_ENABLED + " property!)");
            return;
        }
        try {
            this.instance.getLifecycleService().shutdown();
            this.instance = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

