/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;

public final class HazelcastServerCachingProvider
extends AbstractHazelcastCachingProvider {
    public static HazelcastServerCachingProvider createCachingProvider(HazelcastInstance hazelcastInstance) {
        HazelcastServerCachingProvider cachingProvider = new HazelcastServerCachingProvider();
        cachingProvider.hazelcastInstance = hazelcastInstance;
        return cachingProvider;
    }

    protected HazelcastServerCacheManager createHazelcastCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        HazelcastInstance instance;
        boolean isDefaultURI = uri == null || uri.equals(this.getDefaultURI());
        try {
            instance = this.getOrCreateInstance(classLoader, properties, isDefaultURI);
            if (instance == null) {
                throw new IllegalArgumentException("Not available Hazelcast instance. Please specify your Hazelcast configuration file path via \"HazelcastCachingProvider.HAZELCAST_CONFIG_LOCATION\" property or specify Hazelcast instance name via \"HazelcastCachingProvider.HAZELCAST_INSTANCE_NAME\" property in \"properties\" parameter.");
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new HazelcastServerCacheManager(this, instance, uri, classLoader, properties);
    }

    private HazelcastInstance getOrCreateInstance(ClassLoader classLoader, Properties properties, boolean isDefaultURI) throws URISyntaxException, IOException {
        String location = properties.getProperty("hazelcast.config.location");
        String instanceName = properties.getProperty("hazelcast.instance.name");
        if (location != null) {
            URL configURL;
            ClassLoader theClassLoader;
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = new URI(System.getProperty(uri.getRawSchemeSpecificPart()));
            }
            ClassLoader classLoader2 = theClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
            if ("classpath".equals(scheme)) {
                configURL = theClassLoader.getResource(uri.getRawSchemeSpecificPart());
            } else if ("file".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) {
                configURL = uri.toURL();
            } else {
                throw new URISyntaxException(location, "Unsupported protocol in configuration location URL");
            }
            try {
                Config config = this.getConfig(configURL, theClassLoader, instanceName);
                return HazelcastInstanceFactory.getOrCreateHazelcastInstance(config);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (instanceName != null) {
            return Hazelcast.getHazelcastInstanceByName(instanceName);
        }
        HazelcastInstance instance = null;
        if (isDefaultURI) {
            if (this.hazelcastInstance == null) {
                this.hazelcastInstance = instance = Hazelcast.newHazelcastInstance();
            } else {
                instance = this.hazelcastInstance;
            }
        }
        return instance;
    }

    private Config getConfig(URL configURL, ClassLoader theClassLoader, String instanceName) throws IOException {
        Config config = new XmlConfigBuilder(configURL).build();
        config.setClassLoader(theClassLoader);
        if (instanceName != null) {
            config.setInstanceName(instanceName);
        } else if (config.getInstanceName() == null) {
            config.setInstanceName(configURL.toString());
        }
        return config;
    }

    public String toString() {
        return "HazelcastServerCachingProvider{hazelcastInstance=" + this.hazelcastInstance + '}';
    }
}

