/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.merge.entry;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class DefaultCacheEntryView
implements CacheEntryView<Data, Data>,
DataSerializable {
    private Data key;
    private Data value;
    private long expirationTime;
    private long lastAccessTime;
    private long accessHit;

    public DefaultCacheEntryView() {
    }

    public DefaultCacheEntryView(Data key, Data value, long expirationTime, long lastAccessTime, long accessHit) {
        this.key = key;
        this.value = value;
        this.expirationTime = expirationTime;
        this.lastAccessTime = lastAccessTime;
        this.accessHit = accessHit;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public Data getValue() {
        return this.value;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getAccessHit() {
        return this.accessHit;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.expirationTime);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.accessHit);
        out.writeData(this.key);
        out.writeData(this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.expirationTime = in.readLong();
        this.lastAccessTime = in.readLong();
        this.accessHit = in.readLong();
        this.key = in.readData();
        this.value = in.readData();
    }
}

