/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.query.QueryOperation;
import com.hazelcast.map.impl.query.QueryPartitionOperation;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.BitSetUtils;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

abstract class AbstractMapQueryRequest
extends InvocationClientRequest
implements Portable,
SecureRequest,
RetryableRequest {
    protected IterationType iterationType;
    private String name;

    AbstractMapQueryRequest() {
    }

    AbstractMapQueryRequest(String name, IterationType iterationType) {
        this.name = name;
        this.iterationType = iterationType;
    }

    @Override
    protected final void invoke() {
        QueryResult result = new QueryResult(this.iterationType, Long.MAX_VALUE);
        try {
            Predicate predicate = this.getPredicate();
            int partitionCount = this.getClientEngine().getPartitionService().getPartitionCount();
            BitSet finishedPartitions = this.invokeOnMembers(result, predicate, partitionCount);
            this.invokeOnMissingPartitions(result, predicate, finishedPartitions, partitionCount);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        this.getEndpoint().sendResponse(result, this.getCallId());
    }

    private BitSet invokeOnMembers(QueryResult result, Predicate predicate, int partitionCount) throws InterruptedException, ExecutionException {
        Collection<Member> members = this.getClientEngine().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        List<Future> futures = this.createInvocations(members, predicate);
        return this.collectResults(result, futures, partitionCount);
    }

    private void invokeOnMissingPartitions(QueryResult result, Predicate predicate, BitSet finishedPartitions, int partitionCount) throws InterruptedException, ExecutionException {
        if (this.hasMissingPartitions(finishedPartitions, partitionCount)) {
            List<Integer> missingList = this.findMissingPartitions(finishedPartitions, partitionCount);
            ArrayList<Future> missingFutures = new ArrayList<Future>(missingList.size());
            this.createInvocationsForMissingPartitions(missingList, missingFutures, predicate);
            this.collectResultsFromMissingPartitions(result, missingFutures);
        }
    }

    private List<Future> createInvocations(Collection<Member> members, Predicate predicate) {
        String mapName = this.name;
        ArrayList<Future> futures = new ArrayList<Future>(members.size());
        for (Member member : members) {
            QueryOperation operation = new QueryOperation(mapName, predicate, this.iterationType);
            InternalCompletableFuture future = this.createInvocationBuilder("hz:impl:mapService", (Operation)operation, member.getAddress()).invoke();
            futures.add(future);
        }
        return futures;
    }

    private MapOperationProvider getMapOperationProvider(String mapName) {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getMapOperationProvider(mapName);
    }

    private BitSet collectResults(QueryResult result, List<Future> futures, int partitionCount) throws InterruptedException, ExecutionException {
        BitSet finishedPartitions = new BitSet(partitionCount);
        for (Future future : futures) {
            Collection<Integer> partitionIds;
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null || BitSetUtils.hasAtLeastOneBitSet(finishedPartitions, partitionIds)) continue;
            BitSetUtils.setBits(finishedPartitions, partitionIds);
            result.addAllRows(queryResult.getRows());
        }
        return finishedPartitions;
    }

    private boolean hasMissingPartitions(BitSet finishedPartitions, int partitionCount) {
        return finishedPartitions.nextClearBit(0) < partitionCount;
    }

    private List<Integer> findMissingPartitions(BitSet finishedPartitions, int partitionCount) {
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        for (int i = 0; i < partitionCount; ++i) {
            if (finishedPartitions.get(i)) continue;
            missingList.add(i);
        }
        return missingList;
    }

    private void createInvocationsForMissingPartitions(List<Integer> missingPartitionsList, List<Future> futures, Predicate predicate) {
        for (Integer partitionId : missingPartitionsList) {
            QueryPartitionOperation op = new QueryPartitionOperation(this.name, predicate, this.iterationType);
            op.setPartitionId(partitionId);
            try {
                InternalCompletableFuture future = this.createInvocationBuilder("hz:impl:mapService", (Operation)op, partitionId).invoke();
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    private void collectResultsFromMissingPartitions(QueryResult result, List<Future> futures) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            QueryResult queryResult = (QueryResult)future.get();
            result.addAllRows(queryResult.getRows());
        }
    }

    @Override
    public final int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("t", this.iterationType.toString());
        this.writePortableInner(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.iterationType = IterationType.valueOf(reader.readUTF("t"));
        this.readPortableInner(reader);
    }

    protected abstract Predicate getPredicate();

    protected abstract void writePortableInner(PortableWriter var1) throws IOException;

    protected abstract void readPortableInner(PortableReader var1) throws IOException;
}

