/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.HashUtil;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class StaleReadPreventerNearCacheWrapper
implements NearCache,
KeyStateMarker {
    private final NearCache nearCache;
    private final int markCount;
    private volatile AtomicIntegerArray marks;

    private StaleReadPreventerNearCacheWrapper(NearCache nearCache, int markCount) {
        this.nearCache = nearCache;
        this.markCount = markCount;
        this.marks = new AtomicIntegerArray(markCount);
    }

    public static NearCache wrapAsStaleReadPreventerNearCache(NearCache nearCache, int markerCount) {
        return new StaleReadPreventerNearCacheWrapper(nearCache, markerCount);
    }

    @Override
    public String getName() {
        return this.nearCache.getName();
    }

    public Object get(Object key) {
        return this.nearCache.get(key);
    }

    public void put(Object key, Object value) {
        this.nearCache.put(key, value);
    }

    public boolean remove(Object key) {
        this.tryRemove(key);
        return this.nearCache.remove(key);
    }

    @Override
    public boolean isInvalidateOnChange() {
        return this.nearCache.isInvalidateOnChange();
    }

    @Override
    public void clear() {
        this.init();
        this.nearCache.clear();
    }

    @Override
    public void destroy() {
        this.init();
        this.nearCache.destroy();
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.nearCache.getInMemoryFormat();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCache.getNearCacheStats();
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        return this.nearCache.selectToSave(candidates);
    }

    @Override
    public int size() {
        return this.nearCache.size();
    }

    @Override
    public boolean tryMark(Object key) {
        return this.casState(key, KeyStateMarker.STATE.UNMARKED, KeyStateMarker.STATE.MARKED);
    }

    @Override
    public boolean tryUnmark(Object key) {
        return this.casState(key, KeyStateMarker.STATE.MARKED, KeyStateMarker.STATE.UNMARKED);
    }

    @Override
    public boolean tryRemove(Object key) {
        return this.casState(key, KeyStateMarker.STATE.MARKED, KeyStateMarker.STATE.REMOVED);
    }

    @Override
    public void forceUnmark(Object key) {
        int slot = this.getSlot(key);
        this.marks.set(slot, KeyStateMarker.STATE.UNMARKED.getState());
    }

    @Override
    public void init() {
        this.marks = new AtomicIntegerArray(this.markCount);
    }

    private boolean casState(Object key, KeyStateMarker.STATE expect, KeyStateMarker.STATE update) {
        int slot = this.getSlot(key);
        return this.marks.compareAndSet(slot, expect.getState(), update.getState());
    }

    private int getSlot(Object key) {
        int hash = key instanceof Data ? ((Data)key).getPartitionHash() : key.hashCode();
        return HashUtil.hashToIndex(hash, this.markCount);
    }

    public KeyStateMarker getKeyStateMarker() {
        return this;
    }
}

