/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceAlterAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceClearCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceContainsCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetAndAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceIsNullCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceSetAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceSetCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.util.Preconditions;

public class ClientAtomicReferenceProxy<E>
extends PartitionSpecificClientProxy
implements IAtomicReference<E> {
    public ClientAtomicReferenceProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    @Override
    public <R> R apply(IFunction<E, R> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicReferenceApplyCodec.encodeRequest(this.name, this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        AtomicReferenceApplyCodec.ResponseParameters resultParameters = AtomicReferenceApplyCodec.decodeResponse(response);
        return (R)this.toObject(resultParameters.response);
    }

    @Override
    public void alter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicReferenceAlterCodec.encodeRequest(this.name, this.toData(function));
        this.invokeOnPartition(request);
    }

    @Override
    public E alterAndGet(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicReferenceAlterAndGetCodec.encodeRequest(this.name, this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceAlterAndGetCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public E getAndAlter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicReferenceGetAndAlterCodec.encodeRequest(this.name, this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceGetAndAlterCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public boolean compareAndSet(E expect, E update) {
        ClientMessage request = AtomicReferenceCompareAndSetCodec.encodeRequest(this.name, this.toData(expect), this.toData(update));
        ClientMessage response = this.invokeOnPartition(request);
        return AtomicReferenceCompareAndSetCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public boolean contains(E expected) {
        ClientMessage request = AtomicReferenceContainsCodec.encodeRequest(this.name, this.toData(expected));
        ClientMessage response = this.invokeOnPartition(request);
        return AtomicReferenceContainsCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public E get() {
        ClientMessage request = AtomicReferenceGetCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceGetCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public void set(E newValue) {
        ClientMessage request = AtomicReferenceSetCodec.encodeRequest(this.name, this.toData(newValue));
        this.invokeOnPartition(request);
    }

    @Override
    public void clear() {
        ClientMessage request = AtomicReferenceClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    @Override
    public E getAndSet(E newValue) {
        ClientMessage request = AtomicReferenceGetAndSetCodec.encodeRequest(this.name, this.toData(newValue));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceGetAndSetCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public E setAndGet(E update) {
        ClientMessage request = AtomicReferenceSetAndGetCodec.encodeRequest(this.name, this.toData(update));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceSetAndGetCodec.decodeResponse((ClientMessage)response).response);
    }

    @Override
    public boolean isNull() {
        ClientMessage request = AtomicReferenceIsNullCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return AtomicReferenceIsNullCodec.decodeResponse((ClientMessage)response).response;
    }

    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

