/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapPutAllCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_PUTALL;
    public static final int RESPONSE_TYPE = 100;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Map<Data, Data> entries) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, entries);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(entries.size());
        for (Map.Entry<Data, Data> entry : entries.entrySet()) {
            Data key = entry.getKey();
            Data val = entry.getValue();
            clientMessage.set(key);
            clientMessage.set(val);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        HashMap<Data, Data> entries = null;
        int entries_size = clientMessage.getInt();
        entries = new HashMap<Data, Data>(entries_size);
        for (int entries_index = 0; entries_index < entries_size; ++entries_index) {
            Data entries_key = clientMessage.getData();
            Data entries_val = clientMessage.getData();
            entries.put(entries_key, entries_val);
        }
        parameters.entries = entries;
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Map<Data, Data> entries;

        public static int calculateDataSize(String name, Map<Data, Data> entries) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            for (Map.Entry<Data, Data> entry : entries.entrySet()) {
                Data key = entry.getKey();
                Data val = entry.getValue();
                dataSize += ParameterUtil.calculateDataSize(key);
                dataSize += ParameterUtil.calculateDataSize(val);
            }
            return dataSize;
        }
    }
}

