/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.nonblocking;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.nio.tcp.nonblocking.MigratableHandler;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadingModel;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;

public abstract class AbstractHandler
implements MigratableHandler {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final TcpIpConnection connection;
    protected final TcpIpConnectionManager connectionManager;
    protected final IOService ioService;
    protected Selector selector;
    protected NonBlockingIOThread ioThread;
    protected SelectionKey selectionKey;
    private final int initialOps;

    public AbstractHandler(TcpIpConnection connection, NonBlockingIOThread ioThread, int initialOps) {
        this.connection = connection;
        this.ioThread = ioThread;
        this.selector = ioThread.getSelector();
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.ioService = this.connectionManager.getIoService();
        this.logger = this.ioService.getLogger(this.getClass().getName());
        this.initialOps = initialOps;
    }

    @Override
    public NonBlockingIOThread getOwner() {
        return this.ioThread;
    }

    protected SelectionKey getSelectionKey() throws IOException {
        if (this.selectionKey == null) {
            this.selectionKey = this.socketChannel.register(this.selector, this.initialOps, this);
        }
        return this.selectionKey;
    }

    final void registerOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | operation);
    }

    final void unregisterOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() & ~operation);
    }

    @Override
    public void onFailure(Throwable e) {
        Level level;
        if (e instanceof OutOfMemoryError) {
            this.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.connection.close(e);
        ConnectionType connectionType = this.connection.getType();
        if (connectionType.isClient() && !connectionType.isBinary()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e);
        Level level2 = level = this.ioService.isActive() ? Level.WARNING : Level.FINEST;
        if (e instanceof IOException) {
            this.logger.log(level, sb.toString());
        } else {
            this.logger.log(level, sb.toString(), e);
        }
    }

    void startMigration(final NonBlockingIOThread newOwner) throws IOException {
        assert (this.ioThread == Thread.currentThread()) : "startMigration can only run on the owning NonBlockingIOThread";
        assert (this.ioThread != newOwner) : "newOwner can't be the same as the existing owner";
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.unregisterOp(this.initialOps);
        this.ioThread = newOwner;
        this.selectionKey.cancel();
        this.selectionKey = null;
        this.selector = null;
        newOwner.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractHandler.this.completeMigration(newOwner);
                }
                catch (Throwable t) {
                    AbstractHandler.this.onFailure(t);
                }
            }
        });
    }

    private void completeMigration(NonBlockingIOThread newOwner) throws IOException {
        assert (this.ioThread == newOwner);
        NonBlockingIOThreadingModel threadingModel = (NonBlockingIOThreadingModel)this.connection.getConnectionManager().getIoThreadingModel();
        threadingModel.getIOBalancer().signalMigrationComplete();
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.selector = newOwner.getSelector();
        this.selectionKey = this.getSelectionKey();
        this.registerOp(this.initialOps);
    }
}

