/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractClusterWideIterator;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.Iterator;
import javax.cache.Cache;

public class ClusterWideIterator<K, V>
extends AbstractClusterWideIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private final SerializationService serializationService;
    private final CacheProxy<K, V> cacheProxy;

    public ClusterWideIterator(CacheProxy<K, V> cache) {
        this(cache, 100);
    }

    public ClusterWideIterator(CacheProxy<K, V> cache, int fetchSize) {
        super(cache, cache.getNodeEngine().getPartitionService().getPartitionCount(), fetchSize);
        this.cacheProxy = cache;
        this.serializationService = cache.getNodeEngine().getSerializationService();
        this.advance();
    }

    @Override
    protected CacheKeyIteratorResult fetch() {
        Operation operation = this.cacheProxy.operationProvider.createKeyIteratorOperation(this.lastTableIndex, this.fetchSize);
        OperationService operationService = this.cacheProxy.getNodeEngine().getOperationService();
        InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:cacheService", operation, this.partitionIndex);
        return (CacheKeyIteratorResult)f.join();
    }

    @Override
    protected Data toData(Object obj) {
        return this.serializationService.toData(obj);
    }

    @Override
    protected <T> T toObject(Object data) {
        return this.serializationService.toObject(data);
    }
}

