/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractClusterWideIterator;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import javax.cache.Cache;

public class ClientClusterWideIterator<K, V>
extends AbstractClusterWideIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private ClientCacheProxy<K, V> cacheProxy;
    private ClientContext context;

    public ClientClusterWideIterator(ClientCacheProxy<K, V> cacheProxy, ClientContext context) {
        this(cacheProxy, context, 100);
    }

    public ClientClusterWideIterator(ClientCacheProxy<K, V> cacheProxy, ClientContext context, int fetchSize) {
        super(cacheProxy, context.getPartitionService().getPartitionCount(), fetchSize);
        this.cacheProxy = cacheProxy;
        this.context = context;
        this.advance();
    }

    @Override
    protected CacheKeyIteratorResult fetch() {
        ClientMessage request = CacheIterateCodec.encodeRequest(this.cacheProxy.getPrefixedName(), this.partitionIndex, this.lastTableIndex, this.fetchSize);
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        try {
            ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionIndex);
            ClientInvocationFuture f = clientInvocation.invoke();
            CacheIterateCodec.ResponseParameters responseParameters = CacheIterateCodec.decodeResponse((ClientMessage)f.get());
            return new CacheKeyIteratorResult(responseParameters.keys, responseParameters.tableIndex);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected Data toData(Object obj) {
        return this.context.getSerializationService().toData(obj);
    }

    @Override
    protected <T> T toObject(Object data) {
        return this.context.getSerializationService().toObject(data);
    }
}

