/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class ClientSmartListenerService
extends ClientListenerServiceImpl
implements InitialMembershipListener {
    private final Set<Member> members = new HashSet<Member>();
    private final Map<ClientRegistrationKey, Map<Address, ClientEventRegistration>> registrations = new ConcurrentHashMap<ClientRegistrationKey, Map<Address, ClientEventRegistration>>();
    private String membershipListenerId;

    public ClientSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                ClientSmartListenerService.this.registrations.put(registrationKey, new ConcurrentHashMap());
                try {
                    for (Member member : ClientSmartListenerService.this.members) {
                        ClientSmartListenerService.this.invoke(registrationKey, member.getAddress());
                    }
                }
                catch (Exception e) {
                    ClientSmartListenerService.this.deregisterListener(userRegistrationId);
                    throw new HazelcastException("Listener can not be added", e);
                }
                return userRegistrationId;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void invoke(ClientRegistrationKey registrationKey, Address address) throws Exception {
        ListenerMessageCodec codec = registrationKey.getCodec();
        ClientMessage request = codec.encodeAddRequest(true);
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientInvocation invocation = new ClientInvocation(this.client, request, address);
        invocation.setEventHandler(handler);
        String serverRegistrationId = codec.decodeAddResponse((ClientMessage)invocation.invoke().get());
        handler.onListenerRegister();
        long correlationId = request.getCorrelationId();
        ClientEventRegistration registration = new ClientEventRegistration(serverRegistrationId, correlationId, address, codec);
        Map<Address, ClientEventRegistration> registrationMap = this.registrations.get(registrationKey);
        registrationMap.put(address, registration);
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(key);
                if (registrationMap == null) {
                    return false;
                }
                boolean successful = true;
                for (ClientEventRegistration registration : registrationMap.values()) {
                    Address subscriber = registration.getSubscriber();
                    try {
                        ListenerMessageCodec listenerMessageCodec = registration.getCodec();
                        String serverRegistrationId = registration.getServerRegistrationId();
                        ClientMessage request = listenerMessageCodec.encodeRemoveRequest(serverRegistrationId);
                        new ClientInvocation(ClientSmartListenerService.this.client, request, subscriber).invoke().get();
                        ClientSmartListenerService.this.removeEventHandler(registration.getCallId());
                        registrationMap.remove(subscriber);
                    }
                    catch (Exception e) {
                        successful = false;
                        ClientSmartListenerService.this.logger.warning("Deregistration of listener with id " + userRegistrationId + " has failed to address " + subscriber, e);
                    }
                }
                if (successful) {
                    ClientSmartListenerService.this.registrations.remove(key);
                }
                return successful;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void start() {
        this.membershipListenerId = this.client.getClientClusterService().addMembershipListener(this);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.membershipListenerId != null) {
            this.client.getClientClusterService().removeMembershipListener(this.membershipListenerId);
        }
    }

    @Override
    public void memberAdded(final MembershipEvent membershipEvent) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Member member = membershipEvent.getMember();
                ClientSmartListenerService.this.members.add(member);
                for (ClientRegistrationKey registrationKey : ClientSmartListenerService.this.registrations.keySet()) {
                    try {
                        ClientSmartListenerService.this.invoke(registrationKey, member.getAddress());
                    }
                    catch (Exception e) {
                        ClientSmartListenerService.this.logger.warning("Listener " + registrationKey + " can not added to new member " + member);
                    }
                }
            }
        });
    }

    @Override
    public void memberRemoved(final MembershipEvent membershipEvent) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Member member = membershipEvent.getMember();
                ClientSmartListenerService.this.members.remove(member);
                for (Map registrationMap : ClientSmartListenerService.this.registrations.values()) {
                    ClientEventRegistration registration = (ClientEventRegistration)registrationMap.remove(member.getAddress());
                    ClientSmartListenerService.this.removeEventHandler(registration.getCallId());
                }
            }
        });
    }

    @Override
    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    @Override
    public void init(final InitialMembershipEvent event) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ClientSmartListenerService.this.members.addAll(event.getMembers());
                for (Member member : ClientSmartListenerService.this.members) {
                    for (ClientRegistrationKey registrationKey : ClientSmartListenerService.this.registrations.keySet()) {
                        try {
                            ClientSmartListenerService.this.invoke(registrationKey, member.getAddress());
                        }
                        catch (Exception e) {
                            ClientSmartListenerService.this.logger.warning("Listener " + registrationKey + " can not added to new member " + member);
                        }
                    }
                }
            }
        });
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() {
                ClientRegistrationKey key = new ClientRegistrationKey(uuid);
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(key);
                if (registrationMap == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                for (ClientEventRegistration registration : registrationMap.values()) {
                    for (Member member : ClientSmartListenerService.this.members) {
                        if (!member.getAddress().equals(registration.getSubscriber())) continue;
                        activeRegistrations.add(registration);
                    }
                }
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

