/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.ConditionInfo;
import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.operations.AwaitOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class LockResourceImpl
implements DataSerializable,
LockResource {
    private Data key;
    private String owner;
    private long threadId;
    private long referenceId;
    private int lockCount;
    private long expirationTime = -1L;
    private long acquireTime = -1L;
    private boolean transactional;
    private boolean blockReads;
    private Map<String, ConditionInfo> conditions;
    private List<ConditionKey> signalKeys;
    private List<AwaitOperation> expiredAwaitOps;
    private LockStoreImpl lockStore;
    private transient int version;

    public LockResourceImpl() {
    }

    public LockResourceImpl(Data key, LockStoreImpl lockStore) {
        this.key = key;
        this.lockStore = lockStore;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public boolean isLocked() {
        return this.lockCount > 0;
    }

    @Override
    public boolean isLockedBy(String owner, long threadId) {
        return this.threadId == threadId && owner != null && owner.equals(this.owner);
    }

    boolean lock(String owner, long threadId, long referenceId, long leaseTime, boolean transactional, boolean blockReads) {
        if (this.lockCount == 0) {
            this.owner = owner;
            this.threadId = threadId;
            this.referenceId = referenceId;
            this.lockCount = 1;
            this.acquireTime = Clock.currentTimeMillis();
            this.setExpirationTime(leaseTime);
            this.transactional = transactional;
            this.blockReads = blockReads;
            return true;
        }
        if (this.isLockedBy(owner, threadId)) {
            if (!transactional && this.referenceId == referenceId) {
                return true;
            }
            this.referenceId = referenceId;
            ++this.lockCount;
            this.setExpirationTime(leaseTime);
            this.transactional = transactional;
            this.blockReads = blockReads;
            return true;
        }
        return false;
    }

    boolean extendLeaseTime(String caller, long threadId, long leaseTime) {
        if (!this.isLockedBy(caller, threadId)) {
            return false;
        }
        this.blockReads = true;
        if (this.expirationTime < Long.MAX_VALUE) {
            this.setExpirationTime(this.expirationTime - Clock.currentTimeMillis() + leaseTime);
        }
        return true;
    }

    private void setExpirationTime(long leaseTime) {
        ++this.version;
        if (leaseTime < 0L) {
            this.expirationTime = Long.MAX_VALUE;
            this.lockStore.cancelEviction(this.key);
        } else {
            this.expirationTime = Clock.currentTimeMillis() + leaseTime;
            if (this.expirationTime < 0L) {
                this.expirationTime = Long.MAX_VALUE;
                this.lockStore.cancelEviction(this.key);
            } else {
                this.lockStore.scheduleEviction(this.key, this.version, leaseTime);
            }
        }
    }

    boolean unlock(String owner, long threadId, long referenceId) {
        if (this.lockCount == 0) {
            return false;
        }
        if (!this.isLockedBy(owner, threadId)) {
            return false;
        }
        if (!this.transactional && this.referenceId == referenceId) {
            return true;
        }
        this.referenceId = referenceId;
        --this.lockCount;
        if (this.lockCount == 0) {
            this.clear();
        }
        return true;
    }

    boolean canAcquireLock(String caller, long threadId) {
        return this.lockCount == 0 || this.getThreadId() == threadId && this.getOwner().equals(caller);
    }

    boolean addAwait(String conditionId, String caller, long threadId) {
        ConditionInfo condition;
        if (this.conditions == null) {
            this.conditions = new HashMap<String, ConditionInfo>(2);
        }
        if ((condition = this.conditions.get(conditionId)) == null) {
            condition = new ConditionInfo(conditionId);
            this.conditions.put(conditionId, condition);
        }
        return condition.addWaiter(caller, threadId);
    }

    boolean removeAwait(String conditionId, String caller, long threadId) {
        if (this.conditions == null) {
            return false;
        }
        ConditionInfo condition = this.conditions.get(conditionId);
        if (condition == null) {
            return false;
        }
        boolean ok = condition.removeWaiter(caller, threadId);
        if (condition.getAwaitCount() == 0) {
            this.conditions.remove(conditionId);
        }
        return ok;
    }

    boolean startAwaiting(String conditionId, String caller, long threadId) {
        if (this.conditions == null) {
            return false;
        }
        ConditionInfo condition = this.conditions.get(conditionId);
        if (condition == null) {
            return false;
        }
        return condition.startWaiter(caller, threadId);
    }

    int getAwaitCount(String conditionId) {
        if (this.conditions == null) {
            return 0;
        }
        ConditionInfo condition = this.conditions.get(conditionId);
        if (condition == null) {
            return 0;
        }
        return condition.getAwaitCount();
    }

    void registerSignalKey(ConditionKey conditionKey) {
        if (this.signalKeys == null) {
            this.signalKeys = new LinkedList<ConditionKey>();
        }
        this.signalKeys.add(conditionKey);
    }

    ConditionKey getSignalKey() {
        List<ConditionKey> keys = this.signalKeys;
        if (LockResourceImpl.isNullOrEmpty(keys)) {
            return null;
        }
        return keys.iterator().next();
    }

    void removeSignalKey(ConditionKey conditionKey) {
        if (this.signalKeys != null) {
            this.signalKeys.remove(conditionKey);
        }
    }

    void registerExpiredAwaitOp(AwaitOperation awaitResponse) {
        if (this.expiredAwaitOps == null) {
            this.expiredAwaitOps = new LinkedList<AwaitOperation>();
        }
        this.expiredAwaitOps.add(awaitResponse);
    }

    AwaitOperation pollExpiredAwaitOp() {
        List<AwaitOperation> ops = this.expiredAwaitOps;
        if (LockResourceImpl.isNullOrEmpty(ops)) {
            return null;
        }
        Iterator<AwaitOperation> iterator = ops.iterator();
        AwaitOperation awaitResponse = iterator.next();
        iterator.remove();
        return awaitResponse;
    }

    void clear() {
        this.threadId = 0L;
        this.lockCount = 0;
        this.owner = null;
        this.referenceId = 0L;
        this.expirationTime = 0L;
        this.acquireTime = -1L;
        this.cancelEviction();
        this.version = 0;
        this.transactional = false;
        this.blockReads = false;
    }

    void cancelEviction() {
        this.lockStore.cancelEviction(this.key);
    }

    boolean isRemovable() {
        return !this.isLocked() && LockResourceImpl.isNullOrEmpty(this.conditions) && LockResourceImpl.isNullOrEmpty(this.expiredAwaitOps);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public boolean shouldBlockReads() {
        return this.blockReads;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getLockCount() {
        return this.lockCount;
    }

    @Override
    public long getAcquireTime() {
        return this.acquireTime;
    }

    @Override
    public long getRemainingLeaseTime() {
        if (!this.isLocked()) {
            return -1L;
        }
        if (this.expirationTime < 0L) {
            return Long.MAX_VALUE;
        }
        long now = Clock.currentTimeMillis();
        if (now >= this.expirationTime) {
            return 0L;
        }
        return this.expirationTime - now;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    void setLockStore(LockStoreImpl lockStore) {
        this.lockStore = lockStore;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeData(this.key);
        out.writeUTF(this.owner);
        out.writeLong(this.threadId);
        out.writeLong(this.referenceId);
        out.writeInt(this.lockCount);
        out.writeLong(this.expirationTime);
        out.writeLong(this.acquireTime);
        out.writeBoolean(this.transactional);
        out.writeBoolean(this.blockReads);
        int conditionCount = this.getConditionCount();
        out.writeInt(conditionCount);
        if (conditionCount > 0) {
            for (ConditionInfo condition : this.conditions.values()) {
                condition.writeData(out);
            }
        }
        int signalCount = this.getSignalCount();
        out.writeInt(signalCount);
        if (signalCount > 0) {
            for (ConditionKey signalKey : this.signalKeys) {
                out.writeUTF(signalKey.getObjectName());
                out.writeUTF(signalKey.getConditionId());
            }
        }
        int expiredAwaitOpsCount = this.getExpiredAwaitsOpsCount();
        out.writeInt(expiredAwaitOpsCount);
        if (expiredAwaitOpsCount > 0) {
            for (AwaitOperation op : this.expiredAwaitOps) {
                op.writeData(out);
            }
        }
    }

    private int getExpiredAwaitsOpsCount() {
        return this.expiredAwaitOps == null ? 0 : this.expiredAwaitOps.size();
    }

    private int getSignalCount() {
        return this.signalKeys == null ? 0 : this.signalKeys.size();
    }

    private int getConditionCount() {
        return this.conditions == null ? 0 : this.conditions.size();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int i;
        this.key = in.readData();
        this.owner = in.readUTF();
        this.threadId = in.readLong();
        this.referenceId = in.readLong();
        this.lockCount = in.readInt();
        this.expirationTime = in.readLong();
        this.acquireTime = in.readLong();
        this.transactional = in.readBoolean();
        this.blockReads = in.readBoolean();
        int len = in.readInt();
        if (len > 0) {
            this.conditions = new HashMap<String, ConditionInfo>(len);
            for (i = 0; i < len; ++i) {
                ConditionInfo condition = new ConditionInfo();
                condition.readData(in);
                this.conditions.put(condition.getConditionId(), condition);
            }
        }
        if ((len = in.readInt()) > 0) {
            this.signalKeys = new ArrayList<ConditionKey>(len);
            for (i = 0; i < len; ++i) {
                this.signalKeys.add(new ConditionKey(in.readUTF(), this.key, in.readUTF()));
            }
        }
        if ((len = in.readInt()) > 0) {
            this.expiredAwaitOps = new ArrayList<AwaitOperation>(len);
            for (i = 0; i < len; ++i) {
                AwaitOperation op = new AwaitOperation();
                op.readData(in);
                this.expiredAwaitOps.add(op);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockResourceImpl that = (LockResourceImpl)o;
        if (this.threadId != that.threadId) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(that.owner) : that.owner != null);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (int)(this.threadId ^ this.threadId >>> 32);
        return result;
    }

    public String toString() {
        return "LockResource{owner='" + this.owner + '\'' + ", threadId=" + this.threadId + ", lockCount=" + this.lockCount + ", acquireTime=" + this.acquireTime + ", expirationTime=" + this.expirationTime + '}';
    }

    private static boolean isNullOrEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    private static boolean isNullOrEmpty(Map m) {
        return m == null || m.isEmpty();
    }
}

