/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.DefaultNodeExtension;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.lang.reflect.Constructor;
import java.util.Iterator;

@PrivateApi
public final class NodeExtensionFactory {
    private static final String FACTORY_ID = "com.hazelcast.instance.NodeExtension";

    private NodeExtensionFactory() {
    }

    public static NodeExtension create(Node node) {
        try {
            ClassLoader classLoader = node.getConfigClassLoader();
            Iterator iter = ServiceLoader.classIterator(FACTORY_ID, classLoader);
            while (iter.hasNext()) {
                Class clazz = iter.next();
                if (clazz.equals(DefaultNodeExtension.class)) continue;
                Constructor constructor = clazz.getDeclaredConstructor(Node.class);
                return (NodeExtension)constructor.newInstance(node);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultNodeExtension(node);
    }
}

