/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.util.Clock;
import com.hazelcast.util.Preconditions;

class ClusterStateLock {
    static final ClusterStateLock NOT_LOCKED = new ClusterStateLock();
    private final String transactionId;
    private final Address lockOwner;
    private final long lockExpiryTime;

    private ClusterStateLock() {
        this.lockOwner = null;
        this.transactionId = null;
        this.lockExpiryTime = 0L;
    }

    ClusterStateLock(Address lockOwner, String transactionId, long leaseTime) {
        Preconditions.checkNotNull(lockOwner);
        Preconditions.checkNotNull(transactionId);
        Preconditions.checkPositive(leaseTime, "Lease time should be positive!");
        this.lockOwner = lockOwner;
        this.transactionId = transactionId;
        this.lockExpiryTime = ClusterStateLock.toLockExpiry(leaseTime);
    }

    private static long toLockExpiry(long leaseTime) {
        long expiryTime = Clock.currentTimeMillis() + leaseTime;
        if (expiryTime < 0L) {
            expiryTime = Long.MAX_VALUE;
        }
        return expiryTime;
    }

    boolean isLocked() {
        return this.lockOwner != null;
    }

    boolean isLeaseExpired() {
        boolean expired = false;
        if (this.lockExpiryTime > 0L && Clock.currentTimeMillis() > this.lockExpiryTime) {
            expired = true;
        }
        return expired;
    }

    boolean allowsLock(String txnId) {
        Preconditions.checkNotNull(txnId);
        boolean notLocked = this.isLeaseExpired() || !this.isLocked();
        return notLocked || this.allowsUnlock(txnId);
    }

    boolean allowsUnlock(String txnId) {
        Preconditions.checkNotNull(txnId);
        return txnId.equals(this.transactionId);
    }

    Address getLockOwner() {
        return this.lockOwner;
    }

    String getTransactionId() {
        return this.transactionId;
    }

    long getLockExpiryTime() {
        return this.lockExpiryTime;
    }

    public String toString() {
        return "ClusterStateLock{lockOwner=" + this.lockOwner + ", transactionId='" + this.transactionId + '\'' + ", lockExpiryTime=" + this.lockExpiryTime + '}';
    }
}

