/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction.impl.evaluator;

import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.EvictionPolicyComparator;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.util.Clock;
import java.util.Collections;
import java.util.Set;

public class DefaultEvictionPolicyEvaluator<A, E extends Evictable>
implements EvictionPolicyEvaluator<A, E> {
    private final EvictionPolicyComparator evictionPolicyComparator;

    public DefaultEvictionPolicyEvaluator(EvictionPolicyComparator evictionPolicyComparator) {
        this.evictionPolicyComparator = evictionPolicyComparator;
    }

    @Override
    public EvictionPolicyComparator getEvictionPolicyComparator() {
        return this.evictionPolicyComparator;
    }

    @Override
    public <C extends EvictionCandidate<A, E>> Iterable<C> evaluate(Iterable<C> evictionCandidates) {
        EvictionCandidate selectedEvictionCandidate = null;
        long now = Clock.currentTimeMillis();
        for (EvictionCandidate currentEvictionCandidate : evictionCandidates) {
            if (selectedEvictionCandidate == null) {
                selectedEvictionCandidate = currentEvictionCandidate;
                continue;
            }
            Object evictable = currentEvictionCandidate.getEvictable();
            if (evictable == null) continue;
            if (this.isExpired(now, (Evictable)evictable)) {
                return currentEvictionCandidate instanceof Iterable ? (Set<EvictionCandidate>)((Object)currentEvictionCandidate) : Collections.singleton(currentEvictionCandidate);
            }
            int comparisonResult = this.evictionPolicyComparator.compare(selectedEvictionCandidate, currentEvictionCandidate);
            if (comparisonResult != 1) continue;
            selectedEvictionCandidate = currentEvictionCandidate;
        }
        if (selectedEvictionCandidate == null) {
            return null;
        }
        return selectedEvictionCandidate instanceof Iterable ? (Set<Object>)((Object)selectedEvictionCandidate) : Collections.singleton(selectedEvictionCandidate);
    }

    private boolean isExpired(long now, Evictable evictable) {
        if (evictable instanceof Expirable) {
            Expirable expirable = (Expirable)((Object)evictable);
            return expirable.isExpiredAt(now);
        }
        return false;
    }
}

